/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.git;

import java.io.File;
import org.jmeld.util.Result;
import org.jmeld.vc.BaseFile;
import org.jmeld.vc.util.VcCmd;

public class CatCmd
extends VcCmd<BaseFile> {
    private File file;
    private String reference;

    public CatCmd(File file) {
        this(file, "HEAD");
    }

    public CatCmd(File file, String reference) {
        this.file = file;
        this.reference = reference;
        this.initWorkingDirectory(file);
    }

    public Result execute() {
        super.execute("git", "show", this.getReferencePoint() + ":" + this.file.getName());
        return this.getResult();
    }

    private String getReferencePoint() {
        if (this.reference.equals("index")) {
            return "";
        }
        if (this.reference.equals("worktree")) {
            return "";
        }
        return this.reference;
    }

    @Override
    protected void build(byte[] data) {
        this.setResultData(new BaseFile(data));
    }
}

