/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.git;

import java.io.File;
import java.util.Vector;
import org.jmeld.vc.BaseFile;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.VersionControlIF;
import org.jmeld.vc.git.ActiveCmd;
import org.jmeld.vc.git.BranchCmd;
import org.jmeld.vc.git.BranchData;
import org.jmeld.vc.git.CatCmd;
import org.jmeld.vc.git.InstalledCmd;
import org.jmeld.vc.git.LogCmd;
import org.jmeld.vc.git.LogData;
import org.jmeld.vc.git.StatusCmd;
import org.jmeld.vc.git.TagCmd;
import org.jmeld.vc.git.TagData;

public class GitVersionControl
implements VersionControlIF {
    private Boolean installed;
    private String reference;
    public static final String SEPARATOR = "SEPARATOR";

    public GitVersionControl() {
        this.setReference("HEAD");
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public String getName() {
        return "git";
    }

    @Override
    public boolean isInstalled() {
        if (this.installed == null) {
            InstalledCmd cmd = new InstalledCmd();
            cmd.execute();
            this.installed = cmd.getResult().isTrue();
        }
        return this.installed;
    }

    @Override
    public boolean isEnabled(File file) {
        ActiveCmd cmd = new ActiveCmd(file);
        cmd.execute();
        return cmd.getResult().isTrue();
    }

    @Override
    public StatusResult executeStatus(File file) {
        StatusCmd cmd = new StatusCmd(file, this.reference);
        cmd.execute();
        return (StatusResult)cmd.getResultData();
    }

    @Override
    public BaseFile getBaseFile(File file) {
        CatCmd cmd = new CatCmd(file, this.getReference());
        cmd.execute();
        return (BaseFile)cmd.getResultData();
    }

    @Override
    public Vector<String> getRevisions(File file) {
        Vector<String> revisions = new Vector<String>();
        revisions.add("worktree");
        revisions.add("HEAD");
        revisions.add("index");
        revisions.add(SEPARATOR);
        BranchCmd branchCmd = new BranchCmd(file);
        branchCmd.execute();
        revisions.addAll(((BranchData)branchCmd.getResultData()).getBranchs());
        revisions.add(SEPARATOR);
        TagCmd tagCmd = new TagCmd(file);
        tagCmd.execute();
        revisions.addAll(((TagData)tagCmd.getResultData()).getTags());
        revisions.add(SEPARATOR);
        LogCmd logCmd = new LogCmd(file);
        logCmd.execute();
        revisions.addAll(((LogData)logCmd.getResultData()).getRevisions());
        return revisions;
    }

    public String toString() {
        return this.getName();
    }
}

