/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.git;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jmeld.util.Result;
import org.jmeld.vc.git.LogData;
import org.jmeld.vc.util.VcCmd;

public class LogCmd
extends VcCmd<LogData> {
    private File file;

    public LogCmd(File file) {
        this.file = file;
        this.initWorkingDirectory(file);
    }

    public Result execute() {
        super.execute("git", "log", "--oneline", "--all");
        return this.getResult();
    }

    @Override
    protected void build(byte[] data) {
        LogData logData = new LogData();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String text;
            while ((text = reader.readLine()) != null) {
                String revision = text.substring(0, 7);
                logData.add(revision);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setResultData(logData);
    }

    public static void main(String[] args) {
        File file = LogCmd.parseFile(args);
        if (file == null) {
            return;
        }
        LogCmd cmd = new LogCmd(file);
        if (cmd.execute().isTrue()) {
            for (String revision : ((LogData)cmd.getResultData()).getRevisions()) {
                System.out.println(revision);
            }
        } else {
            cmd.printError();
        }
    }
}

