/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.git;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jmeld.util.Result;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.git.GitVersionControl;
import org.jmeld.vc.util.VcCmd;

public class StatusCmd
extends VcCmd<StatusResult> {
    private StatusResult statusResult;
    private String reference;
    private File file;
    private Phase phase;
    private File actualfile;

    public StatusCmd(File file, String reference) {
        this.file = file;
        this.reference = reference;
        this.initWorkingDirectory(file);
    }

    public Result execute() {
        this.phase = Phase.state;
        this.statusResult = this.phase == Phase.state ? new StatusResult(this.workingDirectory) : (StatusResult)this.getResultData();
        File[] files = this.file.isDirectory() ? this.file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory() || !pathname.getName().equals(".git");
            }
        }) : new File[]{this.file};
        File[] fileArray = files;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file;
            this.actualfile = file = fileArray[i];
            this.processFile();
        }
        return this.getResult();
    }

    private Result processFile() {
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add("git");
        commandArgs.add("diff");
        if (!"worktree".equals(this.reference)) {
            commandArgs.add(this.getReferencePoint());
        }
        commandArgs.add("--name-status");
        commandArgs.add(this.actualfile.getAbsolutePath());
        return this._execute(commandArgs.toArray(new String[4]));
    }

    private String getReferencePoint() {
        if ("index".equals(this.reference)) {
            return "--cached";
        }
        return this.reference;
    }

    @Override
    protected void build(byte[] data) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String text;
            boolean changes = false;
            while ((text = reader.readLine()) != null) {
                StatusResult.Status status;
                changes = true;
                if (this.phase != Phase.state) continue;
                if (text.isEmpty()) {
                    status = StatusResult.Status.unmodified;
                    this.statusResult.addEntry(this.actualfile.getName(), status);
                    continue;
                }
                char statusChar = text.charAt(0);
                switch (statusChar) {
                    case 'M': {
                        status = StatusResult.Status.modified;
                        break;
                    }
                    case 'A': {
                        status = StatusResult.Status.added;
                        break;
                    }
                    case 'D': {
                        status = StatusResult.Status.removed;
                        break;
                    }
                    case 'R': {
                        status = StatusResult.Status.renamed;
                        break;
                    }
                    case 'U': {
                        status = StatusResult.Status.updated;
                        break;
                    }
                    case 'C': {
                        status = StatusResult.Status.copied;
                        break;
                    }
                    case '!': {
                        status = StatusResult.Status.ignored;
                        break;
                    }
                    case '?': {
                        status = StatusResult.Status.unversioned;
                        break;
                    }
                    case ' ': {
                        status = StatusResult.Status.unversioned;
                        break;
                    }
                    default: {
                        status = StatusResult.Status.unmodified;
                    }
                }
                this.statusResult.addEntry(text.substring(2), status);
            }
            if (!changes) {
                this.statusResult.addEntry(this.actualfile.getName(), StatusResult.Status.unmodified);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setResultData(this.statusResult);
    }

    public static void main(String[] args) {
        File file = StatusCmd.parseFile(args);
        if (file == null) {
            return;
        }
        StatusResult result = new GitVersionControl().executeStatus(file);
        if (result != null) {
            for (StatusResult.Entry entry : result.getEntryList()) {
                System.out.println(entry.getStatus().getShortText() + " " + entry.getName());
            }
        }
    }

    private static enum Phase {
        state;

    }
}

