/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.git;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jmeld.util.Result;
import org.jmeld.vc.git.TagData;
import org.jmeld.vc.util.VcCmd;

public class TagCmd
extends VcCmd<TagData> {
    private File file;

    public TagCmd(File file) {
        this.file = file;
        this.initWorkingDirectory(file);
    }

    public Result execute() {
        super.execute("git", "tag");
        return this.getResult();
    }

    @Override
    protected void build(byte[] data) {
        TagData tagData = new TagData();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String text;
            while ((text = reader.readLine()) != null) {
                String tag = text;
                tagData.add(tag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setResultData(tagData);
    }

    public static void main(String[] args) {
        File file = TagCmd.parseFile(args);
        if (file == null) {
            return;
        }
        TagCmd cmd = new TagCmd(file);
        if (cmd.execute().isTrue()) {
            for (String tag : ((TagData)cmd.getResultData()).getTags()) {
                System.out.println(tag);
            }
        } else {
            cmd.printError();
        }
    }
}

