/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.hg;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jmeld.util.Result;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.hg.MercurialVersionControl;
import org.jmeld.vc.util.VcCmd;

public class StatusCmd
extends VcCmd<StatusResult> {
    private File file;

    public StatusCmd(File file) {
        this.file = file;
        this.initWorkingDirectory(file);
    }

    public Result execute() {
        super.execute("hg", "status", "-m", "-a", "-r", "-d", "-c", "-u", "--noninteractive", this.file.getAbsolutePath());
        return this.getResult();
    }

    @Override
    protected void build(byte[] data) {
        StatusResult statusResult = new StatusResult(this.file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String text;
            while ((text = reader.readLine()) != null) {
                if (text.length() < 3) continue;
                StatusResult.Status status = null;
                switch (text.charAt(0)) {
                    case 'M': {
                        status = StatusResult.Status.modified;
                        break;
                    }
                    case 'A': {
                        status = StatusResult.Status.added;
                        break;
                    }
                    case 'R': {
                        status = StatusResult.Status.removed;
                        break;
                    }
                    case 'C': {
                        status = StatusResult.Status.clean;
                        break;
                    }
                    case '!': {
                        status = StatusResult.Status.missing;
                        break;
                    }
                    case '?': {
                        status = StatusResult.Status.unversioned;
                        break;
                    }
                    case 'I': {
                        status = StatusResult.Status.ignored;
                        break;
                    }
                    case ' ': {
                        status = StatusResult.Status.clean;
                    }
                }
                statusResult.addEntry(text.substring(2), status);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setResultData(statusResult);
    }

    public static void main(String[] args) {
        File file = StatusCmd.parseFile(args);
        if (file == null) {
            return;
        }
        StatusResult result = new MercurialVersionControl().executeStatus(file);
        if (result != null) {
            for (StatusResult.Entry entry : result.getEntryList()) {
                System.out.println(entry.getStatus().getShortText() + " " + entry.getName());
            }
        }
    }
}

