/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.svn;

import java.io.File;
import org.jmeld.util.Result;
import org.jmeld.vc.BlameIF;
import org.jmeld.vc.svn.BlameData;
import org.jmeld.vc.svn.SvnXmlCmd;

public class BlameCmd
extends SvnXmlCmd<BlameData> {
    private File file;

    public BlameCmd(File file) {
        super(BlameData.class);
        this.file = file;
    }

    public Result execute() {
        super.execute("svn", "blame", "--non-interactive", "--xml", this.file.getPath());
        return this.getResult();
    }

    public BlameIF getBlame() {
        return (BlameIF)this.getResultData();
    }

    public static void main(String[] args) {
        File file = BlameCmd.parseFile(args);
        if (file == null) {
            return;
        }
        BlameCmd cmd = new BlameCmd(file);
        if (cmd.execute().isTrue()) {
            for (BlameIF.TargetIF targetIF : cmd.getBlame().getTargetList()) {
                for (BlameIF.EntryIF entryIF : targetIF.getEntryList()) {
                    System.out.println(entryIF.getLineNumber() + " : " + entryIF.getCommit().getRevision() + " -> " + entryIF.getCommit().getAuthor());
                }
            }
        } else {
            cmd.printError();
        }
    }
}

