/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.svn;

import java.io.File;
import org.jmeld.util.Result;
import org.jmeld.vc.BaseFile;
import org.jmeld.vc.svn.SubversionVersionControl;
import org.jmeld.vc.util.VcCmd;

public class CatCmd
extends VcCmd<BaseFile> {
    private File file;

    public CatCmd(File file) {
        this.file = file;
    }

    public Result execute() {
        super.execute("svn", "cat", "--non-interactive", "-r", "BASE", this.file.getPath());
        return this.getResult();
    }

    @Override
    protected void build(byte[] data) {
        this.setResultData(new BaseFile(data));
    }

    public static void main(String[] args) {
        File file = CatCmd.parseFile(args);
        if (file == null) {
            return;
        }
        try {
            BaseFile result = new SubversionVersionControl().getBaseFile(file);
            byte[] byteArray = result.getByteArray();
            System.out.write(byteArray, 0, byteArray.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

