/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.svn;

import java.io.File;
import org.jmeld.util.Result;
import org.jmeld.vc.svn.LogData;
import org.jmeld.vc.svn.SvnXmlCmd;

public class LogCmd
extends SvnXmlCmd<LogData> {
    private File file;

    public LogCmd(File file) {
        super(LogData.class);
        this.file = file;
    }

    public Result execute() {
        super.execute("svn", "log", "--non-interactive", "-v", "--xml", this.file.getPath());
        return this.getResult();
    }

    public static void main(String[] args) {
        File file = LogCmd.parseFile(args);
        if (file == null) {
            return;
        }
        LogCmd cmd = new LogCmd(file);
        if (cmd.execute().isTrue()) {
            for (LogData.Entry entry : ((LogData)cmd.getResultData()).getEntryList()) {
                System.out.println(entry.getRevision() + " : " + entry.getDate());
                for (LogData.Path path : entry.getPathList()) {
                    System.out.println("  " + path.getPathName());
                }
            }
        } else {
            cmd.printError();
        }
    }
}

