/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.svn;

import java.io.File;
import org.jmeld.util.Result;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.svn.StatusData;
import org.jmeld.vc.svn.SubversionVersionControl;
import org.jmeld.vc.svn.SvnXmlCmd;

public class StatusCmd
extends SvnXmlCmd<StatusData> {
    private File file;
    private boolean recursive;

    public StatusCmd(File file, boolean recursive) {
        super(StatusData.class);
        this.file = file;
        this.recursive = recursive;
    }

    public Result execute() {
        super.execute("svn", "status", "--non-interactive", "-v", "--xml", this.recursive ? "" : "-N", this.file.getPath());
        return this.getResult();
    }

    public StatusResult getStatusResult() {
        StatusData sd = (StatusData)this.getResultData();
        StatusResult result = new StatusResult(this.file);
        if (sd != null) {
            for (StatusData.Target t : sd.getTargetList()) {
                for (StatusData.Entry te : t.getEntryList()) {
                    StatusResult.Status status = null;
                    switch (te.getWcStatus().getItem()) {
                        case added: {
                            status = StatusResult.Status.added;
                            break;
                        }
                        case conflicted: {
                            status = StatusResult.Status.conflicted;
                            break;
                        }
                        case deleted: {
                            status = StatusResult.Status.removed;
                            break;
                        }
                        case ignored: {
                            status = StatusResult.Status.ignored;
                            break;
                        }
                        case modified: {
                            status = StatusResult.Status.modified;
                            break;
                        }
                        case replaced: {
                            status = StatusResult.Status.modified;
                            break;
                        }
                        case external: {
                            status = StatusResult.Status.dontknow;
                            break;
                        }
                        case unversioned: {
                            status = StatusResult.Status.unversioned;
                            break;
                        }
                        case incomplete: {
                            status = StatusResult.Status.missing;
                            break;
                        }
                        case obstructed: {
                            status = StatusResult.Status.dontknow;
                            break;
                        }
                        case normal: {
                            status = StatusResult.Status.clean;
                            break;
                        }
                        case none: {
                            status = StatusResult.Status.clean;
                            break;
                        }
                        case missing: {
                            status = StatusResult.Status.missing;
                        }
                    }
                    result.addEntry(te.getPath(), status);
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        File file = StatusCmd.parseFile(args);
        if (file == null) {
            return;
        }
        StatusResult result = new SubversionVersionControl().executeStatus(file);
        if (result != null) {
            for (StatusResult.Entry entry : result.getEntryList()) {
                System.out.println(entry.getStatus().getShortText() + " " + entry.getName());
            }
        }
    }
}

