/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.svn;

import java.io.File;
import java.util.Vector;
import org.jmeld.vc.BaseFile;
import org.jmeld.vc.BlameIF;
import org.jmeld.vc.DiffIF;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.VersionControlIF;
import org.jmeld.vc.svn.ActiveCmd;
import org.jmeld.vc.svn.BlameCmd;
import org.jmeld.vc.svn.CatCmd;
import org.jmeld.vc.svn.DiffCmd;
import org.jmeld.vc.svn.InstalledCmd;
import org.jmeld.vc.svn.StatusCmd;

public class SubversionVersionControl
implements VersionControlIF {
    private Boolean installed;
    private String reference;

    public SubversionVersionControl() {
        this.setReference("HEAD");
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public String getName() {
        return "subversion";
    }

    @Override
    public boolean isInstalled() {
        if (this.installed == null) {
            InstalledCmd cmd = new InstalledCmd();
            cmd.execute();
            this.installed = cmd.getResult().isTrue();
        }
        return this.installed;
    }

    @Override
    public boolean isEnabled(File file) {
        ActiveCmd cmd = new ActiveCmd(file);
        cmd.execute();
        return cmd.getResult().isTrue();
    }

    public BlameIF executeBlame(File file) {
        BlameCmd cmd = new BlameCmd(file);
        cmd.execute();
        return (BlameIF)cmd.getResultData();
    }

    public DiffIF executeDiff(File file, boolean recursive) {
        DiffCmd cmd = new DiffCmd(file, recursive);
        cmd.execute();
        return (DiffIF)cmd.getResultData();
    }

    @Override
    public StatusResult executeStatus(File file) {
        StatusCmd cmd = new StatusCmd(file, true);
        cmd.execute();
        return cmd.getStatusResult();
    }

    @Override
    public BaseFile getBaseFile(File file) {
        CatCmd cmd = new CatCmd(file);
        cmd.execute();
        return (BaseFile)cmd.getResultData();
    }

    @Override
    public Vector<String> getRevisions(File file) {
        Vector<String> revisions = new Vector<String>();
        revisions.add("HEAD");
        return revisions;
    }

    public String toString() {
        return this.getName();
    }
}

