/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.jmeld.util.Result;

public abstract class VcCmd<T> {
    private static boolean debug = true;
    private Result result;
    private T resultData;
    protected File workingDirectory;

    public void initWorkingDirectory(File file) {
        if (!(file = file.getAbsoluteFile()).isDirectory()) {
            file = file.getParentFile();
        }
        this.workingDirectory = file.isDirectory() ? file : null;
    }

    public void execute(String ... command) {
        this.setResult(this._execute(command));
    }

    protected final Result _execute(String ... command) {
        try {
            int count;
            ProcessBuilder pb = new ProcessBuilder(command);
            this.debug("execute: " + Arrays.asList(command));
            System.out.println("wd2=" + pb.directory());
            if (this.workingDirectory != null) {
                pb = pb.directory(this.workingDirectory);
                System.out.println("wd=" + this.workingDirectory);
            }
            Process p = pb.start();
            byte[] data = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream is = new BufferedInputStream(p.getInputStream());
            while ((count = ((InputStream)is).read(data, 0, data.length)) != -1) {
                baos.write(data, 0, count);
            }
            ((InputStream)is).close();
            p.waitFor();
            this.debug("  exitValue = " + p.exitValue());
            if (p.exitValue() != 0) {
                String text;
                StringBuilder errorText = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((text = br.readLine()) != null) {
                    errorText.append(text);
                }
                br.close();
                return Result.FALSE(errorText.toString() + " (exitvalue=" + p.exitValue() + ")");
            }
            this.build(baos.toByteArray());
            baos.close();
        }
        catch (Exception ex) {
            this.result = Result.FALSE(ex.getMessage(), ex);
            return this.result;
        }
        return Result.TRUE();
    }

    protected abstract void build(byte[] var1);

    public void printError() {
        System.out.println(this.result.getDescription());
        if (this.result.hasException()) {
            this.result.getException().printStackTrace();
        }
    }

    public Result getResult() {
        return this.result;
    }

    protected void setResult(Result result) {
        this.result = result;
    }

    protected void setResultData(T resultData) {
        this.resultData = resultData;
    }

    public T getResultData() {
        return this.resultData;
    }

    private void debug(String text) {
        if (debug) {
            System.out.println(text);
        }
    }

    public static final File parseFile(String[] args) {
        return VcCmd.parseFile(args, 0);
    }

    public static final File parseFile(String[] args, int pos) {
        int arglength = pos + 1;
        if (args.length < arglength) {
            System.err.printf("few arguments given. At least %d is required%n", arglength);
            return null;
        }
        String filename = args[pos];
        File file = new File(filename);
        if (!file.exists()) {
            System.err.printf("File %s not exists%n", filename);
            return null;
        }
        return file;
    }
}

