/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.MappingException;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.I18NBaseObject;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.UICallbacks;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.AnalysisEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.CopyTableListener;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.ErrorEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.RecordEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.StatementEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.event.TableEvent;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.DBCopyPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.PreferencesManager;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.DBUtil;

public class CopyExecutor
extends I18NBaseObject {
    private static final ILogger s_log = LoggerController.createLogger(CopyExecutor.class);
    SessionInfoProvider prov = null;
    ISession sourceSession = null;
    ISession destSession = null;
    private Thread execThread = null;
    private boolean originalAutoCommitValue = true;
    private boolean currentAutoCommitValue = true;
    private static DBCopyPreferenceBean prefs = PreferencesManager.getPreferences();
    private static final ILogger log = LoggerController.createLogger(CopyExecutor.class);
    private ArrayList<ITableInfo> selectedTableInfos = null;
    private ArrayList<CopyTableListener> listeners = new ArrayList();
    private volatile boolean cancelled = false;
    private UICallbacks pref = null;
    private long start = 0L;
    private long end = 0L;

    public CopyExecutor(SessionInfoProvider p) {
        this.prov = p;
        this.sourceSession = this.prov.getSourceSession();
        this.destSession = this.prov.getDestSession();
    }

    public void execute() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CopyExecutor.this._execute();
            }
        };
        this.execThread = new Thread(runnable);
        this.execThread.setName("DBCopy Executor Thread");
        this.execThread.start();
    }

    public void cancel() {
        this.cancelled = true;
        this.execThread.interrupt();
    }

    private void _execute() {
        this.start = System.currentTimeMillis();
        boolean encounteredException = false;
        ISQLConnection destConn = this.destSession.getSQLConnection();
        if (!this.analyzeTables()) {
            return;
        }
        this.setupAutoCommit(destConn);
        List<IDatabaseObjectInfo> sourceObjs = this.prov.getSourceDatabaseObjects();
        int[] counts = this.getTableCounts();
        this.sendCopyStarted(counts);
        String destSchema = DBUtil.getSchemaNameFromDbObject(this.prov.getDestDatabaseObject());
        String destCatalog = this.prov.getDestDatabaseObject().getCatalogName();
        TableInfo pasteToTableInfo = this.prov.getPasteToTableInfo(destConn, destSchema, destCatalog);
        this.execDeletes(sourceObjs, destCatalog, destSchema, pasteToTableInfo);
        int sourceObjectCount = 0;
        for (IDatabaseObjectInfo info : sourceObjs) {
            block13: {
                if (!(info instanceof ITableInfo)) continue;
                ITableInfo sourceTI = (ITableInfo)info;
                this.sendTableCopyStarted(this.chooseDestTableInfo(sourceTI, pasteToTableInfo), sourceObjectCount + 1);
                try {
                    int destTableCount = DBUtil.getTableCount(this.destSession, destCatalog, destSchema, this.chooseDestTableInfo(sourceTI, pasteToTableInfo).getSimpleName(), 1, this.prov.getWhereClause());
                    if (destTableCount == -1) {
                        this.createTable(sourceTI, this.chooseDestTableInfo(sourceTI, pasteToTableInfo).getSimpleName(), destSchema, destCatalog);
                    }
                    this.copyTable(sourceTI, pasteToTableInfo, counts[sourceObjectCount]);
                    if (sourceObjectCount == sourceObjs.size() - 1 && !this.cancelled) {
                        this.copyConstraints(sourceObjs);
                    }
                    if (this.cancelled) break block13;
                    this.sendTableCopyFinished(this.chooseDestTableInfo(sourceTI, pasteToTableInfo), sourceObjectCount + 1);
                    this.sleep(prefs.getTableDelayMillis());
                }
                catch (SQLException e) {
                    encounteredException = true;
                    this.sendErrorEvent(2, e);
                    break;
                }
                catch (MappingException e) {
                    encounteredException = true;
                    this.sendErrorEvent(3, (Exception)((Object)e));
                    break;
                }
                catch (UserCancelledOperationException e) {
                    this.cancelled = true;
                    break;
                }
                catch (Exception e) {
                    encounteredException = true;
                    this.sendErrorEvent(5, e);
                    break;
                }
            }
            ++sourceObjectCount;
        }
        this.restoreAutoCommit(destConn);
        if (this.cancelled) {
            this.sendErrorEvent(4);
            return;
        }
        if (encounteredException) {
            try {
                this.reloadObjectTree();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.end = System.currentTimeMillis();
        this.reloadObjectTree();
        this.notifyCopyFinished();
    }

    private void execDeletes(List<IDatabaseObjectInfo> sourceObjs, String destCatalog, String destSchema, TableInfo pasteToTableInfo) {
        try {
            if (this.pref.appendRecordsToExisting()) {
                return;
            }
            ArrayList<ITableInfo> destTablesToEmpty = new ArrayList<ITableInfo>();
            for (IDatabaseObjectInfo sourceObj : sourceObjs) {
                ITableInfo sourceTI;
                ITableInfo destTableInfo;
                int destTableCount;
                if (!(sourceObj instanceof ITableInfo) || (destTableCount = DBUtil.getTableCount(this.destSession, destCatalog, destSchema, (destTableInfo = this.chooseDestTableInfo(sourceTI = (ITableInfo)sourceObj, pasteToTableInfo)).getSimpleName(), 1, this.prov.getWhereClause())) <= 0) continue;
                destTablesToEmpty.add(destTableInfo);
            }
            if (destTablesToEmpty.isEmpty()) {
                return;
            }
            Collections.reverse(destTablesToEmpty);
            for (ITableInfo toEmpty : destTablesToEmpty) {
                if (!this.pref.deleteTableData(toEmpty.getSimpleName())) continue;
                DBUtil.deleteDataInExistingTable(this.destSession, destCatalog, destSchema, toEmpty.getSimpleName());
            }
        }
        catch (UserCancelledOperationException e) {
            this.cancelled = true;
        }
        catch (SQLException e) {
            throw Utilities.wrapRuntime((Throwable)e);
        }
    }

    private void reloadObjectTree() {
        ISession session = this.prov.getDestSession();
        if (session.getSessionPanel() != null) {
            session.getSchemaInfo().reload(DBUtil.getSchemaFromDbObject(this.prov.getDestDatabaseObject(), session.getSchemaInfo()));
            session.getSchemaInfo().fireSchemaInfoUpdate();
        }
    }

    private ITableInfo chooseDestTableInfo(ITableInfo sourceTI, TableInfo pasteToTableInfo) {
        if (null == pasteToTableInfo) {
            return sourceTI;
        }
        return pasteToTableInfo;
    }

    public void addListener(CopyTableListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.listeners.add(listener);
    }

    private void sleep(long sleepTime) {
        boolean shouldSleep = prefs.isDelayBetweenObjects();
        if (!shouldSleep || sleepTime <= 0L) {
            return;
        }
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean analyzeTables() {
        boolean result = true;
        if (!prefs.isTestColumnNames()) {
            return true;
        }
        if (DBUtil.sameDatabaseType(this.prov.getSourceSession(), this.prov.getDestSession())) {
            return true;
        }
        this.sendAnalysisStarted();
        try {
            List<IDatabaseObjectInfo> dbObjs = this.prov.getSourceDatabaseObjects();
            int sourceObjectCount = 0;
            for (IDatabaseObjectInfo info : dbObjs) {
                ITableInfo ti = (ITableInfo)info;
                this.sendAnalyzingTable(ti, sourceObjectCount + 1);
                DBUtil.validateColumnNames(ti, this.prov);
                ++sourceObjectCount;
            }
        }
        catch (MappingException e) {
            this.sendErrorEvent(3, (Exception)((Object)e));
            result = false;
        }
        catch (UserCancelledOperationException e) {
            this.sendErrorEvent(4, (Exception)((Object)e));
            result = false;
        }
        return result;
    }

    private void setupAutoCommit(ISQLConnection con) {
        boolean autoCommitPref = prefs.isAutoCommitEnabled();
        try {
            this.currentAutoCommitValue = this.originalAutoCommitValue = con.getAutoCommit();
            if (autoCommitPref != this.originalAutoCommitValue) {
                con.setAutoCommit(autoCommitPref);
                this.currentAutoCommitValue = autoCommitPref;
            }
        }
        catch (SQLException e) {
            this.currentAutoCommitValue = true;
            this.sendErrorEvent(0, e);
        }
    }

    private void restoreAutoCommit(ISQLConnection con) {
        if (this.originalAutoCommitValue == this.currentAutoCommitValue) {
            return;
        }
        try {
            con.setAutoCommit(this.originalAutoCommitValue);
        }
        catch (SQLException e) {
            this.sendErrorEvent(1, e);
        }
    }

    private int[] getTableCounts() {
        int[] result = null;
        ISession sourceSession = this.prov.getSourceSession();
        List<IDatabaseObjectInfo> dbObjs = this.prov.getSourceDatabaseObjects();
        if (dbObjs != null) {
            result = new int[dbObjs.size()];
            this.selectedTableInfos = new ArrayList();
            int sourceObjectCount = 0;
            for (IDatabaseObjectInfo info : dbObjs) {
                if (!(info instanceof ITableInfo)) continue;
                try {
                    ITableInfo ti = (ITableInfo)info;
                    this.selectedTableInfos.add(ti);
                    result[sourceObjectCount] = DBUtil.getTableCount(sourceSession, ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), 0);
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                    result[sourceObjectCount] = 0;
                }
                ++sourceObjectCount;
            }
        }
        return result;
    }

    private void sendAnalysisStarted() {
        AnalysisEvent event = new AnalysisEvent(this.prov);
        for (CopyTableListener listener : this.listeners) {
            listener.tableAnalysisStarted(event);
        }
    }

    private void sendAnalyzingTable(ITableInfo ti, int number) {
        TableEvent event = new TableEvent(this.prov);
        event.setTableCount(this.prov.getSourceDatabaseObjects().size());
        event.setTableNumber(number);
        Iterator<CopyTableListener> i = this.listeners.iterator();
        event.setTableName(ti.getSimpleName());
        while (i.hasNext()) {
            CopyTableListener listener = i.next();
            listener.analyzingTable(event);
        }
    }

    private void sendCopyStarted(int[] tableCounts) {
        CopyEvent event = new CopyEvent(this.prov);
        event.setTableCounts(tableCounts);
        for (CopyTableListener listener : this.listeners) {
            listener.copyStarted(event);
        }
    }

    private void sendTableCopyStarted(ITableInfo ti, int number) {
        TableEvent event = new TableEvent(this.prov);
        event.setTableNumber(number);
        event.setTableCount(this.prov.getSourceDatabaseObjects().size());
        event.setTableName(ti.getSimpleName());
        for (CopyTableListener listener : this.listeners) {
            listener.tableCopyStarted(event);
        }
    }

    private void sendTableCopyFinished(ITableInfo ti, int number) {
        TableEvent event = new TableEvent(this.prov);
        event.setTableNumber(number);
        event.setTableCount(this.prov.getSourceDatabaseObjects().size());
        event.setTableName(ti.getSimpleName());
        for (CopyTableListener listener : this.listeners) {
            listener.tableCopyFinished(event);
        }
    }

    private void sendErrorEvent(int type) {
        this.sendErrorEvent(type, null);
    }

    private void sendErrorEvent(int type, Exception e) {
        Main.getApplication().getMessageHandler().showErrorMessage((Throwable)e);
        s_log.error((Object)e);
        ErrorEvent event = new ErrorEvent(this.prov, type);
        event.setException(e);
        for (CopyTableListener listener : this.listeners) {
            listener.handleError(event);
        }
    }

    private void sendRecordEvent(int number, int count) {
        RecordEvent event = new RecordEvent(this.prov, number, count);
        for (CopyTableListener listener : this.listeners) {
            listener.recordCopied(event);
        }
    }

    private void sendStatementEvent(String sql, String[] vals) {
        StatementEvent event = new StatementEvent(sql, 3);
        event.setBindValues(vals);
        for (CopyTableListener listener : this.listeners) {
            listener.statementExecuted(event);
        }
    }

    private void notifyCopyFinished() {
        int seconds = (int)this.getElapsedSeconds();
        for (CopyTableListener listener : this.listeners) {
            listener.copyFinished(seconds);
        }
    }

    private long getElapsedSeconds() {
        long result = 1L;
        double elapsed = this.end - this.start;
        if (elapsed > 1000.0) {
            result = Math.round(elapsed / 1000.0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTable(ITableInfo sourceTableInfo, TableInfo pasteToTableInfo, int sourceTableCount) throws MappingException, SQLException, UserCancelledOperationException {
        PreparedStatement insertStmt = null;
        ResultSet rs = null;
        if (this.cancelled) {
            return;
        }
        if (!PreferencesManager.getPreferences().isCopyData()) {
            return;
        }
        ISQLConnection sourceConn = this.prov.getSourceSession().getSQLConnection();
        ISQLConnection destConn = this.prov.getDestSession().getSQLConnection();
        SQLDatabaseMetaData sourceMetaData = sourceConn.getSQLMetaData();
        SQLDatabaseMetaData destMetaData = destConn.getSQLMetaData();
        try {
            String destSchema = DBUtil.getSchemaNameFromDbObject(this.prov.getDestDatabaseObject());
            ITableInfo destTableInfo = DBUtil.getTableInfo(this.prov.getDestSession(), destSchema, this.chooseDestTableInfo(sourceTableInfo, pasteToTableInfo).getSimpleName());
            TableColumnInfo[] sourceInfos = sourceMetaData.getColumnInfo(sourceTableInfo);
            TableColumnInfo[] destInfos = destMetaData.getColumnInfo(destTableInfo);
            destInfos = this.sort(sourceInfos, destInfos, sourceTableInfo.getQualifiedName(), destTableInfo.getQualifiedName());
            String sourceColList = DBUtil.getColumnList(sourceInfos, false);
            String destColList = DBUtil.getColumnList(destInfos, false);
            boolean doubleQuoteTableName = false;
            boolean doubleQuoteColumnNames = false;
            String selectSQL = DBUtil.getSelectQuery(this.prov, sourceColList, sourceTableInfo, doubleQuoteTableName, this.prov.getWhereClause());
            try {
                rs = DBUtil.executeQuery(this.prov.getSourceSession(), selectSQL);
            }
            catch (Exception e) {
                try {
                    log.info((Object)"Failed to execute SELECT-SQL without double quoting. Now trying with double quoting table name", (Throwable)e);
                    doubleQuoteTableName = true;
                    selectSQL = DBUtil.getSelectQuery(this.prov, sourceColList, sourceTableInfo, doubleQuoteTableName, this.prov.getWhereClause());
                    rs = DBUtil.executeQuery(this.prov.getSourceSession(), selectSQL);
                }
                catch (Exception e1) {
                    log.info((Object)"Failed to execute SELECT-SQL without double quoting. Now trying with double quoting table name and column names", (Throwable)e);
                    doubleQuoteTableName = true;
                    doubleQuoteColumnNames = true;
                    sourceColList = DBUtil.getColumnList(sourceInfos, doubleQuoteColumnNames);
                    destColList = DBUtil.getColumnList(destInfos, doubleQuoteColumnNames);
                    selectSQL = DBUtil.getSelectQuery(this.prov, sourceColList, sourceTableInfo, doubleQuoteTableName, this.prov.getWhereClause());
                    rs = DBUtil.executeQuery(this.prov.getSourceSession(), selectSQL);
                }
            }
            String insertSQL = DBUtil.getInsertSQL(this.prov, destColList, destTableInfo, destInfos.length, doubleQuoteTableName);
            insertStmt = destConn.prepareStatement(insertSQL);
            int count = 1;
            int commitCount = prefs.getCommitCount();
            int columnCount = destInfos.length;
            String[] bindVarVals = new String[columnCount];
            boolean foundLOBType = false;
            DBUtil.setLastStatement(selectSQL);
            DBUtil.setLastStatement(insertSQL);
            boolean isMysql = DialectFactory.isMySQL((ISQLDatabaseMetaData)this.destSession.getMetaData());
            boolean isSourceOracle = DialectFactory.isOracle((ISQLDatabaseMetaData)this.sourceSession.getMetaData());
            boolean isDestOracle = DialectFactory.isOracle((ISQLDatabaseMetaData)this.destSession.getMetaData());
            while (rs.next() && !this.cancelled) {
                if (isMysql && foundLOBType) {
                    insertStmt.clearParameters();
                }
                StringBuilder lastStmtValuesBuffer = new StringBuilder();
                lastStmtValuesBuffer.append("\n(Bind variable values: ");
                foundLOBType = this.setPreparedStatementParams(insertStmt, rs, sourceInfos, destInfos, columnCount, bindVarVals, foundLOBType, isSourceOracle, isDestOracle, lastStmtValuesBuffer);
                lastStmtValuesBuffer.append(")");
                try {
                    DBUtil.setLastStatementValues(lastStmtValuesBuffer.toString());
                    this.sendStatementEvent(insertSQL, bindVarVals);
                    insertStmt.executeUpdate();
                }
                catch (Exception e) {
                    try {
                        log.info((Object)"Failed to execute INSERT-SQL. Now trying with inverted quoting for columns", (Throwable)e);
                        destColList = DBUtil.getColumnList(destInfos, !doubleQuoteColumnNames);
                        insertSQL = DBUtil.getInsertSQL(this.prov, destColList, destTableInfo, destInfos.length, doubleQuoteTableName);
                        insertStmt = destConn.prepareStatement(insertSQL);
                        foundLOBType = this.setPreparedStatementParams(insertStmt, rs, sourceInfos, destInfos, columnCount, bindVarVals, foundLOBType, isSourceOracle, isDestOracle, lastStmtValuesBuffer);
                        DBUtil.setLastStatementValues(lastStmtValuesBuffer.toString());
                        this.sendStatementEvent(insertSQL, bindVarVals);
                        insertStmt.executeUpdate();
                    }
                    catch (Exception e1) {
                        log.info((Object)"Failed to execute INSERT-SQL. Now trying with inverted quoting with inverted quoting for columns and table", (Throwable)e);
                        destColList = DBUtil.getColumnList(destInfos, !doubleQuoteColumnNames);
                        insertSQL = DBUtil.getInsertSQL(this.prov, destColList, destTableInfo, destInfos.length, !doubleQuoteTableName);
                        insertStmt = destConn.prepareStatement(insertSQL);
                        foundLOBType = this.setPreparedStatementParams(insertStmt, rs, sourceInfos, destInfos, columnCount, bindVarVals, foundLOBType, isSourceOracle, isDestOracle, lastStmtValuesBuffer);
                        DBUtil.setLastStatementValues(lastStmtValuesBuffer.toString());
                        this.sendStatementEvent(insertSQL, bindVarVals);
                        insertStmt.executeUpdate();
                    }
                }
                this.sendRecordEvent(count, sourceTableCount);
                if (!this.currentAutoCommitValue && ++count % commitCount == 0) {
                    this.commitConnection(destConn);
                }
                this.sleep(prefs.getRecordDelayMillis());
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            SQLUtilities.closeStatement(insertStmt);
            if (!this.currentAutoCommitValue) {
                this.commitConnection(destConn);
            }
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)insertStmt);
        if (!this.currentAutoCommitValue) {
            this.commitConnection(destConn);
        }
    }

    private boolean setPreparedStatementParams(PreparedStatement insertStmt, ResultSet rs, TableColumnInfo[] sourceInfos, TableColumnInfo[] destInfos, int columnCount, String[] bindVarVals, boolean foundLOBType, boolean isSourceOracle, boolean isDestOracle, StringBuilder lastStmtValuesBuffer) throws SQLException {
        for (int i = 0; i < columnCount; ++i) {
            String bindVal;
            int sourceColType = DBUtil.replaceOtherDataType(sourceInfos[i], this.prov.getSourceSession());
            sourceColType = this.getDateReplacement(sourceColType, isSourceOracle);
            int destColType = destInfos[i].getDataType();
            destColType = DBUtil.replaceOtherDataType(destInfos[i], this.prov.getDestSession());
            destColType = this.getDateReplacement(destColType, isDestOracle);
            bindVarVals[i] = bindVal = DBUtil.bindVariable(insertStmt, sourceColType, destColType, i + 1, rs);
            lastStmtValuesBuffer.append(bindVal);
            if (i + 1 < columnCount) {
                lastStmtValuesBuffer.append(", ");
            }
            if (!this.isLOBType(destColType)) continue;
            foundLOBType = true;
        }
        return foundLOBType;
    }

    private int getDateReplacement(int type, boolean isOracle) {
        int result = type;
        if (isOracle && type == 91) {
            result = 93;
        }
        return result;
    }

    private boolean isLOBType(int columnType) {
        return columnType == 2004 || columnType == 2005 || columnType == -4 || columnType == -2;
    }

    private TableColumnInfo[] sort(TableColumnInfo[] sourceInfos, TableColumnInfo[] destInfos, String sourceTableName, String destTableName) throws MappingException {
        if (sourceInfos.length != destInfos.length) {
            String msg = CopyExecutor.getMessage("CopyExecutor.tablecolmismatch", new Object[]{sourceTableName, sourceInfos.length, destTableName, destInfos.length});
            throw new MappingException(msg);
        }
        ArrayList<TableColumnInfo> result = new ArrayList<TableColumnInfo>();
        for (int sourceIdx = 0; sourceIdx < sourceInfos.length; ++sourceIdx) {
            TableColumnInfo sourceInfo = sourceInfos[sourceIdx];
            String sourceColumnName = sourceInfo.getColumnName().trim();
            boolean found = false;
            for (int destIdx = 0; !found && destIdx < destInfos.length; ++destIdx) {
                TableColumnInfo destInfo = destInfos[destIdx];
                String destColumnName = destInfo.getColumnName().trim();
                if (!destColumnName.equalsIgnoreCase(sourceColumnName)) continue;
                result.add(destInfo);
                found = true;
            }
            if (found) continue;
            throw new MappingException("Destination table " + destTableName + " doesn't appear to have a column named " + sourceInfo.getColumnName());
        }
        return result.toArray(new TableColumnInfo[destInfos.length]);
    }

    private void commitConnection(ISQLConnection connection) {
        try {
            connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Failed to commit connection - " + connection), (Throwable)e);
        }
    }

    private void copyConstraints(List<IDatabaseObjectInfo> dbObjs) throws SQLException, UserCancelledOperationException {
        if (!prefs.isCopyForeignKeys() || DialectFactory.isAxion((ISQLDatabaseMetaData)this.prov.getSourceSession().getMetaData())) {
            return;
        }
        ISQLConnection destConn = this.prov.getDestSession().getSQLConnection();
        for (IDatabaseObjectInfo info : dbObjs) {
            ITableInfo ti = (ITableInfo)info;
            Set<String> fkStmts = DBUtil.getForeignKeySQL(this.prov, ti, this.selectedTableInfos);
            for (String fkSQL : fkStmts) {
                DBUtil.setLastStatementValues("");
                try {
                    DBUtil.executeUpdate(destConn, fkSQL, true);
                }
                catch (SQLException e) {
                    log.error((Object)("Unexpected exception while attempting to create FK constraint using sql = " + fkSQL), (Throwable)e);
                }
            }
        }
    }

    private void createTable(ITableInfo ti, String destTableName, String destSchema, String destCatalog) throws SQLException, UserCancelledOperationException, MappingException {
        if (this.cancelled) {
            return;
        }
        ISQLConnection destCon = this.prov.getDestSession().getSQLConnection();
        String createTableSql = DBUtil.getCreateTableSql(this.prov, ti, destTableName, destSchema, destCatalog);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating table in dest db with SQL: " + createTableSql));
        }
        DBUtil.executeUpdate(destCon, createTableSql, true);
        if (prefs.isCommitAfterTableDefs() && !this.currentAutoCommitValue) {
            this.commitConnection(destCon);
        }
        if (prefs.isCopyIndexDefs() && (null == this.prov.getPasteToTableName() || !this.prov.isCopiedFormDestinationSession())) {
            List indices = null;
            ISQLDatabaseMetaData sqlmd = this.sourceSession.getMetaData();
            CreateScriptPreferences prefs = new CreateScriptPreferences();
            prefs.setQualifyTableNames(null != destSchema);
            if (CopyExecutor.prefs.isCopyPrimaryKeys()) {
                PrimaryKeyInfo[] pkList = sqlmd.getPrimaryKey(ti);
                List<PrimaryKeyInfo> pkList2 = Arrays.asList(pkList);
                indices = DialectUtils.createIndexes((ITableInfo)ti, (String)destTableName, (String)destSchema, (ISQLDatabaseMetaData)sqlmd, pkList2, (CreateScriptPreferences)prefs);
            } else {
                indices = DialectUtils.createIndexes((ITableInfo)ti, (String)destTableName, (String)destSchema, (ISQLDatabaseMetaData)sqlmd, null, (CreateScriptPreferences)prefs);
            }
            for (String createIndicesSql : indices) {
                DBUtil.executeUpdate(destCon, createIndicesSql, true);
            }
        }
    }

    public void setPref(UICallbacks pref) {
        this.pref = pref;
    }

    public UICallbacks getPref() {
        return this.pref;
    }
}

