/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.actions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.EditPasteTableNameDialog;

public class EditPasteTableNameCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(EditPasteTableNameCtrl.class);
    private String _tableName;
    private String _whereClause;
    private final EditPasteTableNameDialog _dlg;

    public EditPasteTableNameCtrl(Frame owner, String destTableName) {
        this._dlg = new EditPasteTableNameDialog(owner, destTableName);
        this._dlg.btnOK.addActionListener(e -> this.onOK());
        this._dlg.btnCancel.addActionListener(e -> this.onCancel());
        GUIUtils.forceFocus((Component)this._dlg.txtTableName);
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(true);
    }

    private void onCancel() {
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onOK() {
        if (StringUtilities.isEmpty((String)this._dlg.txtTableName.getText(), (boolean)true)) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("EditPasteTableNameDlg.TableNameEmpty"));
            return;
        }
        this._tableName = this._dlg.txtTableName.getText();
        if (!StringUtilities.isEmpty((String)this._dlg.txtWhere.getText(), (boolean)true)) {
            this._whereClause = false == this._dlg.txtWhere.getText().trim().toUpperCase().startsWith("WHERE") ? "WHERE " + this._dlg.txtWhere.getText() : this._dlg.txtWhere.getText();
        }
        this.close();
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getWhereClause() {
        return this._whereClause;
    }
}

