/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class EditPasteTableNameDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(EditPasteTableNameDialog.class);
    JTextField txtTableName = new JTextField();
    JTextArea txtWhere = new JTextArea();
    JButton btnOK = new JButton(s_stringMgr.getString("EditPasteTableNameDlg.OK"));
    JButton btnCancel = new JButton(s_stringMgr.getString("EditPasteTableNameDlg.Cancel"));

    public EditPasteTableNameDialog(Frame owner, String destTableName) {
        super(owner, s_stringMgr.getString("EditPasteTableNameDlg.title"), true);
        this.createUI(destTableName);
        GUIUtils.enableCloseByEscape((JDialog)this);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.setSize(450, 400);
    }

    private void createUI(String destTableName) {
        this.getContentPane().setLayout(new GridBagLayout());
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new MultipleLineLabel(s_stringMgr.getString("EditPasteTableNameDlg.text")), gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.txtTableName, gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createTableNameLinkLabel(destTableName), gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)new JLabel(s_stringMgr.getString("EditPasteTableNameDlg.where.label")), gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.txtWhere, gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JLabel createTableNameLinkLabel(final String destTableName) {
        JLabel lblDestNameLink = new JLabel(s_stringMgr.getString("EditPasteTableNameDlg.htmlSetNameTo", new Object[]{destTableName}));
        lblDestNameLink.setCursor(Cursor.getPredefinedCursor(12));
        lblDestNameLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EditPasteTableNameDialog.this.txtTableName.setText(destTableName);
            }
        });
        return lblDestNameLink;
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0);
        ret.add((Component)this.btnOK, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.btnCancel, gbc);
        return ret;
    }
}

