/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPlugin;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.EditPasteTableNameCtrl;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.PasteTableUtil;

public class PasteTableAsOrFilteredAction
extends SquirrelAction
implements IObjectTreeAction {
    private final SessionInfoProvider _sessionInfoProv;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PasteTableAsOrFilteredAction.class);

    public PasteTableAsOrFilteredAction(Resources rsrc, DBCopyPlugin plugin) {
        super(Main.getApplication(), (IResources)rsrc);
        this._sessionInfoProv = plugin.getSessionInfoProvider();
    }

    public void actionPerformed(ActionEvent evt) {
        EditPasteTableNameCtrl ctrl;
        if (null == this._sessionInfoProv.getSourceDatabaseObjects()) {
            return;
        }
        Frame owningFrame = SessionUtils.getOwningFrame((ISession)this._sessionInfoProv.getDestSession());
        if (1 != this._sessionInfoProv.getSourceDatabaseObjects().size()) {
            JOptionPane.showMessageDialog(owningFrame, s_stringMgr.getString("EditPasteTableNameDlg.onlyOneTableMsg"));
            return;
        }
        List selectedTables = this._sessionInfoProv.getDestObjectTreeAPI().getSelectedTables();
        String destTableName = this._sessionInfoProv.getSourceDatabaseObjects().get(0).getSimpleName();
        if (1 == selectedTables.size()) {
            destTableName = ((ITableInfo)selectedTables.get(0)).getSimpleName();
        }
        if (null == (ctrl = new EditPasteTableNameCtrl(owningFrame, destTableName)).getTableName()) {
            return;
        }
        this._sessionInfoProv.setWhereClause(ctrl.getWhereClause());
        this._sessionInfoProv.setPasteToTableName(ctrl.getTableName());
        PasteTableUtil.execPasteTable(this._sessionInfoProv, Main.getApplication());
    }

    public void setObjectTree(IObjectTreeAPI objectTreeAPI) {
        this._sessionInfoProv.setDestObjectTree(objectTreeAPI);
        this.setEnabled(null != objectTreeAPI);
    }
}

