/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.actions;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.commands.PasteTableCommand;

public class PasteTableUtil {
    private static final ILogger log = LoggerController.createLogger(PasteTableUtil.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PasteTableUtil.class);

    public static void execPasteTable(SessionInfoProvider sessionInfoProv, IApplication app1) {
        ISession destSession = sessionInfoProv.getDestSession();
        IObjectTreeAPI api = sessionInfoProv.getDestObjectTreeAPI();
        if (api == null) {
            return;
        }
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        if (dbObjs.length > 1) {
            sessionInfoProv.setDestDatabaseObject(null);
            String msg = s_stringMgr.getString("PasteTableAction.error.multischemapaste");
            app1.showErrorDialog(msg);
            return;
        }
        if (DatabaseObjectType.TABLE_TYPE_DBO.equals(dbObjs[0].getDatabaseObjectType())) {
            IDatabaseObjectInfo tableLabelInfo = dbObjs[0];
            ISQLConnection destCon = destSession.getSQLConnection();
            SQLDatabaseMetaData md = null;
            if (destCon != null) {
                md = destCon.getSQLMetaData();
            }
            DatabaseObjectInfo schema = new DatabaseObjectInfo(null, tableLabelInfo.getSchemaName(), tableLabelInfo.getSchemaName(), DatabaseObjectType.SCHEMA, (ISQLDatabaseMetaData)md);
            sessionInfoProv.setDestDatabaseObject((IDatabaseObjectInfo)schema);
        } else {
            sessionInfoProv.setDestDatabaseObject(dbObjs[0]);
        }
        try {
            IDatabaseObjectInfo info = sessionInfoProv.getDestDatabaseObject();
            if (info == null || destSession == null) {
                return;
            }
            if (!PasteTableUtil.checkSession(destSession, info)) {
                return;
            }
        }
        catch (UserCancelledOperationException e) {
            return;
        }
        if (sessionInfoProv.getSourceSession() == null) {
            return;
        }
        if (!PasteTableUtil.sourceDestSchemasDiffer()) {
            return;
        }
        new PasteTableCommand(sessionInfoProv).execute();
    }

    private static boolean checkSession(ISession session, IDatabaseObjectInfo dbObj) throws UserCancelledOperationException {
        if (session == null || dbObj == null) {
            return true;
        }
        String typeName = dbObj.getDatabaseObjectType().getName();
        log.debug((Object)("PasteTableAction.checkSession: dbObj type=" + typeName + " name=" + dbObj.getSimpleName()));
        HibernateDialect d = DialectFactory.getDialect((ISQLDatabaseMetaData)session.getMetaData());
        if (!d.canPasteTo(dbObj)) {
            String errmsg = s_stringMgr.getString("PasteTableAction.error.destdbobj", new Object[]{typeName});
            Main.getApplication().showErrorDialog(errmsg);
            return false;
        }
        return true;
    }

    private static boolean sourceDestSchemasDiffer() {
        return true;
    }
}

