/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.commands;

import java.sql.SQLException;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBackAdaptor;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPlugin;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.DBUtil;

public class CopyTableCommand {
    private IObjectTreeAPI _objectTreeAPI;
    private final DBCopyPlugin _plugin;
    private static final ILogger log = LoggerController.createLogger(CopyTableCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CopyTableCommand.class);

    public CopyTableCommand(IObjectTreeAPI objectTreeAPI, DBCopyPlugin plugin) {
        this._objectTreeAPI = objectTreeAPI;
        this._plugin = plugin;
    }

    public void execute() {
        if (this._objectTreeAPI != null) {
            IDatabaseObjectInfo[] dbObjs = this._objectTreeAPI.getSelectedDatabaseObjects();
            if (DatabaseObjectType.TABLE_TYPE_DBO.equals(dbObjs[0].getDatabaseObjectType())) {
                String catalog = dbObjs[0].getCatalogName();
                String schema = dbObjs[0].getSchemaName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CopyTableCommand.execute: catalog=" + catalog));
                    log.debug((Object)("CopyTableCommand.execute: schema=" + schema));
                }
                dbObjs = DBUtil.getTables(this._objectTreeAPI.getSession(), catalog, schema, null);
                for (int i = 0; i < dbObjs.length; ++i) {
                    ITableInfo info = (ITableInfo)dbObjs[i];
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("dbObj[" + i + "] = " + info.getSimpleName()));
                }
            }
            this._plugin.getSessionInfoProvider().initCopy(this._objectTreeAPI.getSession());
            final IDatabaseObjectInfo[] fdbObjs = dbObjs;
            final SQLDatabaseMetaData md = this._objectTreeAPI.getSession().getSQLConnection().getSQLMetaData();
            Main.getApplication().getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        CopyTableCommand.this.getInsertionOrder(fdbObjs, md);
                        CopyTableCommand.this._plugin.setPasteMenuEnabled(true);
                    }
                    catch (Throwable e) {
                        Main.getApplication().getMessageHandler().showErrorMessage(e);
                        log.error((Object)"Unexected exception: ", e);
                    }
                }
            });
        }
    }

    private void getInsertionOrder(IDatabaseObjectInfo[] dbObjs, SQLDatabaseMetaData md) throws SQLException {
        List selectedTables = DBUtil.convertObjectArrayToTableList(dbObjs);
        if (selectedTables.size() > 1) {
            ProgressCallBackAdaptor cb = new ProgressCallBackAdaptor(){

                public void currentlyLoading(String simpleName) {
                    Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("CopyTablesCommand.loadingPrefix.new") + " " + simpleName);
                }
            };
            selectedTables = SQLUtilities.getInsertionOrder(selectedTables, (SQLDatabaseMetaData)md, (ProgressCallBack)cb);
            this._plugin.getSessionInfoProvider().setSourceDatabaseObjects(DBUtil.convertTableToObjectList(selectedTables));
        } else {
            this._plugin.getSessionInfoProvider().setSourceDatabaseObjects(DBUtil.convertTableToObjectList(selectedTables));
        }
    }
}

