/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.squirrel.exp;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import org.firebirdsql.squirrel.FirebirdPlugin;
import org.firebirdsql.squirrel.IObjectTypes;
import org.firebirdsql.squirrel.exp.DomainParentExpander;
import org.firebirdsql.squirrel.exp.GeneratorParentExpander;
import org.firebirdsql.squirrel.util.IndexParentInfo;

public class DatabaseExpander
implements INodeExpander {
    private FirebirdPlugin _plugin;

    public DatabaseExpander(FirebirdPlugin plugin) {
        this._plugin = plugin;
    }

    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSimpleName();
        DatabaseObjectInfo seqInfo = new DatabaseObjectInfo(catalogName, schemaName, "GENERATORS", IObjectTypes.GENERATOR_PARENT, (ISQLDatabaseMetaData)md);
        ObjectTreeNode node = new ObjectTreeNode(session, (IDatabaseObjectInfo)seqInfo);
        node.addExpander((INodeExpander)new GeneratorParentExpander(this._plugin));
        childNodes.add(node);
        seqInfo = new DatabaseObjectInfo(catalogName, schemaName, "DOMAINS", IObjectTypes.DOMAIN_PARENT, (ISQLDatabaseMetaData)md);
        node = new ObjectTreeNode(session, (IDatabaseObjectInfo)seqInfo);
        node.addExpander((INodeExpander)new DomainParentExpander(this._plugin));
        childNodes.add(node);
        seqInfo = new IndexParentInfo(null, md);
        node = new ObjectTreeNode(session, (IDatabaseObjectInfo)seqInfo);
        childNodes.add(node);
        return childNodes;
    }
}

