/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.squirrel.exp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.StatementExecutionTimeOutHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.firebirdsql.squirrel.FirebirdPlugin;

public class GeneratorParentExpander
implements INodeExpander {
    private static final String SQL = "select cast(rdb$generator_name as varchar(31)) as rdb$generator_name from rdb$generators where rdb$system_flag is null";
    private static final ILogger s_log = LoggerController.createLogger(GeneratorParentExpander.class);
    private final FirebirdPlugin _plugin;

    GeneratorParentExpander(FirebirdPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("FirebirdPlugin == null");
        }
        this._plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSchemaName();
        try (PreparedStatement pstmt = StatementExecutionTimeOutHandler.prepareStatement((ISQLConnection)conn, (String)SQL);){
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                DatabaseObjectInfo si = new DatabaseObjectInfo(catalogName, schemaName, rs.getString(1), DatabaseObjectType.SEQUENCE, (ISQLDatabaseMetaData)md);
                childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)si));
            }
        }
        return childNodes;
    }
}

