/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.app.Plugin;
import org.fife.ui.app.PluginOptionsDialogPanel;

public abstract class AbstractConsoleTextAreaOptionPanel<P extends Plugin<?>>
extends PluginOptionsDialogPanel<P>
implements ActionListener,
ItemListener,
PropertyChangeListener {
    protected JCheckBox visibleCB;
    protected JLabel locationLabel;
    protected JComboBox<String> locationCombo;
    protected JButton defaultsButton;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.rtext.RText");

    public AbstractConsoleTextAreaOptionPanel(P plugin) {
        super(plugin);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.visibleCB == source) {
            this.setVisibleCBSelected(this.visibleCB.isSelected());
            this.setDirty(true);
        } else if (this.defaultsButton == source && this.notDefaults()) {
            this.restoreDefaults();
            this.setDirty(true);
        }
    }

    protected void addRestoreDefaultsButton(Container parent) {
        this.defaultsButton = new JButton(this.getString("RestoreDefaults"));
        this.defaultsButton.setActionCommand("RestoreDefaults");
        this.defaultsButton.addActionListener(this);
        this.addLeftAligned(parent, this.defaultsButton);
    }

    protected JCheckBox createColorActivateCB(String label) {
        JCheckBox cb = new JCheckBox(label);
        cb.addActionListener(this);
        return cb;
    }

    private RColorSwatchesButton createColorSwatchesButton() {
        RColorSwatchesButton button = new RColorSwatchesButton();
        button.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        return button;
    }

    protected Container createGeneralPanel() {
        ResourceBundle gpb = ResourceBundle.getBundle("org.fife.ui.app.GUIPlugin");
        Box generalPanel = Box.createVerticalBox();
        generalPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(gpb.getString("Options.General")));
        this.visibleCB = new JCheckBox(gpb.getString("Visible"));
        this.visibleCB.addActionListener(this);
        this.addLeftAligned(generalPanel, this.visibleCB, 3);
        Box locationPanel = this.createHorizontalBox();
        this.locationCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.locationCombo);
        this.locationCombo.addItem(gpb.getString("Location.top"));
        this.locationCombo.addItem(gpb.getString("Location.left"));
        this.locationCombo.addItem(gpb.getString("Location.bottom"));
        this.locationCombo.addItem(gpb.getString("Location.right"));
        this.locationCombo.addItem(gpb.getString("Location.floating"));
        this.locationCombo.addItemListener(this);
        this.locationLabel = new JLabel(gpb.getString("Location.title"));
        this.locationLabel.setLabelFor(this.locationCombo);
        locationPanel.add(this.locationLabel);
        locationPanel.add(Box.createHorizontalStrut(5));
        locationPanel.add(this.locationCombo);
        locationPanel.add(Box.createHorizontalGlue());
        this.addLeftAligned(generalPanel, locationPanel);
        return generalPanel;
    }

    private String getString(String key) {
        return MSG.getString(key);
    }

    public JComponent getTopJComponent() {
        return this.visibleCB;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.locationCombo && e.getStateChange() == 1) {
            this.setDirty(true);
        }
    }

    protected boolean notDefaults() {
        return !this.visibleCB.isSelected() || this.locationCombo.getSelectedIndex() != 2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.setDirty(true);
    }

    protected void restoreDefaults() {
        this.setVisibleCBSelected(true);
        this.locationCombo.setSelectedIndex(2);
    }

    protected void setVisibleCBSelected(boolean selected) {
        this.visibleCB.setSelected(selected);
        this.locationLabel.setEnabled(selected);
        this.locationCombo.setEnabled(selected);
    }
}

