/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.FileExplorerTableModel;
import org.fife.ui.UIUtil;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;

public abstract class AbstractParserNoticeWindow
extends DockableWindow {
    private RText rtext;
    private JTable table;

    protected AbstractParserNoticeWindow(RText rtext) {
        this.rtext = rtext;
    }

    protected JTable createTable(TableModel model) {
        this.table = new JTable();
        this.setPrimaryComponent(this.table);
        this.fixTableModel(model);
        this.table.addMouseListener(new TableMouseListener());
        Dimension size = this.table.getPreferredScrollableViewportSize();
        size.height = 200;
        this.table.setPreferredScrollableViewportSize(size);
        this.table.setFillsViewportHeight(true);
        UIUtil.fixJTableRendererOrientations((JTable)this.table);
        UIUtil.possiblyFixGridColor((JTable)this.table);
        return this.table;
    }

    private void fixTableModel(TableModel model) {
        JTableHeader old = this.table.getTableHeader();
        this.table.setTableHeader(new JTableHeader(old.getColumnModel()));
        FileExplorerTableModel model2 = new FileExplorerTableModel(model, this.table.getTableHeader());
        model2.setColumnComparator(Integer.class, Comparator.naturalOrder());
        IconTableCellRenderer itcr = new IconTableCellRenderer();
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        itcr.applyComponentOrientation(o);
        this.table.setDefaultRenderer(Icon.class, itcr);
        this.table.setModel((TableModel)model2);
        TableColumnModel tcm = this.table.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(32);
        tcm.getColumn(0).setWidth(32);
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(1).setWidth(200);
        tcm.getColumn(2).setPreferredWidth(48);
        tcm.getColumn(2).setWidth(48);
        tcm.getColumn(3).setPreferredWidth(800);
        this.table.setAutoResizeMode(0);
    }

    protected RText getRText() {
        return this.rtext;
    }

    public void updateUI() {
        TableModel model = null;
        if (this.table != null) {
            model = ((FileExplorerTableModel)this.table.getModel()).getTableModel();
            TableCellRenderer r = this.table.getTableHeader().getDefaultRenderer();
            if (r instanceof FileExplorerTableModel.SortableHeaderRenderer) {
                FileExplorerTableModel.SortableHeaderRenderer shr = (FileExplorerTableModel.SortableHeaderRenderer)r;
                this.table.getTableHeader().setDefaultRenderer(shr.getDelegateRenderer());
            }
        }
        super.updateUI();
        if (this.table != null) {
            JScrollPane sp = (JScrollPane)this.table.getParent().getParent();
            this.fixTableModel(model);
            sp.setColumnHeaderView(this.table.getTableHeader());
            sp.revalidate();
            sp.repaint();
        }
    }

    private final class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        private void focusLine(RTextEditorPane textArea, int line) {
            try {
                textArea.setCaretPosition(textArea.getLineStartOffset(line));
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)textArea));
                ble.printStackTrace();
            }
            textArea.requestFocusInWindow();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (row = AbstractParserNoticeWindow.this.table.rowAtPoint(e.getPoint())) > -1) {
                TableModel model = AbstractParserNoticeWindow.this.table.getModel();
                TextAreaWrapper wrapper = (TextAreaWrapper)model.getValueAt(row, 1);
                RTextEditorPane textArea = wrapper.textArea;
                if (textArea != null) {
                    AbstractMainView mainView = AbstractParserNoticeWindow.this.rtext.getMainView();
                    if (mainView.setSelectedTextArea(textArea)) {
                        Integer i = (Integer)model.getValueAt(row, 2);
                        int line = i - 1;
                        this.focusLine(textArea, line);
                    }
                } else {
                    String fileFullPath = wrapper.fileFullPath;
                    File file = new File(fileFullPath);
                    if (file.isAbsolute() && file.isFile()) {
                        AbstractParserNoticeWindow.this.rtext.openFile(file);
                        SwingUtilities.invokeLater(() -> {
                            RTextEditorPane textArea2 = AbstractParserNoticeWindow.this.rtext.getMainView().getCurrentTextArea();
                            Integer i = (Integer)model.getValueAt(row, 2);
                            int line = i - 1;
                            this.focusLine(textArea2, line);
                        });
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)AbstractParserNoticeWindow.this.rtext));
                    }
                }
            }
        }
    }

    private static final class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        static final Border B = BorderFactory.createEmptyBorder(0, 5, 0, 5);

        private IconTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
            super.getTableCellRendererComponent(table, value, selected, focus, row, col);
            this.setText(null);
            this.setIcon((Icon)value);
            this.setBorder(B);
            return this;
        }
    }

    private static class TextAreaWrapper
    implements Comparable<TextAreaWrapper> {
        private RTextEditorPane textArea;
        private String fileFullPath;

        TextAreaWrapper(RTextEditorPane textArea) {
            this.textArea = textArea;
        }

        TextAreaWrapper(String fileFullPath) {
            this.fileFullPath = fileFullPath;
        }

        @Override
        public int compareTo(TextAreaWrapper o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.textArea != null ? this.textArea.getFileName() : this.fileFullPath;
        }
    }

    protected abstract class ParserNoticeTableModel
    extends DefaultTableModel {
        public ParserNoticeTableModel(String lastColHeader) {
            Object[] colHeaders = new String[]{"", AbstractParserNoticeWindow.this.rtext.getString("ParserNoticeList.File", new Object[0]), AbstractParserNoticeWindow.this.rtext.getString("ParserNoticeList.Line", new Object[0]), lastColHeader};
            this.setColumnIdentifiers(colHeaders);
        }

        protected abstract void addNoticesImpl(RTextEditorPane var1, List<ParserNotice> var2);

        @Override
        public Class<?> getColumnClass(int col) {
            return switch (col) {
                case 0 -> Icon.class;
                case 1 -> TextAreaWrapper.class;
                case 2 -> Integer.class;
                default -> super.getColumnClass(col);
            };
        }

        @Override
        public void addRow(Object[] data) {
            if (data[1] instanceof RTextEditorPane) {
                data[1] = new TextAreaWrapper((RTextEditorPane)((Object)data[1]));
            } else if (data[1] instanceof String) {
                data[1] = new TextAreaWrapper((String)data[1]);
            }
            super.addRow(data);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void update(RTextEditorPane textArea, List<ParserNotice> notices) {
            if (textArea == null) {
                this.setRowCount(0);
            } else {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    TextAreaWrapper wrapper = (TextAreaWrapper)this.getValueAt(i, 1);
                    RTextEditorPane textArea2 = wrapper.textArea;
                    if (textArea2 != textArea) continue;
                    this.removeRow(i);
                    --i;
                }
            }
            if (notices != null) {
                this.addNoticesImpl(textArea, notices);
            }
        }
    }
}

