/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import org.fife.ui.UIUtil;

public class BottomLineBorder
extends AbstractBorder {
    private int horizInsets;

    public BottomLineBorder(int horizInsets) {
        this.horizInsets = horizInsets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.right = insets.left = this.horizInsets;
        insets.bottom = 1;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color color = UIUtil.isLightForeground((Color)c.getForeground()) ? c.getBackground().brighter() : UIManager.getColor("controlDkShadow");
        g.setColor(color);
        y = y + height - 1;
        g.drawLine(x, y, x + width - 1, y);
    }
}

