/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Element;
import org.fife.help.HelpDialog;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rtext.AboutDialog;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.ChildWindowListener;
import org.fife.rtext.RTextActionInfo;
import org.fife.rtext.RTextAppContext;
import org.fife.rtext.RTextAppThemes;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextMDIView;
import org.fife.rtext.RTextMenuBar;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.RTextSplitPaneView;
import org.fife.rtext.RTextTabbedPaneView;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.RTextWindowListener;
import org.fife.rtext.RecentFileManager;
import org.fife.rtext.RemoteFileChooser;
import org.fife.rtext.SpellingErrorWindow;
import org.fife.rtext.StatusBar;
import org.fife.rtext.StoreKeeper;
import org.fife.rtext.ToolBar;
import org.fife.rtext.actions.ActionFactory;
import org.fife.rtext.optionsdialog.OptionsDialog;
import org.fife.ui.CustomizableToolBar;
import org.fife.ui.SplashScreen;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.AbstractPluggableGUIApplication;
import org.fife.ui.app.AppContext;
import org.fife.ui.app.AppTheme;
import org.fife.ui.app.ExceptionDialog;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.Plugin;
import org.fife.ui.app.icons.RasterImageIconGroup;
import org.fife.ui.app.icons.SvgIconGroup;
import org.fife.ui.app.prefs.AppPrefs;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowPanel;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.fife.ui.rtextfilechooser.FileChooserOwner;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.util.MacOSUtil;
import org.fife.util.TranslucencyUtil;

public class RText
extends AbstractPluggableGUIApplication<RTextPrefs>
implements ActionListener,
CaretListener,
PropertyChangeListener,
RTextActionInfo,
FileChooserOwner {
    public static final int TABBED_VIEW = 0;
    public static final int SPLIT_PANE_VIEW = 1;
    public static final int MDI_VIEW = 2;
    private static final String MAIN_VIEW_STYLE_PROPERTY = "RText.mainViewStyle";
    private Map<String, org.fife.ui.app.icons.IconGroup> iconGroupMap;
    private RTextMenuBar menuBar;
    private org.fife.ui.OptionsDialog optionsDialog;
    private CollapsibleSectionPanel csp;
    private AbstractMainView mainView;
    private int mainViewStyle;
    private RTextFileChooser chooser;
    private RemoteFileChooser rfc;
    private HelpDialog helpDialog;
    private SpellingErrorWindow spellingWindow;
    private SyntaxScheme colorScheme;
    private String workingDirectory;
    private String newFileName;
    private boolean showHostName;
    private boolean windowListenersInited;
    private ChildWindowListener searchWindowOpacityListener;
    private boolean searchWindowOpacityEnabled;
    private float searchWindowOpacity;
    private int searchWindowOpacityRule;
    private String hostName;
    private RecentFileManager recentFileManager;
    private int lastPluginCount;
    private static final String DEFAULT_ICON_GROUP_NAME = "IntelliJ Icons (Dark)";
    private static final String PROPERTY_PRINT_START_TIMES = "printStartTimes";
    public static final String VERSION_STRING = "6.0.2";

    public RText(RTextAppContext context, String[] filesToOpen, RTextPrefs preferences) {
        super((AppContext)context, "rtext", (AppPrefs)preferences);
        this.init(filesToOpen);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command;
        switch (command = e.getActionCommand()) {
            case "TileVertically": {
                ((RTextMDIView)this.mainView).tileWindowsVertically();
                break;
            }
            case "TileHorizontally": {
                ((RTextMDIView)this.mainView).tileWindowsHorizontally();
                break;
            }
            case "Cascade": {
                ((RTextMDIView)this.mainView).cascadeWindows();
            }
        }
    }

    public void addDockableWindow(DockableWindow wind) {
        ((DockableWindowPanel)this.mainContentPanel).addDockableWindow(wind);
    }

    public boolean areTabsEmulated() {
        return this.mainView.areTabsEmulated();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        RTextEditorPane textArea = this.mainView.getCurrentTextArea();
        int dot = textArea.getCaretPosition();
        Element map = textArea.getDocument().getDefaultRootElement();
        int line = map.getElementIndex(dot);
        int lineStartOffset = map.getElement(line).getStartOffset();
        ((StatusBar)this.getStatusBar()).setRowAndColumn(line + 1, dot - lineStartOffset + 1);
    }

    private void convertOpenFilesSpacesToTabs() {
        this.mainView.convertOpenFilesSpacesToTabs();
    }

    private void convertOpenFilesTabsToSpaces() {
        this.mainView.convertOpenFilesTabsToSpaces();
    }

    protected JDialog createAboutDialog() {
        return new AboutDialog(this);
    }

    protected void createActions(RTextPrefs prefs) {
        ActionFactory.addActions(this, prefs);
        this.loadActionShortcuts(RText.getShortcutsFile());
    }

    protected JMenuBar createMenuBar(RTextPrefs prefs) {
        this.menuBar = new RTextMenuBar(this);
        this.mainView.addPropertyChangeListener(this.menuBar);
        this.menuBar.setWindowMenuVisible(prefs.mainView == 2);
        return this.menuBar;
    }

    public RText createNewInstance(String[] filesToOpen) {
        RTextAppContext context = (RTextAppContext)this.getAppContext();
        return new RText(context, filesToOpen, (RTextPrefs)this.getActivePreferencesState());
    }

    protected SplashScreen createSplashScreen() {
        String img = "org/fife/rtext/graphics/" + this.getString("Splash", new Object[0]);
        return new SplashScreen(img, this.getString("Initializing", new Object[0]));
    }

    protected org.fife.ui.StatusBar createStatusBar(RTextPrefs prefs) {
        return new StatusBar(this, this.getString("Ready", new Object[0]), !prefs.wordWrap, 1, 1, prefs.textMode == 1);
    }

    protected CustomizableToolBar createToolBar(RTextPrefs prefs) {
        return new ToolBar("rtext - Toolbar", this);
    }

    public void displayException(Dialog owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo((Component)owner);
        ed.setTitle(this.getString("ErrorDialogTitle", new Object[0]));
        ed.setVisible(true);
    }

    public void displayException(Frame owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo((Component)owner);
        ed.setTitle(this.getString("ErrorDialogTitle", new Object[0]));
        ed.setVisible(true);
    }

    public void doExit() {
        boolean allDocumentsClosed = this.getMainView().closeAllDocuments();
        if (allDocumentsClosed) {
            if (StoreKeeper.getInstanceCount() == 1) {
                this.savePreferences();
                boolean saved = RTextEditorPane.saveTemplates();
                if (!saved) {
                    String title = this.getString("ErrorDialogTitle", new Object[0]);
                    String text = this.getString("TemplateSaveError", new Object[0]);
                    JOptionPane.showMessageDialog((Component)((Object)this), text, title, 0);
                }
                if (this.chooser != null) {
                    RTextUtilities.saveFileChooserFavorites(this);
                }
                System.exit(0);
            } else {
                this.setVisible(false);
                StoreKeeper.removeRTextInstance(this);
                this.dispose();
            }
        }
    }

    public void focusDockableWindowGroup(int group) {
        DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
        if (!dwp.focusDockableWindowGroup(group)) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)this));
        }
    }

    public String getNewFileName() {
        return this.newFileName;
    }

    public org.fife.ui.OptionsDialog getOptionsDialog() {
        int pluginCount = this.getPlugins().length;
        if (this.optionsDialog == null || pluginCount != this.lastPluginCount) {
            this.lastPluginCount = pluginCount;
            this.optionsDialog = new OptionsDialog(this);
        }
        MacOSUtil.setTransparentTitleBar((RootPaneContainer)this.optionsDialog, (boolean)true);
        return this.optionsDialog;
    }

    CollapsibleSectionPanel getCollapsibleSectionPanel() {
        return this.csp;
    }

    public RTextFileChooser getFileChooser() {
        if (this.chooser == null) {
            this.chooser = RTextUtilities.createFileChooser(this);
        }
        return this.chooser;
    }

    public int getFocusedDockableWindowGroup() {
        DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
        return dwp.getFocusedDockableWindowGroup();
    }

    public HelpDialog getHelpDialog() {
        if (this.helpDialog == null) {
            String contentsPath = this.getInstallLocation() + "/doc/";
            String helpPath = contentsPath + this.getLanguage() + "/";
            File test = new File(helpPath);
            if (!test.isDirectory()) {
                helpPath = contentsPath + "en/";
            }
            this.helpDialog = new HelpDialog((GUIApplication)this, contentsPath + "HelpDialogContents.xml", helpPath);
            MacOSUtil.setTransparentTitleBar((RootPaneContainer)this.helpDialog, (boolean)true);
            this.helpDialog.setBackButtonIcon(this.getIconGroup().getIcon("back"));
            this.helpDialog.setForwardButtonIcon(this.getIconGroup().getIcon("forward"));
        }
        this.helpDialog.setLocationRelativeTo((Component)((Object)this));
        return this.helpDialog;
    }

    private synchronized String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                this.hostName = "Unknown";
            }
        }
        return this.hostName;
    }

    public AbstractMainView getMainView() {
        return this.mainView;
    }

    public int getMainViewStyle() {
        return this.mainViewStyle;
    }

    List<FileLocation> getRecentFiles() {
        return this.recentFileManager.getRecentFiles();
    }

    public RemoteFileChooser getRemoteFileChooser() {
        if (this.rfc == null) {
            this.rfc = new RemoteFileChooser(this);
        }
        return this.rfc;
    }

    public String getResourceBundleClassName() {
        return "org.fife.rtext.RText";
    }

    public float getSearchWindowOpacity() {
        return this.searchWindowOpacity;
    }

    public int getSearchWindowOpacityRule() {
        return this.searchWindowOpacityRule;
    }

    private static File getShortcutsFile() {
        return new File(RTextUtilities.getPreferencesDirectory(), "shortcuts.properties");
    }

    public boolean getShowHostName() {
        return this.showHostName;
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.colorScheme;
    }

    private int getTabSize() {
        return this.mainView.getTabSize();
    }

    public String getTitle() {
        String title = super.getTitle();
        int hyphen = title.indexOf("- ");
        if (hyphen > -1) {
            title = title.substring(hyphen + 2);
        }
        return title;
    }

    public String getVersionString() {
        return VERSION_STRING;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected void handleInstallPlugin(Plugin plugin) {
        RTextEditorPane textArea = this.getMainView().getCurrentTextArea();
        if (textArea != null) {
            textArea.requestFocusInWindow();
        }
    }

    public boolean hasDockableWindowGroup(int group) {
        DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
        return dwp.hasDockableWindowGroup(group);
    }

    private void init(String[] filesToOpen) {
        this.lastPluginCount = -1;
        this.openFiles(filesToOpen);
    }

    private void initRecentFileManager(RTextPrefs prefs) {
        String fileHistoryStr = prefs.fileHistoryString;
        ArrayList<String> recentFiles = new ArrayList<String>();
        if (fileHistoryStr != null && fileHistoryStr.length() > 0) {
            String[] initialContents = fileHistoryStr.split("<");
            recentFiles.addAll(Arrays.asList(initialContents));
        }
        this.recentFileManager = new RecentFileManager(this, recentFiles);
    }

    private void installRstaTheme(Theme theme) {
        if (this.mainView != null) {
            this.mainView.setRstaTheme(theme);
        }
        this.setSyntaxScheme(theme.scheme);
    }

    public boolean isSearchWindowOpacityEnabled() {
        return this.searchWindowOpacityEnabled;
    }

    public boolean isSpellingWindowVisible() {
        return this.spellingWindow != null && this.spellingWindow.isActive();
    }

    private void loadPossibleIconGroups() {
        this.iconGroupMap = new HashMap<String, org.fife.ui.app.icons.IconGroup>();
        String resourceRoot = "org/fife/rtext/graphics/";
        SvgIconGroup darkIconGroup = new SvgIconGroup((AbstractGUIApplication)this, DEFAULT_ICON_GROUP_NAME, resourceRoot + "intellij-icons-dark", resourceRoot + "intellij-icons-light");
        this.iconGroupMap.put(DEFAULT_ICON_GROUP_NAME, (org.fife.ui.app.icons.IconGroup)darkIconGroup);
        SvgIconGroup lightIconGroup = new SvgIconGroup((AbstractGUIApplication)this, "IntelliJ Icons (Light)", resourceRoot + "intellij-icons-light", null);
        lightIconGroup.setRolloverPath(resourceRoot + "intellij-icons-white");
        this.iconGroupMap.put("IntelliJ Icons (Light)", (org.fife.ui.app.icons.IconGroup)lightIconGroup);
        this.iconGroupMap.put("Eclipse Icons", (org.fife.ui.app.icons.IconGroup)new RasterImageIconGroup("Eclipse Icons", resourceRoot + "eclipse-icons", null));
    }

    private void openFiles(String[] filesToOpen) {
        int count = filesToOpen == null ? 0 : filesToOpen.length;
        for (int i = 0; i < count; ++i) {
            this.openFile(new File(filesToOpen[i]));
        }
    }

    protected void possiblyInitializeMacOSProperties(AppContext<? extends AbstractGUIApplication<RTextPrefs>, RTextPrefs> context, RTextPrefs prefs) {
        MacOSUtil.setTransparentTitleBar((RootPaneContainer)((Object)this), (boolean)true);
        MacOSUtil.setFullWindowContent((RootPaneContainer)((Object)this), (boolean)true);
    }

    protected void preDisplayInit(RTextPrefs prefs, SplashScreen splashScreen) {
        CodeTemplateManager ctm;
        long start = System.currentTimeMillis();
        File prefsDir = RTextUtilities.getPreferencesDirectory();
        if (!prefsDir.isDirectory()) {
            prefsDir.mkdirs();
        }
        super.preDisplayInit((AppPrefs)prefs, splashScreen);
        splashScreen.updateStatus(this.getString("AddingFinalTouches", new Object[0]), 90);
        this.addWindowListener(new RTextWindowListener(this));
        this.setDefaultCloseOperation(0);
        if (RTextUtilities.enableTemplates(this, true) && (ctm = RTextEditorPane.getCodeTemplateManager()).getTemplates().length == 0) {
            RTextUtilities.addDefaultCodeTemplates();
        }
        this.setSearchWindowOpacityEnabled(prefs.searchWindowOpacityEnabled);
        this.setSearchWindowOpacity(prefs.searchWindowOpacity);
        this.setSearchWindowOpacityRule(prefs.searchWindowOpacityRule);
        RTextUtilities.setDropShadowsEnabledInEditor(prefs.dropShadowsInEditor);
        this.setWindowDraggableByMenuBarAndToolBar();
        SwingUtilities.invokeLater(this::updateTextAreaIcons);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preDisplayInit: " + (System.currentTimeMillis() - start));
        }
    }

    protected void preMenuBarInit(RTextPrefs prefs, SplashScreen splashScreen) {
        long start = System.currentTimeMillis();
        this.initRecentFileManager(prefs);
        this.setSplitPaneDividerLocation(0, prefs.dividerLocations[0], prefs.dividerVisible[0]);
        this.setSplitPaneDividerLocation(1, prefs.dividerLocations[1], prefs.dividerVisible[1]);
        this.setSplitPaneDividerLocation(2, prefs.dividerLocations[2], prefs.dividerVisible[2]);
        this.setSplitPaneDividerLocation(3, prefs.dividerLocations[3], prefs.dividerVisible[3]);
        this.setSpellingWindowVisible(prefs.viewSpellingList);
        this.setShowHostName(prefs.showHostName);
        this.mainView.setLineNumbersEnabled(prefs.lineNumbersVisible);
        this.setToolBarVisible(prefs.toolbarVisible);
        this.setStatusBarVisible(prefs.statusBarVisible);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preMenuBarInit: " + (System.currentTimeMillis() - start));
        }
    }

    protected void preStatusBarInit(RTextPrefs prefs, SplashScreen splashScreen) {
        long start = System.currentTimeMillis();
        String[] filesToOpen = null;
        this.newFileName = this.getString("NewFileName", new Object[0]);
        splashScreen.updateStatus(this.getString("SettingSHColors", new Object[0]), 10);
        this.setSyntaxScheme(prefs.colorScheme);
        this.setWorkingDirectory(prefs.workingDirectory);
        splashScreen.updateStatus(this.getString("CreatingView", new Object[0]), 20);
        this.loadPossibleIconGroups();
        this.setIconGroupByName((String)this.getTheme().getExtraUiDefaults().get("rtext.iconGroupName"));
        switch (prefs.mainView) {
            case 0: {
                this.mainViewStyle = 0;
                this.mainView = new RTextTabbedPaneView(this, filesToOpen, prefs);
                break;
            }
            case 1: {
                this.mainViewStyle = 1;
                this.mainView = new RTextSplitPaneView(this, filesToOpen, prefs);
                break;
            }
            default: {
                this.mainViewStyle = 2;
                this.mainView = new RTextMDIView(this, filesToOpen, prefs);
            }
        }
        RTextEditorPane.setIconGroup((IconGroup)RTextUtilities.toRstaIconGroup(this.getIconGroup()));
        this.csp = new CollapsibleSectionPanel(false);
        this.csp.add((Component)this.mainView);
        this.getContentPane().add((Component)this.csp);
        splashScreen.updateStatus(this.getString("CreatingStatusBar", new Object[0]), 25);
        this.mainView.setCodeFoldingEnabledFor("text/proto", true);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preStatusBarInit: " + (System.currentTimeMillis() - start));
        }
    }

    protected void preToolBarInit(RTextPrefs prefs, SplashScreen splashScreen) {
        long start = System.currentTimeMillis();
        StatusBar statusBar = (StatusBar)this.getStatusBar();
        this.mainView.addPropertyChangeListener(statusBar);
        splashScreen.updateStatus(this.getString("CreatingToolBar", new Object[0]), 60);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preToolbarInit: " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("TextEditorPane.fileFullPath")) {
            this.setTitle((String)e.getNewValue());
        } else if (propertyName.equals("TextEditorPane.dirty")) {
            String oldTitle = this.getTitle();
            boolean newValue = (Boolean)e.getNewValue();
            if (!newValue) {
                this.setTitle(oldTitle.substring(0, oldTitle.length() - 1));
            } else {
                this.setTitle(oldTitle + "*");
            }
        }
    }

    void registerChildWindowListeners(Window w) {
        if (!this.windowListenersInited) {
            this.windowListenersInited = true;
            if (TranslucencyUtil.get().isTranslucencySupported(false)) {
                this.searchWindowOpacityListener = new ChildWindowListener(this);
                this.searchWindowOpacityListener.setTranslucencyRule(this.searchWindowOpacityRule);
            }
        }
        if (this.searchWindowOpacityListener != null) {
            w.addWindowFocusListener(this.searchWindowOpacityListener);
            w.addComponentListener(this.searchWindowOpacityListener);
        }
    }

    void removeDockableWindow(DockableWindow wind) {
        ((DockableWindowPanel)this.mainContentPanel).removeDockableWindow(wind);
    }

    public void savePreferences() {
        Plugin[] plugins;
        super.savePreferences();
        this.saveActionShortcuts(RText.getShortcutsFile());
        for (Plugin plugin : plugins = this.getPlugins()) {
            plugin.savePreferences();
        }
        if (this.chooser != null) {
            this.chooser.savePreferences();
        }
    }

    private void setIconGroupByName(String name) {
        org.fife.ui.app.icons.IconGroup iconGroup;
        org.fife.ui.app.icons.IconGroup newGroup = this.iconGroupMap.get(name);
        if (newGroup == null) {
            newGroup = this.iconGroupMap.get(DEFAULT_ICON_GROUP_NAME);
        }
        if ((iconGroup = this.getIconGroup()) != null && iconGroup.equals(newGroup)) {
            return;
        }
        this.setIconGroup(newGroup);
    }

    public void setMainViewStyle(int viewStyle) {
        if ((viewStyle == 0 || viewStyle == 1 || viewStyle == 2) && viewStyle != this.mainViewStyle) {
            PropertyChangeListener[] propertyChangeListeners;
            int oldMainViewStyle = this.mainViewStyle;
            this.mainViewStyle = viewStyle;
            AbstractMainView fromView = this.mainView;
            RTextPrefs prefs = (RTextPrefs)this.getActivePreferencesState();
            switch (viewStyle) {
                case 0: {
                    this.mainView = new RTextTabbedPaneView(this, null, prefs);
                    this.menuBar.setWindowMenuVisible(false);
                    break;
                }
                case 1: {
                    this.mainView = new RTextSplitPaneView(this, null, prefs);
                    this.menuBar.setWindowMenuVisible(false);
                    break;
                }
                case 2: {
                    this.mainView = new RTextMDIView(this, null, prefs);
                    this.menuBar.setWindowMenuVisible(true);
                }
            }
            for (PropertyChangeListener listener : propertyChangeListeners = fromView.getPropertyChangeListeners()) {
                fromView.removePropertyChangeListener(listener);
                this.mainView.addPropertyChangeListener(listener);
            }
            this.mainView.getSearchManager().changeSearchListener(fromView);
            this.mainView.copyData(fromView);
            this.removePropertyChangeListener("iconStyle", fromView);
            if (this.mainView instanceof RTextTabbedPaneView && this.mainView.getSelectedIndex() == this.mainView.getNumDocuments() - 1) {
                ((RTextTabbedPaneView)this.mainView).stateChanged(new ChangeEvent(this.mainView));
            }
            Dimension size = this.getSize();
            this.csp.remove((Component)fromView);
            this.csp.add((Component)this.mainView);
            fromView.dispose();
            this.pack();
            this.setSize(size);
            if (this.mainView instanceof RTextMDIView) {
                this.mainView.setSelectedIndex(this.mainView.getSelectedIndex());
            }
            this.firePropertyChange(MAIN_VIEW_STYLE_PROPERTY, oldMainViewStyle, this.mainViewStyle);
        }
    }

    public void setMessages(String fileFullPath, String statusMessage) {
        StatusBar statusBar;
        if (fileFullPath != null) {
            this.setTitle(fileFullPath);
        }
        if ((statusBar = (StatusBar)this.getStatusBar()) != null && statusMessage != null) {
            statusBar.setStatusMessage(statusMessage);
        }
    }

    public void setRowColumnIndicatorVisible(boolean isVisible) {
        ((StatusBar)this.getStatusBar()).setRowColumnIndicatorVisible(isVisible);
    }

    public void setShowHostName(boolean show) {
        if (this.showHostName != show) {
            this.showHostName = show;
            this.setTitle(this.getTitle());
        }
    }

    public void setStatusBarReadOnlyIndicatorEnabled(boolean enabled) {
        ((StatusBar)this.getStatusBar()).setReadOnlyIndicatorEnabled(enabled);
    }

    public void setSyntaxScheme(SyntaxScheme colorScheme) {
        if (colorScheme != null && !colorScheme.equals((Object)this.colorScheme)) {
            this.colorScheme = (SyntaxScheme)colorScheme.clone();
            if (this.mainView != null) {
                this.mainView.setSyntaxScheme(this.colorScheme);
            }
        }
    }

    public void setTabsEmulated(boolean areEmulated) {
        this.mainView.setTabsEmulated(areEmulated);
    }

    private void setTabSize(int newSize) {
        this.mainView.setTabSize(newSize);
    }

    public void setTitle(String title) {
        title = this.getShowHostName() ? "rtext (" + this.getHostName() + ") - " + (String)title : "rtext - " + (String)title;
        super.setTitle((String)title);
    }

    public void setSearchWindowOpacity(float opacity) {
        this.searchWindowOpacity = Math.max(0.0f, Math.min(opacity, 1.0f));
        if (this.windowListenersInited && this.isSearchWindowOpacityEnabled()) {
            this.searchWindowOpacityListener.refreshTranslucencies();
        }
    }

    public void setSearchWindowOpacityEnabled(boolean enabled) {
        if (enabled != this.searchWindowOpacityEnabled) {
            this.searchWindowOpacityEnabled = enabled;
            if (this.windowListenersInited && this.searchWindowOpacityListener != null) {
                this.searchWindowOpacityListener.refreshTranslucencies();
            }
        }
    }

    public void setSearchWindowOpacityRule(int rule) {
        if (rule != this.searchWindowOpacityRule) {
            this.searchWindowOpacityRule = rule;
            if (this.windowListenersInited) {
                this.searchWindowOpacityListener.setTranslucencyRule(rule);
            }
        }
    }

    public void setSpellingWindowVisible(boolean visible) {
        if (visible) {
            if (this.spellingWindow == null) {
                this.spellingWindow = new SpellingErrorWindow(this);
                DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
                dwp.addDockableWindow((DockableWindow)this.spellingWindow);
            } else {
                this.spellingWindow.setActive(true);
            }
        } else if (this.spellingWindow != null) {
            this.spellingWindow.setActive(false);
        }
    }

    protected void setThemeAdditionalProperties(AppTheme theme) {
        if (this.iconGroupMap != null) {
            this.setIconGroupByName((String)theme.getExtraUiDefaults().get("rtext.iconGroupName"));
        }
        Font font = this.getMainView() != null ? this.getMainView().getTextAreaFont() : null;
        try {
            Theme rstaTheme = RTextAppThemes.getRstaTheme(theme, font);
            this.installRstaTheme(rstaTheme);
        }
        catch (IOException ioe) {
            this.displayException(ioe);
        }
    }

    public void setWorkingDirectory(String directory) {
        File test = new File(directory);
        this.workingDirectory = test.isDirectory() ? directory : System.getProperty("user.dir");
    }

    private void updateAppIcon(String actionName, org.fife.ui.app.icons.IconGroup iconGroup, String iconName) {
        this.getAction(actionName).putValue("SmallIcon", iconGroup.getIcon(iconName));
        this.getAction(actionName).putValue("SmallRolloverIcon", iconGroup.getRolloverIcon(iconName));
    }

    protected void updateIconsForNewIconGroup(org.fife.ui.app.icons.IconGroup iconGroup) {
        super.updateIconsForNewIconGroup(iconGroup);
        Dimension size = this.getSize();
        this.updateTextAreaIcons();
        this.updateAppIcon("newAction", iconGroup, "new");
        this.updateAppIcon("openAction", iconGroup, "open");
        this.updateAppIcon("saveAction", iconGroup, "save");
        this.updateAppIcon("saveAllAction", iconGroup, "saveall");
        this.updateAppIcon("openNewWinAction", iconGroup, "openinnewwindow");
        this.updateAppIcon("saveAsAction", iconGroup, "saveas");
        this.updateAppIcon("optionsAction", iconGroup, "options");
        this.updateAppIcon("helpAction", iconGroup, "help");
        this.updateAppIcon("aboutAction", iconGroup, "about");
        this.updateAppIcon("closeAction", iconGroup, "close");
        this.updateAppIcon("findAction", iconGroup, "find");
        this.updateAppIcon("findNextAction", iconGroup, "findnext");
        this.updateAppIcon("replaceAction", iconGroup, "replace");
        this.updateAppIcon("replaceNextAction", iconGroup, "replacenext");
        this.updateAppIcon("printAction", iconGroup, "print");
        this.updateAppIcon("printPreviewAction", iconGroup, "printpreview");
        this.updateAppIcon("closeAllAction", iconGroup, "closeall");
        this.updateAppIcon("gotoAction", iconGroup, "goto");
        if (this.isDisplayable()) {
            this.pack();
            this.setSize(size);
        }
        if (this.helpDialog != null) {
            this.helpDialog.setBackButtonIcon(iconGroup.getIcon("back"));
            this.helpDialog.setForwardButtonIcon(iconGroup.getIcon("forward"));
        }
    }

    public void updateLookAndFeel(LookAndFeel lnf) {
        super.updateLookAndFeel(lnf);
        try {
            Dimension size = this.getSize();
            SwingUtilities.updateComponentTreeUI((Component)((Object)this));
            this.pack();
            this.setSize(size);
            if (this.mainView != null) {
                this.mainView.updateLookAndFeel();
            }
            if (this.optionsDialog != null) {
                SwingUtilities.updateComponentTreeUI((Component)this.optionsDialog);
                this.optionsDialog.pack();
            }
            if (this.helpDialog != null) {
                SwingUtilities.updateComponentTreeUI((Component)this.helpDialog);
                this.helpDialog.pack();
            }
            if (this.chooser != null) {
                SwingUtilities.updateComponentTreeUI((Component)this.chooser);
                this.chooser.updateUI();
            }
            if (this.rfc != null) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.rfc));
                this.rfc.updateUI();
            }
        }
        catch (Exception f) {
            this.displayException(f);
        }
    }

    public void preferences() {
        this.getAction("optionsAction").actionPerformed(new ActionEvent(this, 0, "unused"));
    }

    public void openFile(File file) {
        SwingUtilities.invokeLater(() -> this.mainView.openFile(file.getAbsolutePath(), null, true));
    }

    private void updateTextAreaIcon(int textAreaAction, String iconName) {
        Icon icon = this.getIconGroup().getIcon(iconName);
        Icon rolloverIcon = this.getIconGroup().getRolloverIcon(iconName);
        RecordableTextAction action = RTextArea.getAction((int)textAreaAction);
        if (action != null) {
            action.putValue("SmallIcon", icon);
            action.putValue("SmallRolloverIcon", rolloverIcon);
        }
    }

    private void updateTextAreaIcons() {
        this.updateTextAreaIcon(1, "cut");
        this.updateTextAreaIcon(0, "copy");
        this.updateTextAreaIcon(3, "paste");
        this.updateTextAreaIcon(2, "delete");
        this.updateTextAreaIcon(6, "undo");
        this.updateTextAreaIcon(4, "redo");
        this.updateTextAreaIcon(5, "selectall");
    }
}

