/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.io.File;
import java.util.List;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextAppThemes;
import org.fife.rtext.RTextMenuBar;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.SearchManager;
import org.fife.rtext.SpellingSupport;
import org.fife.rtext.StoreKeeper;
import org.fife.ui.app.AppContext;
import org.fife.ui.app.AppTheme;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.prefs.AppPrefs;

public class RTextAppContext
extends AppContext<RText, RTextPrefs> {
    public List<AppTheme> getAvailableAppThemes() {
        return RTextAppThemes.get();
    }

    protected String getPreferencesClassName() {
        return "org.fife.rtext.RTextPrefs";
    }

    public File getPreferencesDir() {
        return RTextUtilities.getPreferencesDirectory();
    }

    public String getPreferencesFileName() {
        return "rtext4.properties";
    }

    protected RText createApplicationImpl(String[] filesToOpen, RTextPrefs preferences) {
        RText rtext = new RText(this, filesToOpen, preferences);
        if (rtext.getMainViewStyle() == 2) {
            rtext.getMainView().setSelectedIndex(0);
        }
        StoreKeeper.addRTextInstance(rtext);
        return rtext;
    }

    protected void populatePrefsFromApplication(RText rtext, RTextPrefs prefs) {
        super.populatePrefsFromApplication((GUIApplication)rtext, (AppPrefs)prefs);
        prefs.appTheme = RTextUtilities.getAppThemeToSave(rtext);
        AbstractMainView mainView = rtext.getMainView();
        SpellingSupport spelling = mainView.getSpellingSupport();
        RTextMenuBar menuBar = (RTextMenuBar)((Object)rtext.getJMenuBar());
        prefs.lineNumbersVisible = mainView.getLineNumbersEnabled();
        prefs.tabSize = mainView.getTabSize();
        prefs.emulateTabsWithSpaces = mainView.areTabsEmulated();
        prefs.textMode = mainView.getTextMode();
        prefs.tabPlacement = mainView.getDocumentSelectionPlacement();
        prefs.printFont = mainView.getPrintFont();
        prefs.backgroundColor = mainView.getTextAreaBackgroundColor();
        prefs.imageAlpha = mainView.getTextAreaBackgroundImageAlpha();
        prefs.wordWrap = mainView.getLineWrap();
        prefs.caretColor = mainView.getCaretColor();
        prefs.selectionColor = mainView.getSelectionColor();
        prefs.selectedTextColor = mainView.getSelectedTextColor();
        prefs.useSelectedTextColor = mainView.getUseSelectedTextColor();
        prefs.colorScheme = rtext.getSyntaxScheme();
        prefs.syntaxFiltersString = mainView.getSyntaxFilters().toString();
        prefs.maxFileHistorySize = menuBar.getMaximumFileHistorySize();
        prefs.fileHistoryString = menuBar.getFileHistoryString();
        prefs.currentLineHighlightEnabled = mainView.isCurrentLineHighlightEnabled();
        prefs.currentLineHighlightColor = mainView.getCurrentLineHighlightColor();
        prefs.mainView = rtext.getMainViewStyle();
        prefs.overrideEditorStyles = mainView.getOverrideEditorStyles();
        prefs.bracketMatchingEnabled = mainView.isBracketMatchingEnabled();
        prefs.matchBothBrackets = mainView.getMatchBothBrackets();
        prefs.matchedBracketBGColor = mainView.getMatchedBracketBGColor();
        prefs.matchedBracketBorderColor = mainView.getMatchedBracketBorderColor();
        prefs.marginLineEnabled = mainView.isMarginLineEnabled();
        prefs.marginLinePosition = mainView.getMarginLinePosition();
        prefs.marginLineColor = mainView.getMarginLineColor();
        prefs.highlightSecondaryLanguages = mainView.getHighlightSecondaryLanguages();
        prefs.secondaryLanguageColors = new Color[3];
        for (int i = 0; i < prefs.secondaryLanguageColors.length; ++i) {
            prefs.secondaryLanguageColors[i] = mainView.getSecondaryLanguageColor(i);
        }
        prefs.visibleWhitespace = mainView.isWhitespaceVisible();
        prefs.showEOLMarkers = mainView.getShowEOLMarkers();
        prefs.showTabLines = mainView.getShowTabLines();
        prefs.tabLinesColor = mainView.getTabLinesColor();
        prefs.rememberWhitespaceLines = mainView.getRememberWhitespaceLines();
        prefs.autoInsertClosingCurlys = mainView.getAutoInsertClosingCurlys();
        prefs.aaEnabled = mainView.isAntiAliasEnabled();
        prefs.fractionalMetricsEnabled = mainView.isFractionalFontMetricsEnabled();
        prefs.markAllHighlightColor = mainView.getMarkAllHighlightColor();
        prefs.markOccurrences = mainView.getMarkOccurrences();
        prefs.markOccurrencesColor = mainView.getMarkOccurrencesColor();
        prefs.roundedSelectionEdges = mainView.getRoundedSelectionEdges();
        prefs.workingDirectory = rtext.getWorkingDirectory();
        prefs.carets[0] = mainView.getCaretStyle(0).ordinal();
        prefs.carets[1] = mainView.getCaretStyle(1).ordinal();
        prefs.caretBlinkRate = mainView.getCaretBlinkRate();
        prefs.dividerLocations[0] = rtext.getSplitPaneDividerLocation(0);
        prefs.dividerLocations[1] = rtext.getSplitPaneDividerLocation(1);
        prefs.dividerLocations[2] = rtext.getSplitPaneDividerLocation(2);
        prefs.dividerLocations[3] = rtext.getSplitPaneDividerLocation(3);
        prefs.dividerVisible[0] = rtext.isDockableWindowGroupExpanded(0);
        prefs.dividerVisible[1] = rtext.isDockableWindowGroupExpanded(1);
        prefs.dividerVisible[2] = rtext.isDockableWindowGroupExpanded(2);
        prefs.dividerVisible[3] = rtext.isDockableWindowGroupExpanded(3);
        prefs.defaultLineTerminator = mainView.getLineTerminator();
        prefs.defaultEncoding = mainView.getDefaultEncoding();
        prefs.guessFileContentType = mainView.getGuessFileContentType();
        prefs.doFileSizeCheck = mainView.getDoFileSizeCheck();
        prefs.maxFileSize = mainView.getMaxFileSize();
        prefs.maxFileSizeForCodeFolding = mainView.getMaxFileSizeForCodeFolding();
        prefs.ignoreBackupExtensions = mainView.getIgnoreBackupExtensions();
        prefs.textAreaFont = mainView.getTextAreaFont();
        prefs.textAreaUnderline = mainView.getTextAreaUnderline();
        prefs.textAreaForeground = mainView.getTextAreaForeground();
        prefs.textAreaOrientation = mainView.getTextAreaOrientation();
        prefs.foldIndicatorStyle = mainView.getFoldIndicatorStyle();
        prefs.foldForeground = mainView.getFoldForeground();
        prefs.armedFoldForeground = mainView.getArmedFoldForeground();
        prefs.foldBackground = mainView.getFoldBackground();
        prefs.armedFoldBackground = mainView.getArmedFoldBackground();
        prefs.showHostName = rtext.getShowHostName();
        prefs.bomInUtf8 = mainView.getWriteBOMInUtf8Files();
        prefs.lineNumberFont = mainView.getLineNumberFont();
        prefs.lineNumberColor = mainView.getLineNumberColor();
        prefs.gutterBorderColor = mainView.getGutterBorderColor();
        prefs.spellCheckingEnabled = spelling.isSpellCheckingEnabled();
        prefs.spellCheckingColor = spelling.getSpellCheckingColor();
        prefs.spellingDictionary = spelling.getSpellingDictionary();
        prefs.userDictionary = spelling.getUserDictionary();
        prefs.maxSpellingErrors = spelling.getMaxSpellingErrors();
        prefs.viewSpellingList = rtext.isSpellingWindowVisible();
        prefs.searchWindowOpacityEnabled = rtext.isSearchWindowOpacityEnabled();
        prefs.searchWindowOpacity = rtext.getSearchWindowOpacity();
        prefs.searchWindowOpacityRule = rtext.getSearchWindowOpacityRule();
        prefs.dropShadowsInEditor = RTextUtilities.getDropShadowsEnabledInEditor();
        prefs.codeFoldingEnabledFor = mainView.getCodeFoldingEnabledForString();
        prefs.useSearchDialogs = mainView.getSearchManager().getSearchingMode() == SearchManager.SearchingMode.DIALOGS;
    }
}

