/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.fife.ui.app.AppTheme;
import org.fife.ui.app.console.AbstractConsoleTextArea;
import org.fife.ui.app.themes.FlatDarkTheme;
import org.fife.ui.app.themes.FlatLightTheme;
import org.fife.ui.app.themes.FlatMacDarkTheme;
import org.fife.ui.app.themes.FlatMacLightTheme;
import org.fife.ui.app.themes.NativeTheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.util.MacOSUtil;

public final class RTextAppThemes {
    public static final Color LIGHT_MODIFIED_DOCUMENT_NAME_COLOR = Color.RED;
    public static final Color DARK_MODIFIED_DOCUMENT_NAME_COLOR = new Color(255, 128, 128);

    private RTextAppThemes() {
    }

    static List<AppTheme> get() {
        Color lightListAltRowColor = new Color(0xF4F4F4);
        Color darkListAltRowColor = new Color(60, 63, 65);
        ArrayList<AppTheme> themes = new ArrayList<AppTheme>();
        NativeTheme nativeTheme = new NativeTheme();
        nativeTheme.setHyperlinkForeground(Color.BLUE);
        nativeTheme.addExtraUiDefault("rtext.editorTheme", (Object)"/org/fife/ui/rsyntaxtextarea/themes/default-alt.xml");
        nativeTheme.addExtraUiDefault("rtext.iconGroupName", (Object)"Eclipse Icons");
        nativeTheme.addExtraUiDefault("rtext.labelErrorForeground", (Object)LIGHT_MODIFIED_DOCUMENT_NAME_COLOR);
        nativeTheme.addExtraUiDefault("rtext.listAltRowColor", (Object)lightListAltRowColor);
        nativeTheme.addExtraUiDefault("rtext.console.prompt", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_PROMPT_FG);
        nativeTheme.addExtraUiDefault("rtext.console.stdout", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_STDOUT_FG);
        nativeTheme.addExtraUiDefault("rtext.console.stderr", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_STDERR_FG);
        nativeTheme.addExtraUiDefault("rtext.console.result", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_RESULT_FG);
        themes.add((AppTheme)nativeTheme);
        FlatDarkTheme flatDarkTheme = new FlatDarkTheme();
        flatDarkTheme.setHyperlinkForeground(new Color(5807606));
        flatDarkTheme.addExtraUiDefault("rtext.editorTheme", (Object)"/org/fife/ui/rsyntaxtextarea/themes/dark.xml");
        flatDarkTheme.addExtraUiDefault("rtext.iconGroupName", (Object)"IntelliJ Icons (Dark)");
        flatDarkTheme.addExtraUiDefault("rtext.labelErrorForeground", (Object)DARK_MODIFIED_DOCUMENT_NAME_COLOR);
        flatDarkTheme.addExtraUiDefault("rtext.listAltRowColor", (Object)darkListAltRowColor);
        flatDarkTheme.addExtraUiDefault("rtext.console.prompt", (Object)AbstractConsoleTextArea.DEFAULT_DARK_PROMPT_FG);
        flatDarkTheme.addExtraUiDefault("rtext.console.stdout", (Object)AbstractConsoleTextArea.DEFAULT_DARK_STDOUT_FG);
        flatDarkTheme.addExtraUiDefault("rtext.console.stderr", (Object)AbstractConsoleTextArea.DEFAULT_DARK_STDERR_FG);
        flatDarkTheme.addExtraUiDefault("rtext.console.result", (Object)AbstractConsoleTextArea.DEFAULT_DARK_RESULT_FG);
        themes.add((AppTheme)flatDarkTheme);
        FlatLightTheme flatLightTheme = new FlatLightTheme();
        flatLightTheme.setHyperlinkForeground(Color.BLUE);
        flatLightTheme.addExtraUiDefault("rtext.editorTheme", (Object)"/org/fife/ui/rsyntaxtextarea/themes/default-alt.xml");
        flatLightTheme.addExtraUiDefault("rtext.iconGroupName", (Object)"IntelliJ Icons (Light)");
        flatLightTheme.addExtraUiDefault("rtext.labelErrorForeground", (Object)LIGHT_MODIFIED_DOCUMENT_NAME_COLOR);
        flatLightTheme.addExtraUiDefault("rtext.listAltRowColor", (Object)lightListAltRowColor);
        flatLightTheme.addExtraUiDefault("rtext.console.prompt", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_PROMPT_FG);
        flatLightTheme.addExtraUiDefault("rtext.console.stdout", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_STDOUT_FG);
        flatLightTheme.addExtraUiDefault("rtext.console.stderr", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_STDERR_FG);
        flatLightTheme.addExtraUiDefault("rtext.console.result", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_RESULT_FG);
        themes.add((AppTheme)flatLightTheme);
        if (MacOSUtil.isMacOs()) {
            FlatMacDarkTheme flatMacDarkTheme = new FlatMacDarkTheme();
            flatMacDarkTheme.setHyperlinkForeground(new Color(5807606));
            flatMacDarkTheme.addExtraUiDefault("rtext.editorTheme", (Object)"/org/fife/ui/rsyntaxtextarea/themes/monokai.xml");
            flatMacDarkTheme.addExtraUiDefault("rtext.iconGroupName", (Object)"IntelliJ Icons (Dark)");
            flatMacDarkTheme.addExtraUiDefault("rtext.labelErrorForeground", (Object)DARK_MODIFIED_DOCUMENT_NAME_COLOR);
            flatMacDarkTheme.addExtraUiDefault("rtext.listAltRowColor", (Object)darkListAltRowColor);
            flatMacDarkTheme.addExtraUiDefault("rtext.console.prompt", (Object)AbstractConsoleTextArea.DEFAULT_DARK_PROMPT_FG);
            flatMacDarkTheme.addExtraUiDefault("rtext.console.stdout", (Object)AbstractConsoleTextArea.DEFAULT_DARK_STDOUT_FG);
            flatMacDarkTheme.addExtraUiDefault("rtext.console.stderr", (Object)AbstractConsoleTextArea.DEFAULT_DARK_STDERR_FG);
            flatMacDarkTheme.addExtraUiDefault("rtext.console.result", (Object)AbstractConsoleTextArea.DEFAULT_DARK_RESULT_FG);
            themes.add((AppTheme)flatMacDarkTheme);
            FlatMacLightTheme flatMacLightTheme = new FlatMacLightTheme();
            flatMacLightTheme.setHyperlinkForeground(Color.BLUE);
            flatMacLightTheme.addExtraUiDefault("rtext.editorTheme", (Object)"/org/fife/ui/rsyntaxtextarea/themes/default-alt.xml");
            flatMacLightTheme.addExtraUiDefault("rtext.iconGroupName", (Object)"IntelliJ Icons (Light)");
            flatMacLightTheme.addExtraUiDefault("rtext.labelErrorForeground", (Object)LIGHT_MODIFIED_DOCUMENT_NAME_COLOR);
            flatMacLightTheme.addExtraUiDefault("rtext.listAltRowColor", (Object)lightListAltRowColor);
            flatMacLightTheme.addExtraUiDefault("rtext.console.prompt", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_PROMPT_FG);
            flatMacLightTheme.addExtraUiDefault("rtext.console.stdout", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_STDOUT_FG);
            flatMacLightTheme.addExtraUiDefault("rtext.console.stderr", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_STDERR_FG);
            flatMacLightTheme.addExtraUiDefault("rtext.console.result", (Object)AbstractConsoleTextArea.DEFAULT_LIGHT_RESULT_FG);
            themes.add((AppTheme)flatMacLightTheme);
        }
        return themes;
    }

    public static Theme getRstaTheme(AppTheme theme, Font baseFont) throws IOException {
        String rstaThemeName = (String)theme.getExtraUiDefaults().get("rtext.editorTheme");
        return Theme.load((InputStream)RTextAppThemes.class.getResourceAsStream(rstaThemeName), (Font)baseFont);
    }
}

