/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.print.PageFormat;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import org.fife.print.RPrintUtilities;
import org.fife.rtext.MainPanelTransferHandler;
import org.fife.rtext.RText;
import org.fife.ui.StandardMenuItem;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rtextarea.RTATextTransferHandler;

public class RTextEditorPane
extends TextEditorPane {
    private RText rtext;

    public RTextEditorPane(RText rtext, boolean wordWrapEnabled, int textMode, FileLocation loc, String encoding) throws IOException {
        super(textMode, wordWrapEnabled, loc, encoding);
        this.rtext = rtext;
        this.setTransferHandler((TransferHandler)((Object)new RTextEditorPaneTransferHandler()));
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = super.createPopupMenu();
        popup.addSeparator();
        popup.add(this.createPopupMenuItem(this.rtext.getAction("FileSystemTree.SelectCurrentFileAction")));
        return popup;
    }

    protected JMenuItem createPopupMenuItem(Action a) {
        StandardMenuItem item = new StandardMenuItem(a){

            public void setToolTipText(String text) {
            }
        };
        item.setAccelerator(null);
        return item;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        Font printWithMeFont = this.rtext.getMainView().getPrintFont();
        if (printWithMeFont == null) {
            printWithMeFont = this.getFont();
        }
        return RPrintUtilities.printDocumentWordWrap((Graphics)g, (JTextComponent)((Object)this), (Font)printWithMeFont, (int)pageIndex, (PageFormat)pageFormat, (int)this.getTabSize());
    }

    class RTextEditorPaneTransferHandler
    extends RTATextTransferHandler {
        RTextEditorPaneTransferHandler() {
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return MainPanelTransferHandler.hasFileFlavor(flavors) || super.canImport(c, flavors);
        }

        public boolean importData(JComponent c, Transferable t) {
            return MainPanelTransferHandler.importDataImpl(RTextEditorPane.this.rtext.getMainView(), c, t) || super.importData(c, t);
        }
    }
}

