/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.MainPanelTransferHandler;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextPrefs;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rtextarea.RTextScrollPane;

class RTextMDIView
extends AbstractMainView
implements InternalFrameListener {
    private static final int CASCADE_X_INCREMENT = 30;
    private static final int CASCADE_Y_INCREMENT = 30;
    private static int openFrameCount;
    private JDesktopPane desktopPane;
    private List<InternalFrame> frames = new ArrayList<InternalFrame>(5);
    private JPopupMenu popupMenu;
    private int documentSelectionPlacement;

    RTextMDIView(RText owner, String[] filesToOpen, RTextPrefs properties) {
        this.setLayout(new GridLayout(1, 1));
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(Color.GRAY);
        this.desktopPane.addMouseListener(new MDIMouseListener());
        this.add(this.desktopPane);
        MainPanelTransferHandler th = new MainPanelTransferHandler(this);
        this.desktopPane.setTransferHandler(th);
        this.initialize(owner, filesToOpen, properties);
    }

    @Override
    protected void addTextAreaImpl(String title, Component component, String fileFullPath) {
        JPanel temp = new JPanel(new BorderLayout());
        temp.add(component);
        RTextScrollPane sp = (RTextScrollPane)component;
        RTextEditorPane textArea = (RTextEditorPane)sp.getTextArea();
        ErrorStrip es = this.createErrorStrip(textArea);
        temp.add((Component)es, "After");
        InternalFrame frame = new InternalFrame(title, temp);
        frame.setVisible(true);
        frame.addInternalFrameListener(this);
        this.desktopPane.add(frame);
        this.frames.add(frame);
        int numDocuments = this.getNumDocuments();
        for (int i = 0; i < numDocuments - 1; ++i) {
            if (!this.getRTextEditorPaneAt(i).getFileFullPath().equals(fileFullPath)) continue;
            int count = 0;
            for (int j = i; j < numDocuments; ++j) {
                RTextEditorPane pane = this.getRTextEditorPaneAt(j);
                if (!pane.getFileFullPath().equals(fileFullPath)) continue;
                String newTitle = title + " (" + ++count + ")";
                if (pane.isDirty()) {
                    newTitle = newTitle + "*";
                }
                try {
                    this.setDocumentDisplayNameAt(j, newTitle);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e);
                }
            }
            break;
        }
        this.setSelectedIndex(numDocuments - 1);
        if (this.getCurrentTextArea().isDirty()) {
            this.owner.setMessages(fileFullPath + "*", "Opened document '" + fileFullPath + "'");
        } else {
            this.owner.setMessages(fileFullPath, "Opened document '" + fileFullPath + "'");
        }
    }

    public void cascadeWindows() {
        int x = 0;
        int y = 0;
        int numRows = 0;
        Dimension desktopSize = this.desktopPane.getSize();
        int size = this.frames.size();
        int selectedIndex = this.getSelectedIndex();
        for (int i = 0; i < size; ++i) {
            if (i == selectedIndex) continue;
            JInternalFrame frame = this.frames.get(i);
            frame.setBounds(x, y, 300, 300);
            frame.toFront();
            x += 30;
            if ((y += 30) + 300 < desktopSize.height) continue;
            x = 60 * ++numRows + 15;
            y = 0;
        }
        JInternalFrame currentFrame = this.frames.get(selectedIndex);
        currentFrame.setBounds(x, y, 300, 300);
        currentFrame.toFront();
    }

    @Override
    protected synchronized boolean closeCurrentDocumentImpl() {
        ResourceBundle msg = this.owner.getResourceBundle();
        int rc = this.promptToSaveBeforeClosingIfDirty();
        if (rc == 2) {
            return false;
        }
        this.removeComponentAt(this.getSelectedIndex());
        if (this.getNumDocuments() > 0) {
            this.renumberDisplayNames();
            JInternalFrame frame = this.frames.get(0);
            this.desktopPane.setSelectedFrame(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            frame.toFront();
        } else {
            this.addNewEmptyUntitledFile();
        }
        this.updateStatusBar();
        RTextEditorPane editor = this.getCurrentTextArea();
        if (editor.isDirty()) {
            this.owner.setMessages(editor.getFileFullPath() + "*", msg.getString("Ready"));
        } else {
            this.owner.setMessages(editor.getFileFullPath(), msg.getString("Ready"));
        }
        return true;
    }

    protected void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RTextMDIView.this.tileWindowsVertically();
            }
        });
        menuItem.setText("Tile Vertically");
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RTextMDIView.this.tileWindowsHorizontally();
            }
        });
        menuItem.setText("Tile Horizontally");
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RTextMDIView.this.cascadeWindows();
            }
        });
        menuItem.setText("Cascade");
        this.popupMenu.add(menuItem);
    }

    @Override
    public String getDocumentDisplayNameAt(int index) {
        if (index >= 0 && index < this.getNumDocuments()) {
            return this.frames.get(index).getTitle();
        }
        return null;
    }

    @Override
    public int getDocumentSelectionPlacement() {
        return this.documentSelectionPlacement;
    }

    @Override
    public int getNumDocuments() {
        return this.frames.size();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension(300, 300);
        for (InternalFrame frame : this.frames) {
            Dimension framePreferredSize = frame.getPreferredSize();
            preferredSize.width = Math.max(framePreferredSize.width, preferredSize.width);
            preferredSize.height = Math.max(framePreferredSize.height, preferredSize.height);
        }
        return preferredSize;
    }

    @Override
    public RTextScrollPane getRTextScrollPaneAt(int index) {
        if (index < 0 || index >= this.getNumDocuments()) {
            return null;
        }
        JPanel temp = (JPanel)this.frames.get(index).getContentPane().getComponent(0);
        return (RTextScrollPane)temp.getComponent(0);
    }

    @Override
    public Component getSelectedComponent() {
        return this.desktopPane.getSelectedFrame();
    }

    @Override
    public int getSelectedIndex() {
        return this.frames.indexOf(this.desktopPane.getSelectedFrame());
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        RTextEditorPane current = this.getRTextEditorPaneAt(this.getSelectedIndex());
        this.setCurrentTextArea(current);
        String title = current.getFileFullPath() + (current.isDirty() ? "*" : "");
        this.owner.setMessages(title, null);
        this.updateStatusBar();
        current.addCaretListener(this.owner);
        this.owner.caretUpdate(null);
        this.firePropertyChange("MainView.currentDocument", -1, this.getSelectedIndex());
        this.fireCurrentTextAreaEvent(0, null, (Object)current);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.setSelectedIndex(this.frames.indexOf(e.getInternalFrame()));
        this.owner.getAction("closeAction").actionPerformed(null);
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        this.getCurrentTextArea().removeCaretListener(this.owner);
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void refreshDisplayNames() {
    }

    @Override
    public void refreshTabIcons() {
        for (InternalFrame frame : this.frames) {
            frame.refreshIcon();
        }
    }

    @Override
    protected void removeComponentAt(int index) {
        if (index >= 0 && index < this.getNumDocuments()) {
            this.frames.get(index).dispose();
            this.frames.remove(index);
        }
    }

    @Override
    public void setDocumentDisplayNameAt(int index, String displayName) {
        if (index >= 0 && index < this.getNumDocuments()) {
            this.frames.get(index).setTitle(displayName);
        }
    }

    @Override
    public void setDocumentSelectionPlacement(int location) {
        if (location == 1 || location == 2 || location == 3 || location == 4) {
            this.documentSelectionPlacement = location;
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.getNumDocuments()) {
            JInternalFrame frame = this.frames.get(index);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.desktopPane.setSelectedFrame(frame);
        }
    }

    public void tileWindowsHorizontally() {
        int numToResize = 0;
        for (JInternalFrame jInternalFrame : this.frames) {
            if (!jInternalFrame.isVisible() || jInternalFrame.isIcon()) continue;
            if (!jInternalFrame.isResizable()) {
                try {
                    jInternalFrame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                continue;
            }
            ++numToResize;
        }
        if (numToResize > 0) {
            Rectangle desktopBounds = this.desktopPane.getBounds();
            int n = desktopBounds.width;
            int desktopHeight = desktopBounds.height;
            int fHeight = desktopHeight / numToResize;
            int yPos = 0;
            for (JInternalFrame jInternalFrame : this.frames) {
                if (!jInternalFrame.isVisible() || !jInternalFrame.isResizable() || jInternalFrame.isIcon()) continue;
                jInternalFrame.setSize(n, fHeight);
                jInternalFrame.setLocation(0, yPos);
                yPos += fHeight;
            }
        }
    }

    public void tileWindowsVertically() {
        int numToResize = 0;
        for (JInternalFrame jInternalFrame : this.frames) {
            if (!jInternalFrame.isVisible() || jInternalFrame.isIcon()) continue;
            if (!jInternalFrame.isResizable()) {
                try {
                    jInternalFrame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                continue;
            }
            ++numToResize;
        }
        if (numToResize > 0) {
            Rectangle desktopBounds = this.desktopPane.getBounds();
            int n = desktopBounds.width;
            int desktopHeight = desktopBounds.height;
            int fWidth = n / numToResize;
            int xPos = 0;
            for (JInternalFrame jInternalFrame : this.frames) {
                if (!jInternalFrame.isVisible() || !jInternalFrame.isResizable() || jInternalFrame.isIcon()) continue;
                jInternalFrame.setBounds(xPos, 0, fWidth, desktopHeight);
                xPos += fWidth;
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
    }

    class MDIMouseListener
    extends MouseAdapter {
        MDIMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (RTextMDIView.this.popupMenu == null) {
                    RTextMDIView.this.createPopupMenu();
                }
                RTextMDIView.this.popupMenu.show(RTextMDIView.this.desktopPane, e.getX(), e.getY());
            }
        }
    }

    class InternalFrame
    extends JInternalFrame {
        private static final int X_OFFSET = 30;
        private static final int Y_OFFSET = 30;
        private RTextScrollPane scrollPane;

        InternalFrame(String title, Component component) {
            super(title, true, true, true, true);
            this.scrollPane = (RTextScrollPane)((JPanel)component).getComponent(0);
            this.setFrameIcon(RTextMDIView.this.getIconFor(this.scrollPane));
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new GridLayout(1, 1));
            contentPane.add(component);
            if (++openFrameCount > 8) {
                openFrameCount = 0;
            }
            this.setDefaultCloseOperation(0);
            this.pack();
            this.setLocation(30 * openFrameCount, 30 * openFrameCount);
        }

        void refreshIcon() {
            this.setFrameIcon(RTextMDIView.this.getIconFor(this.scrollPane));
        }
    }
}

