/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.OpenFileAction;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextMDIView;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.OS;
import org.fife.ui.RecentFilesMenu;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.MenuBar;
import org.fife.ui.app.icons.IconGroup;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class RTextMenuBar
extends MenuBar<RText>
implements PropertyChangeListener,
PopupMenuListener {
    public static final String MENU_FILE = "File";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_SEARCH = "Search";
    public static final String MENU_VIEW = "View";
    public static final String MENU_DOCKED_WINDOWS = "DockedWindows";
    public static final String MENU_MACROS = "Macros";
    public static final String MENU_HELP = "Help";
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem openInNewWindowItem;
    private JMenuItem openRecentItem;
    private JMenuItem openRemoteItem;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem saveAsRemoteItem;
    private JMenuItem saveAsWebPageItem;
    private JMenuItem saveAllItem;
    private JMenuItem closeItem;
    private JMenuItem closeAllItem;
    private JMenuItem printItem;
    private JMenuItem printPreviewItem;
    private JMenuItem exitItem;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem copyAsStyledTextItem;
    private JMenuItem copyAsStyledTextMonokaiItem;
    private JMenuItem copyAsStyledTextEclipseItem;
    private JMenuItem pasteItem;
    private JMenuItem deleteItem;
    private JMenuItem findItem;
    private JMenuItem findNextItem;
    private JMenuItem replaceItem;
    private JMenuItem replaceNextItem;
    private JMenuItem findInFilesItem;
    private JMenuItem replaceInFilesItem;
    private JMenuItem goToItem;
    private JMenuItem selectAllItem;
    private JMenuItem timeDateItem;
    private JMenuItem optionsItem;
    private JCheckBoxMenuItem toolbarItem;
    private JCheckBoxMenuItem statusBarItem;
    private JCheckBoxMenuItem lineNumbersItem;
    private JMenuItem nextDocItem;
    private JMenuItem prevDocItem;
    private JMenuItem increaseFontSizesItem;
    private JMenuItem decreaseFontSizesItem;
    private JMenuItem helpItem;
    private JMenuItem homePageItem;
    private JMenuItem updatesItem;
    private JMenuItem aboutItem;
    private JMenuItem filePropItem;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private JMenu windowMenu;
    private RecentFilesMenu recentFilesMenu;
    private JMenu savedMacroMenu;

    public RTextMenuBar(RText rtext) {
        super((AbstractGUIApplication)rtext);
    }

    private void addCopyAsSubMenu(JMenu menu) {
        RText rtext = (RText)this.getApplication();
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.rtext.actions.Actions");
        JMenu subMenu = new JMenu(msg.getString("CopyAs"));
        this.copyAsStyledTextItem = this.createMenuItem(rtext.getAction("copyAsStyledText"));
        subMenu.add(this.copyAsStyledTextItem);
        String[] themes = new String[]{"dark", "default", "eclipse", "idea", "monokai"};
        try {
            for (String theme : themes) {
                String themeTitleCase = Character.toUpperCase(theme.charAt(0)) + theme.substring(1);
                String title = MessageFormat.format(msg.getString("CopyAsStyledTextAction.Themed"), themeTitleCase);
                subMenu.add(this.createCopyAsStyledTextMenuItem(title, theme));
            }
        }
        catch (IOException ioe) {
            rtext.displayException(ioe);
        }
        menu.add(subMenu);
    }

    private JMenuItem createCopyAsStyledTextMenuItem(String title, String themeName) throws IOException {
        Theme theme = Theme.load((InputStream)this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + themeName + ".xml"));
        RSyntaxTextAreaEditorKit.CopyCutAsStyledTextAction action = new RSyntaxTextAreaEditorKit.CopyCutAsStyledTextAction(themeName, theme, false);
        action.setName(title);
        return this.createMenuItem((Action)action);
    }

    private void addFileToFileHistory(String fileFullPath) {
        RText rtext = (RText)this.getApplication();
        if (fileFullPath.endsWith(File.separatorChar + rtext.getNewFileName()) || "-".equals(fileFullPath)) {
            return;
        }
        this.recentFilesMenu.addFileToFileHistory(fileFullPath);
    }

    public void addNotify() {
        super.addNotify();
        RText rtext = (RText)this.getApplication();
        List<FileLocation> recentFiles = rtext.getRecentFiles();
        ArrayList<FileLocation> recentFilesCopy = new ArrayList<FileLocation>(recentFiles);
        Collections.reverse(recentFilesCopy);
        for (FileLocation file : recentFilesCopy) {
            this.recentFilesMenu.addFileToFileHistory(file.getFileFullPath());
        }
    }

    private JMenu createEditMenu(ResourceBundle menuMsg, int defaultModifier, int shift) {
        RText rtext = (RText)this.getApplication();
        JMenu menu = this.createMenu(menuMsg, "MenuEdit");
        this.undoItem = this.createMenuItem((Action)RTextArea.getAction((int)6));
        menu.add(this.undoItem);
        this.redoItem = this.createMenuItem((Action)RTextArea.getAction((int)4));
        menu.add(this.redoItem);
        menu.addSeparator();
        this.cutItem = this.createMenuItem((Action)RTextArea.getAction((int)1));
        menu.add(this.cutItem);
        this.copyItem = this.createMenuItem((Action)RTextArea.getAction((int)0));
        menu.add(this.copyItem);
        this.addCopyAsSubMenu(menu);
        this.pasteItem = this.createMenuItem((Action)RTextArea.getAction((int)3));
        menu.add(this.pasteItem);
        this.deleteItem = this.createMenuItem((Action)RTextArea.getAction((int)2));
        menu.add(this.deleteItem);
        menu.addSeparator();
        this.selectAllItem = this.createMenuItem((Action)RTextArea.getAction((int)5));
        menu.add(this.selectAllItem);
        this.timeDateItem = this.createMenuItem(rtext.getAction("timeDateAction"));
        menu.add(this.timeDateItem);
        menu.addSeparator();
        JMenu textMenu = this.createMenu(menuMsg, "MenuText");
        JMenuItem menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.ToggleCommentAction(), menuMsg, "ToggleComment", "ToggleCommentMnemonic", KeyStroke.getKeyStroke(47, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescToggleComment");
        textMenu.add(menuItem);
        textMenu.addSeparator();
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.DeleteRestOfLineAction(), menuMsg, "DeleteLineRemainder", "DeleteLineRemainderMnemonic", KeyStroke.getKeyStroke(127, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescDeleteLineRemainder");
        textMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.JoinLinesAction(), menuMsg, "JoinLines", "JoinLinesMnemonic", KeyStroke.getKeyStroke(74, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescJoinLines");
        textMenu.add(menuItem);
        textMenu.addSeparator();
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.UpperSelectionCaseAction(), menuMsg, "UpperCase", "UpperCaseMnemonic");
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescUpperCase");
        textMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.LowerSelectionCaseAction(), menuMsg, "LowerCase", "LowerCaseMnemonic");
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescLowerCase");
        textMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.InvertSelectionCaseAction(), menuMsg, "InvertCase", "InvertCaseMnemonic");
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescInvertCase");
        textMenu.add(menuItem);
        menu.add(textMenu);
        JMenu indentMenu = this.createMenu(menuMsg, "MenuIndent");
        menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.InsertTabAction(), menuMsg, "IncreaseIndent", "IncreaseIndentMnemonic", KeyStroke.getKeyStroke(9, 0));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescIncreaseIndent");
        indentMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.DecreaseIndentAction(), menuMsg, "DecreaseIndent", "DecreaseIndentMnemonic", KeyStroke.getKeyStroke(9, shift));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescDecreaseIndent");
        indentMenu.add(menuItem);
        menu.add(indentMenu);
        if (rtext.getOS() != OS.MAC_OS_X) {
            menu.addSeparator();
            this.optionsItem = this.createMenuItem(rtext.getAction("optionsAction"));
            menu.add(this.optionsItem);
        }
        return menu;
    }

    private JMenu createFileMenu(ResourceBundle menuMsg) {
        final RText rtext = (RText)this.getApplication();
        JMenu fileMenu = this.createMenu(menuMsg, "MenuFile");
        this.newItem = this.createMenuItem(rtext.getAction("newAction"));
        fileMenu.add(this.newItem);
        this.openItem = this.createMenuItem(rtext.getAction("openAction"));
        fileMenu.add(this.openItem);
        this.openInNewWindowItem = this.createMenuItem(rtext.getAction("openNewWinAction"));
        fileMenu.add(this.openInNewWindowItem);
        this.openRecentItem = this.createMenuItem(rtext.getAction("openRecentAction"));
        fileMenu.add(this.openRecentItem);
        this.openRemoteItem = this.createMenuItem(rtext.getAction("openRemoteAction"));
        fileMenu.add(this.openRemoteItem);
        this.closeItem = this.createMenuItem(rtext.getAction("closeAction"));
        fileMenu.add(this.closeItem);
        this.closeAllItem = this.createMenuItem(rtext.getAction("closeAllAction"));
        fileMenu.add(this.closeAllItem);
        fileMenu.addSeparator();
        this.saveItem = this.createMenuItem(rtext.getAction("saveAction"));
        fileMenu.add(this.saveItem);
        this.saveAsItem = this.createMenuItem(rtext.getAction("saveAsAction"));
        fileMenu.add(this.saveAsItem);
        this.saveAsRemoteItem = this.createMenuItem(rtext.getAction("saveAsRemoteAction"));
        fileMenu.add(this.saveAsRemoteItem);
        this.saveAsWebPageItem = this.createMenuItem(rtext.getAction("saveWebPageAction"));
        fileMenu.add(this.saveAsWebPageItem);
        this.saveAllItem = this.createMenuItem(rtext.getAction("saveAllAction"));
        fileMenu.add(this.saveAllItem);
        fileMenu.addSeparator();
        this.printItem = this.createMenuItem(rtext.getAction("printAction"));
        fileMenu.add(this.printItem);
        this.printPreviewItem = this.createMenuItem(rtext.getAction("printPreviewAction"));
        fileMenu.add(this.printPreviewItem);
        fileMenu.addSeparator();
        this.recentFilesMenu = new RecentFilesMenu(menuMsg.getString("RecentFiles")){

            protected Action createOpenAction(String fileFullPath) {
                return new OpenFileAction(rtext, fileFullPath);
            }
        };
        fileMenu.add((JMenuItem)this.recentFilesMenu);
        if (rtext.getOS() != OS.MAC_OS_X) {
            this.exitItem = this.createMenuItem(rtext.getAction("exitAction"));
            fileMenu.addSeparator();
            fileMenu.add(this.exitItem);
        }
        return fileMenu;
    }

    private JMenu createHelpMenu(ResourceBundle menuMsg, RText rtext) {
        JMenu menu = this.createMenu(menuMsg, "MenuHelp");
        this.helpItem = this.createMenuItem(rtext.getAction("helpAction"));
        menu.add(this.helpItem);
        this.homePageItem = this.createMenuItem(rtext.getAction("homePageAction"));
        menu.add(this.homePageItem);
        this.updatesItem = this.createMenuItem(rtext.getAction("checkForUpdatesAction"));
        menu.add(this.updatesItem);
        menu.addSeparator();
        this.aboutItem = this.createMenuItem(rtext.getAction("aboutAction"));
        menu.add(this.aboutItem);
        return menu;
    }

    private JMenu createSearchMenu(ResourceBundle menuMsg, int defaultModifier, int shift) {
        RText rtext = (RText)this.getApplication();
        JMenu menu = this.createMenu(menuMsg, "MenuSearch");
        this.findItem = this.createMenuItem(rtext.getAction("findAction"));
        menu.add(this.findItem);
        this.findNextItem = this.createMenuItem(rtext.getAction("findNextAction"));
        menu.add(this.findNextItem);
        this.replaceItem = this.createMenuItem(rtext.getAction("replaceAction"));
        menu.add(this.replaceItem);
        this.replaceNextItem = this.createMenuItem(rtext.getAction("replaceNextAction"));
        menu.add(this.replaceNextItem);
        menu.addSeparator();
        this.findInFilesItem = this.createMenuItem(rtext.getAction("findInFilesAction"));
        menu.add(this.findInFilesItem);
        this.replaceInFilesItem = this.createMenuItem(rtext.getAction("replaceInFilesAction"));
        menu.add(this.replaceInFilesItem);
        menu.addSeparator();
        this.goToItem = this.createMenuItem(rtext.getAction("gotoAction"));
        menu.add(this.goToItem);
        JMenuItem menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.GoToMatchingBracketAction(), menuMsg, "GoToMatchingBracket", "GoToMatchingBracketMnemonic", KeyStroke.getKeyStroke(91, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescGoToMatchingBracket");
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.NextBookmarkAction("RTA.NextBookmarkAction", true), menuMsg, "NextBookmark", "NextBookmarkMnemonic", KeyStroke.getKeyStroke(113, 0));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescNextBookmark");
        menu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.NextBookmarkAction("RTA.NextBookmarkAction", false), menuMsg, "PreviousBookmark", "PreviousBookmarkMnemonic", KeyStroke.getKeyStroke(113, shift));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescPreviousBookmark");
        menu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.ToggleBookmarkAction(), menuMsg, "ToggleBookmark", "ToggleBookmarkMnemonic", KeyStroke.getKeyStroke(113, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescToggleBookmark");
        menu.add(menuItem);
        return menu;
    }

    private JMenu createViewMenu(ResourceBundle menuMsg) {
        RText rtext = (RText)this.getApplication();
        JMenu viewMenu = this.createMenu(menuMsg, "MenuView");
        JMenu toolbarsMenu = new JMenu(menuMsg.getString("Toolbars"));
        Action a = rtext.getAction("toolBarAction");
        this.toolbarItem = new JCheckBoxMenuItem(a);
        this.toolbarItem.setToolTipText(null);
        this.toolbarItem.setSelected(rtext.getToolBarVisible());
        toolbarsMenu.add(this.toolbarItem);
        viewMenu.add(toolbarsMenu);
        JMenu fontSizesMenu = this.createMenu(menuMsg, "MenuFontSizes");
        a = rtext.getAction("decFontSizesAction");
        this.decreaseFontSizesItem = this.createMenuItem(a);
        fontSizesMenu.add(this.decreaseFontSizesItem);
        a = rtext.getAction("incFontSizesAction");
        this.increaseFontSizesItem = this.createMenuItem(a);
        fontSizesMenu.add(this.increaseFontSizesItem);
        viewMenu.add(fontSizesMenu);
        JMenu dwMenu = this.createMenu(menuMsg, "MenuDockedWindows");
        this.registerMenuByName(MENU_DOCKED_WINDOWS, dwMenu);
        viewMenu.add(dwMenu);
        this.statusBarItem = new JCheckBoxMenuItem(rtext.getAction("statusBarAction"));
        this.statusBarItem.setToolTipText(null);
        this.statusBarItem.setSelected(rtext.getStatusBarVisible());
        viewMenu.add(this.statusBarItem);
        this.lineNumbersItem = new JCheckBoxMenuItem(rtext.getAction("lineNumberAction"));
        this.lineNumbersItem.setSelected(rtext.getMainView().getLineNumbersEnabled());
        this.lineNumbersItem.setToolTipText(null);
        viewMenu.add(this.lineNumbersItem);
        viewMenu.addSeparator();
        JMenu focusDwMenu = this.createMenu(menuMsg, "MenuFocusDockableWindowGroup");
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusLeftAction")));
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusRightAction")));
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusUpAction")));
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusDownAction")));
        viewMenu.add(focusDwMenu);
        viewMenu.addSeparator();
        this.nextDocItem = this.createMenuItem(rtext.getAction("nextDocumentAction"));
        viewMenu.add(this.nextDocItem);
        this.prevDocItem = this.createMenuItem(rtext.getAction("prevDocumentAction"));
        viewMenu.add(this.prevDocItem);
        viewMenu.addSeparator();
        this.filePropItem = this.createMenuItem(rtext.getAction("filePropertiesAction"));
        viewMenu.add(this.filePropItem);
        return viewMenu;
    }

    private JMenu createWindowMenu(ResourceBundle menuMsg, ResourceBundle msg) {
        RText rtext = (RText)this.getApplication();
        JMenu windowMenu = this.createMenu(menuMsg, "MenuWindow");
        JMenuItem item = new JMenuItem(menuMsg.getString("TileVertically"));
        UIUtil.setDescription((JComponent)item, (ResourceBundle)msg, (String)"DescTileVertically");
        item.setActionCommand("TileVertically");
        item.addActionListener(rtext);
        windowMenu.add(item);
        item = new JMenuItem(menuMsg.getString("TileHorizontally"));
        UIUtil.setDescription((JComponent)item, (ResourceBundle)msg, (String)"DescTileHorizontally");
        item.setActionCommand("TileHorizontally");
        item.addActionListener(rtext);
        windowMenu.add(item);
        item = new JMenuItem(menuMsg.getString("Cascade"));
        UIUtil.setDescription((JComponent)item, (ResourceBundle)msg, (String)"DescCascade");
        item.setActionCommand("Cascade");
        item.addActionListener(rtext);
        windowMenu.add(item);
        windowMenu.addSeparator();
        windowMenu.getPopupMenu().addPopupMenuListener(this);
        return windowMenu;
    }

    public List<String> getFileHistory() {
        return this.recentFilesMenu.getFileHistory();
    }

    public String getFileHistoryString() {
        StringBuilder retVal = new StringBuilder();
        int historyCount = this.recentFilesMenu.getItemCount();
        for (int i = historyCount - 1; i >= 0; --i) {
            retVal.append(this.recentFilesMenu.getFileFullPath(i)).append("<");
        }
        if (retVal.length() > 0) {
            retVal = new StringBuilder(retVal.substring(0, retVal.length() - 1));
        }
        return retVal.toString();
    }

    public int getMaximumFileHistorySize() {
        return this.recentFilesMenu.getMaximumFileHistorySize();
    }

    protected void initializeUI() {
        RText app = (RText)this.getApplication();
        ResourceBundle msg = app.getResourceBundle();
        ResourceBundle menuMsg = ResourceBundle.getBundle("org.fife.rtext.MenuBar");
        int defaultModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        int shift = 64;
        this.fileMenu = this.createFileMenu(menuMsg);
        this.registerMenuByName(MENU_FILE, this.fileMenu);
        this.add(this.fileMenu);
        JMenu menu = this.createEditMenu(menuMsg, defaultModifier, 64);
        this.registerMenuByName(MENU_EDIT, menu);
        this.add(menu);
        menu = this.createSearchMenu(menuMsg, defaultModifier, 64);
        this.registerMenuByName(MENU_SEARCH, menu);
        this.add(menu);
        this.viewMenu = this.createViewMenu(menuMsg);
        this.registerMenuByName(MENU_VIEW, this.viewMenu);
        this.viewMenu.getPopupMenu().addPopupMenuListener(this);
        this.add(this.viewMenu);
        this.windowMenu = this.createWindowMenu(menuMsg, msg);
        this.add(this.windowMenu);
        menu = this.createHelpMenu(menuMsg, app);
        this.registerMenuByName(MENU_HELP, menu);
        this.add(menu);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("MainView.textAreaAdded")) {
            RTextEditorPane textArea = (RTextEditorPane)((Object)e.getNewValue());
            this.addFileToFileHistory(textArea.getFileFullPath());
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        final RText rtext = (RText)this.getApplication();
        Object source = e.getSource();
        if (source == this.viewMenu.getPopupMenu()) {
            AbstractMainView mainView = rtext.getMainView();
            this.lineNumbersItem.setSelected(mainView.getLineNumbersEnabled());
        } else if (source == this.windowMenu.getPopupMenu()) {
            JPopupMenu popupMenu = this.windowMenu.getPopupMenu();
            int count = popupMenu.getComponentCount() - 4;
            for (int i = 0; i < count; ++i) {
                this.windowMenu.remove(4);
            }
            AbstractMainView abstractMainView = rtext.getMainView();
            if (!(abstractMainView instanceof RTextMDIView)) {
                return;
            }
            final RTextMDIView mdiView = (RTextMDIView)abstractMainView;
            JMenu currentMenu = this.windowMenu;
            count = mdiView.getNumDocuments();
            int selectedIndex = mdiView.getSelectedIndex();
            for (int i = 0; i < count; ++i) {
                if ((i + 1) % 15 == 0) {
                    currentMenu.add(new JMenu("More..."));
                    currentMenu = (JMenu)currentMenu.getItem(currentMenu.getItemCount() - 1);
                }
                String text = i + 1 + " " + UIUtil.getDisplayPathForFile((Component)((Object)this), (String)mdiView.getRTextEditorPaneAt(i).getFileFullPath());
                final int index = i;
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        mdiView.setSelectedIndex(index);
                    }
                });
                menuItem.setText(text);
                menuItem.setSelected(i == selectedIndex);
                currentMenu.add(menuItem);
            }
        } else if (source == this.savedMacroMenu.getPopupMenu()) {
            File[] files;
            this.savedMacroMenu.removeAll();
            for (File file : files = RTextUtilities.getSavedMacroFiles()) {
                String name = RTextUtilities.getMacroName(file);
                final File f = file;
                AbstractAction a = new AbstractAction(name){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        rtext.getMainView().loadMacro(f);
                    }
                };
                this.savedMacroMenu.add(new JMenuItem(a));
            }
            this.savedMacroMenu.applyComponentOrientation(this.getComponentOrientation());
        }
    }

    public void setWindowMenuVisible(boolean visible) {
        if (visible) {
            this.add(this.windowMenu, 4);
        } else {
            this.remove(this.windowMenu);
        }
        this.validate();
    }

    protected void updateIconsForNativeMenuBar(IconGroup iconGroup) {
        this.newItem.setIcon(iconGroup.getNativeIcon("new"));
        this.openItem.setIcon(iconGroup.getNativeIcon("open"));
        this.openInNewWindowItem.setIcon(iconGroup.getNativeIcon("openinnewwindow"));
        this.saveItem.setIcon(iconGroup.getNativeIcon("save"));
        this.saveAsItem.setIcon(iconGroup.getNativeIcon("saveas"));
        this.saveAllItem.setIcon(iconGroup.getNativeIcon("saveall"));
        this.closeItem.setIcon(iconGroup.getNativeIcon("close"));
        this.closeAllItem.setIcon(iconGroup.getNativeIcon("closeall"));
        this.printItem.setIcon(iconGroup.getNativeIcon("prin"));
        this.printPreviewItem.setIcon(iconGroup.getNativeIcon("printpreview"));
        this.undoItem.setIcon(iconGroup.getNativeIcon("undo"));
        this.redoItem.setIcon(iconGroup.getNativeIcon("redo"));
        this.cutItem.setIcon(iconGroup.getNativeIcon("cut"));
        this.copyItem.setIcon(iconGroup.getNativeIcon("copy"));
        this.pasteItem.setIcon(iconGroup.getNativeIcon("paste"));
        this.deleteItem.setIcon(iconGroup.getNativeIcon("delete"));
        this.findItem.setIcon(iconGroup.getNativeIcon("find"));
        this.findNextItem.setIcon(iconGroup.getNativeIcon("findnext"));
        this.replaceItem.setIcon(iconGroup.getNativeIcon("replace"));
        this.replaceNextItem.setIcon(iconGroup.getNativeIcon("replacenext"));
        this.goToItem.setIcon(iconGroup.getNativeIcon("goto"));
        this.selectAllItem.setIcon(iconGroup.getNativeIcon("selectall"));
        if (this.optionsItem != null) {
            this.optionsItem.setIcon(iconGroup.getNativeIcon("options"));
        }
        this.helpItem.setIcon(iconGroup.getNativeIcon("help"));
        this.aboutItem.setIcon(iconGroup.getNativeIcon("about"));
    }

    public void updateUI() {
        super.updateUI();
        RText rtext = (RText)this.getApplication();
        if (rtext != null && rtext.getMainViewStyle() != 2 && this.windowMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.windowMenu);
        }
    }
}

