/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.fife.rtext.RTextActionInfo;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.SpellingSupport;
import org.fife.rtext.SyntaxFilters;
import org.fife.ui.OS;
import org.fife.ui.app.prefs.AppPrefs;
import org.fife.ui.app.prefs.TypeLoader;
import org.fife.ui.app.prefs.loaders.EnumLoader;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.FoldIndicatorStyle;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.util.MacOSUtil;

public class RTextPrefs
extends AppPrefs
implements RTextActionInfo {
    private static final String DEFAULT_APP_THEME = "Flat Dark";
    public static final int DEFAULT_MAX_SPELLING_ERRORS = 30;
    public static final Color DEFAULT_SPELLING_ERROR_COLOR = new Color(255, 128, 64);
    public boolean lineNumbersVisible;
    public int tabSize;
    public boolean emulateTabsWithSpaces;
    public int textMode;
    public int tabPlacement;
    public Font printFont;
    public Color backgroundColor;
    public float imageAlpha;
    public boolean wordWrap;
    public Color caretColor;
    public Color selectionColor;
    public Color selectedTextColor;
    public boolean useSelectedTextColor;
    public SyntaxScheme colorScheme;
    public String syntaxFiltersString;
    public int maxFileHistorySize;
    public String fileHistoryString;
    public boolean currentLineHighlightEnabled;
    public Color currentLineHighlightColor;
    public int mainView;
    public boolean overrideEditorStyles;
    public boolean bracketMatchingEnabled;
    public boolean matchBothBrackets;
    public Color matchedBracketBGColor;
    public Color matchedBracketBorderColor;
    public boolean marginLineEnabled;
    public int marginLinePosition;
    public Color marginLineColor;
    public boolean highlightSecondaryLanguages;
    public Color[] secondaryLanguageColors;
    public boolean visibleWhitespace;
    public boolean showEOLMarkers;
    public boolean showTabLines;
    public Color tabLinesColor;
    public boolean rememberWhitespaceLines;
    public boolean autoInsertClosingCurlys;
    public boolean aaEnabled;
    public boolean fractionalMetricsEnabled;
    public Color markAllHighlightColor;
    public boolean markOccurrences;
    public Color markOccurrencesColor;
    public boolean roundedSelectionEdges;
    public String workingDirectory;
    public int[] carets;
    public int caretBlinkRate;
    public int[] dividerLocations;
    public boolean[] dividerVisible;
    public String defaultLineTerminator;
    public String defaultEncoding;
    public boolean guessFileContentType;
    public boolean doFileSizeCheck;
    public float maxFileSize;
    public int maxFileSizeForCodeFolding;
    public boolean ignoreBackupExtensions;
    public Font textAreaFont;
    public boolean textAreaUnderline;
    public Color textAreaForeground;
    public ComponentOrientation textAreaOrientation;
    public FoldIndicatorStyle foldIndicatorStyle;
    public Color foldForeground;
    public Color armedFoldForeground;
    public Color foldBackground;
    public Color armedFoldBackground;
    public boolean showHostName;
    public boolean bomInUtf8;
    public Font lineNumberFont;
    public Color lineNumberColor;
    public Color gutterBorderColor;
    public boolean spellCheckingEnabled;
    public Color spellCheckingColor;
    public String spellingDictionary;
    public File userDictionary;
    public int maxSpellingErrors;
    public boolean viewSpellingList;
    public boolean searchWindowOpacityEnabled;
    public float searchWindowOpacity;
    public int searchWindowOpacityRule;
    public boolean dropShadowsInEditor;
    public String codeFoldingEnabledFor;
    public boolean useSearchDialogs;

    public RTextPrefs() {
        this.setDefaults();
        this.addAppSpecificTypeLoaders();
    }

    private void addAppSpecificTypeLoaders() {
        this.addTypeLoader(FoldIndicatorStyle.class, (TypeLoader)new EnumLoader((Enum)FoldIndicatorStyle.MODERN));
        this.addTypeLoader(SyntaxScheme.class, new SyntaxSchemeTypeLoader());
    }

    private static boolean getDefaultDropShadowsInEditorValue() {
        return OS.get() == OS.WINDOWS;
    }

    public void setDefaults() {
        int i;
        Theme theme;
        try {
            theme = Theme.load((InputStream)this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/dark.xml"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        this.location = new Point(0, 0);
        this.size = new Dimension(650, 500);
        this.appTheme = DEFAULT_APP_THEME;
        this.toolbarVisible = true;
        this.statusBarVisible = true;
        this.lineNumbersVisible = true;
        this.tabSize = RTextArea.getDefaultTabSize();
        this.emulateTabsWithSpaces = false;
        this.textMode = 0;
        this.tabPlacement = 1;
        this.printFont = null;
        this.backgroundColor = theme.bgColor;
        this.imageAlpha = 0.3f;
        this.wordWrap = false;
        this.caretColor = theme.caretColor;
        this.selectionColor = theme.selectionBG;
        this.selectedTextColor = theme.selectionFG;
        this.useSelectedTextColor = theme.useSelectionFG;
        this.colorScheme = theme.scheme;
        SyntaxFilters syntaxFilters = new SyntaxFilters();
        syntaxFilters.restoreDefaultFileFilters();
        this.syntaxFiltersString = syntaxFilters.toString();
        this.maxFileHistorySize = 20;
        this.fileHistoryString = null;
        this.currentLineHighlightEnabled = true;
        this.currentLineHighlightColor = theme.currentLineHighlight;
        this.mainView = 0;
        this.overrideEditorStyles = false;
        this.language = "en";
        this.bracketMatchingEnabled = true;
        this.matchBothBrackets = true;
        this.matchedBracketBGColor = theme.matchedBracketBG;
        this.matchedBracketBorderColor = theme.matchedBracketFG;
        this.marginLineEnabled = true;
        this.marginLinePosition = RTextArea.getDefaultMarginLinePosition();
        this.marginLineColor = theme.marginLineColor;
        this.highlightSecondaryLanguages = true;
        this.secondaryLanguageColors = new Color[3];
        this.secondaryLanguageColors[0] = theme.secondaryLanguages[0];
        this.secondaryLanguageColors[1] = theme.secondaryLanguages[1];
        this.secondaryLanguageColors[2] = theme.secondaryLanguages[2];
        this.visibleWhitespace = false;
        this.showEOLMarkers = false;
        this.showTabLines = false;
        this.tabLinesColor = theme.marginLineColor;
        this.rememberWhitespaceLines = true;
        this.autoInsertClosingCurlys = false;
        this.aaEnabled = File.separatorChar == '\\' || MacOSUtil.isMacOs();
        this.fractionalMetricsEnabled = false;
        this.markAllHighlightColor = theme.markAllHighlightColor;
        this.markOccurrences = true;
        this.markOccurrencesColor = theme.markOccurrencesColor;
        this.roundedSelectionEdges = false;
        this.workingDirectory = System.getProperty("user.dir");
        this.carets = new int[2];
        this.carets[0] = CaretStyle.THICK_VERTICAL_LINE_STYLE.ordinal();
        this.carets[1] = CaretStyle.BLOCK_STYLE.ordinal();
        this.caretBlinkRate = 500;
        this.dividerLocations = new int[4];
        for (i = 0; i < 4; ++i) {
            this.dividerLocations[i] = -1;
        }
        this.dividerVisible = new boolean[4];
        for (i = 0; i < 4; ++i) {
            this.dividerVisible[i] = false;
        }
        this.defaultLineTerminator = null;
        this.defaultEncoding = null;
        this.guessFileContentType = true;
        this.doFileSizeCheck = true;
        this.maxFileSize = 10.0f;
        this.maxFileSizeForCodeFolding = 10;
        this.ignoreBackupExtensions = true;
        this.textAreaFont = RTextArea.getDefaultFont();
        this.textAreaUnderline = false;
        this.textAreaForeground = RTextArea.getDefaultForeground();
        this.textAreaOrientation = ComponentOrientation.LEFT_TO_RIGHT;
        this.foldIndicatorStyle = FoldIndicatorStyle.MODERN;
        this.foldForeground = theme.foldIndicatorFG;
        this.armedFoldForeground = theme.foldIndicatorArmedFG;
        this.foldBackground = theme.foldBG;
        this.armedFoldBackground = theme.armedFoldBG;
        this.showHostName = false;
        this.bomInUtf8 = false;
        this.lineNumberFont = new Font(this.textAreaFont.getName(), 0, 12);
        this.lineNumberColor = theme.lineNumberColor;
        this.gutterBorderColor = theme.gutterBorderColor;
        this.spellCheckingEnabled = File.separatorChar == '\\';
        this.spellCheckingColor = DEFAULT_SPELLING_ERROR_COLOR;
        this.spellingDictionary = SpellingSupport.DICTIONARIES[1];
        this.userDictionary = new File(RTextUtilities.getPreferencesDirectory(), "userDictionary.txt");
        this.maxSpellingErrors = 30;
        this.viewSpellingList = false;
        this.searchWindowOpacityEnabled = false;
        this.searchWindowOpacity = 0.6f;
        this.searchWindowOpacityRule = 2;
        this.dropShadowsInEditor = RTextPrefs.getDefaultDropShadowsInEditorValue();
        this.codeFoldingEnabledFor = "";
        this.useSearchDialogs = true;
    }

    public String toString() {
        return "[Class: RTextPrefs]";
    }

    private static class SyntaxSchemeTypeLoader
    implements TypeLoader<SyntaxScheme> {
        private SyntaxSchemeTypeLoader() {
        }

        public SyntaxScheme load(String name, String value, Properties props) {
            return SyntaxScheme.loadFromString((String)value);
        }

        public String save(String name, Object value, Properties props) {
            return value != null ? ((SyntaxScheme)value).toCommaSeparatedString() : null;
        }
    }
}

