/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.fife.jgoodies.looks.common.ShadowPopupBorder;
import org.fife.jgoodies.looks.common.ShadowPopupFactory;
import org.fife.rsta.ui.DecorativeIconPanel;
import org.fife.rtext.RText;
import org.fife.rtext.StoreKeeper;
import org.fife.ui.OS;
import org.fife.ui.UIUtil;
import org.fife.ui.WebLookAndFeelUtils;
import org.fife.ui.app.AppTheme;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;
import org.fife.ui.rsyntaxtextarea.templates.StaticCodeTemplate;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.Utilities;
import org.fife.ui.rtextfilechooser.filters.ExtensionFileFilter;
import org.fife.ui.search.FindInFilesDialog;
import org.fife.util.DarculaUtil;
import org.fife.util.DynamicIntArray;
import org.fife.util.TranslucencyUtil;

public final class RTextUtilities {
    private static final String MACRO_EXTENSION = ".macro";
    private static final String FILE_FILTERS_FILE = "ExtraFileChooserFilters.xml";
    private static String currentAppTheme;
    private static boolean dropShadowsEnabledInEditor;

    private RTextUtilities() {
    }

    static void addDefaultCodeTemplates() {
        CodeTemplateManager ctm = RSyntaxTextArea.getCodeTemplateManager();
        StaticCodeTemplate t = new StaticCodeTemplate("dob", "do {\n\t", "\n} while ();");
        ctm.addTemplate((CodeTemplate)t);
        t = new StaticCodeTemplate("forb", "for (", ") {\n\t\n}");
        ctm.addTemplate((CodeTemplate)t);
        t = new StaticCodeTemplate("ifb", "if (", ") {\n\t\n}");
        ctm.addTemplate((CodeTemplate)t);
        t = new StaticCodeTemplate("pb", "public ", "");
        ctm.addTemplate((CodeTemplate)t);
        t = new StaticCodeTemplate("pkgb", "package ", "");
        ctm.addTemplate((CodeTemplate)t);
        t = new StaticCodeTemplate("stb", "static ", "");
        ctm.addTemplate((CodeTemplate)t);
        t = new StaticCodeTemplate("whileb", "while (", ") {\n\t\n}");
        ctm.addTemplate((CodeTemplate)t);
    }

    private static void addFilter(RTextFileChooser chooser, ResourceBundle msg, String key, String ... extensions) {
        ExtensionFileFilter filter = new ExtensionFileFilter(msg.getString(key), extensions);
        chooser.addChoosableFileFilter((FileFilter)filter);
    }

    public static void centerSelectionVertically(RSyntaxTextArea textArea) {
        Rectangle2D r2d;
        Rectangle visible = textArea.getVisibleRect();
        try {
            r2d = textArea.modelToView2D(textArea.getCaretPosition());
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return;
        }
        Rectangle r = new Rectangle((int)r2d.getX(), (int)r2d.getY(), (int)r2d.getWidth(), (int)r2d.getHeight());
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = textArea.getBounds();
        Insets i = textArea.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        textArea.scrollRectToVisible(visible);
    }

    public static void configureFindInFilesDialog(FindInFilesDialog fnfd) {
        fnfd.addInFilesComboBoxFilter("*.asm");
        fnfd.addInFilesComboBoxFilter("*.bat *.cmd");
        fnfd.addInFilesComboBoxFilter("*.c *.cpp *.cxx *.h");
        fnfd.addInFilesComboBoxFilter("*.cs");
        fnfd.addInFilesComboBoxFilter("*.htm *.html");
        fnfd.addInFilesComboBoxFilter("*.java");
        fnfd.addInFilesComboBoxFilter("*.js");
        fnfd.addInFilesComboBoxFilter("*.pl *.perl *.pm");
        fnfd.addInFilesComboBoxFilter("*.py");
        fnfd.addInFilesComboBoxFilter("*.sh *.bsh *.csh *.ksh");
        fnfd.addInFilesComboBoxFilter("*.txt");
    }

    public static JPanel createAssistancePanel(JComponent comp, DecorativeIconPanel iconPanel) {
        if (iconPanel == null) {
            iconPanel = new DecorativeIconPanel();
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)iconPanel, "Before");
        panel.add(comp);
        return panel;
    }

    public static JPanel createAssistancePanel(JComponent comp, int iconWidth) {
        DecorativeIconPanel iconPanel = new DecorativeIconPanel(iconWidth);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)iconPanel, "Before");
        panel.add(comp);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RTextFileChooser createFileChooser(RText rtext) {
        RTextFileChooser chooser;
        rtext.setCursor(Cursor.getPredefinedCursor(3));
        try {
            chooser = new RTextFileChooser();
            ResourceBundle msg = ResourceBundle.getBundle("org.fife.rtext.FileFilters");
            RTextUtilities.addFilter(chooser, msg, "ActionScript", "as", "asc");
            RTextUtilities.addFilter(chooser, msg, "Assembler6502", "s");
            RTextUtilities.addFilter(chooser, msg, "AssemblerX86", "asm");
            RTextUtilities.addFilter(chooser, msg, "BBCode", "bbc");
            RTextUtilities.addFilter(chooser, msg, "CPlusPlus", "c", "cpp", "cxx", "h");
            RTextUtilities.addFilter(chooser, msg, "Clojure", "clj");
            RTextUtilities.addFilter(chooser, msg, "CSharp", "cs");
            RTextUtilities.addFilter(chooser, msg, "CSS", "css");
            RTextUtilities.addFilter(chooser, msg, "D", "d");
            RTextUtilities.addFilter(chooser, msg, "Dart", "dart");
            RTextUtilities.addFilter(chooser, msg, "Delphi", "pas");
            RTextUtilities.addFilter(chooser, msg, "DTD", "dtd");
            RTextUtilities.addFilter(chooser, msg, "Flex", "mxml");
            RTextUtilities.addFilter(chooser, msg, "Fortran", "f", "for", "fort", "f77", "f90");
            RTextUtilities.addFilter(chooser, msg, "Go", "go");
            RTextUtilities.addFilter(chooser, msg, "Groovy", "groovy", "grv");
            RTextUtilities.addFilter(chooser, msg, "HTML", "htm", "html");
            RTextUtilities.addFilter(chooser, msg, "INI", "ini");
            RTextUtilities.addFilter(chooser, msg, "Java", "java");
            RTextUtilities.addFilter(chooser, msg, "JavaScript", "js");
            RTextUtilities.addFilter(chooser, msg, "JSON", "json");
            RTextUtilities.addFilter(chooser, msg, "JSP", "jsp");
            RTextUtilities.addFilter(chooser, msg, "Kotlin", "kt", "ktm", "kts");
            RTextUtilities.addFilter(chooser, msg, "LaTeX", "tex", "ltx", "latex");
            RTextUtilities.addFilter(chooser, msg, "Lisp", "cl", "clisp", "el", "l", "lisp", "lsp", "ml");
            RTextUtilities.addFilter(chooser, msg, "Lua", "lua");
            RTextUtilities.addFilter(chooser, msg, "Makefile", "Makefile", "makefile");
            RTextUtilities.addFilter(chooser, msg, "Markdown", "md");
            RTextUtilities.addFilter(chooser, msg, "Nsis", "nsi");
            RTextUtilities.addFilter(chooser, msg, "Perl", "pl", "perl", "pm");
            RTextUtilities.addFilter(chooser, msg, "PHP", "php");
            RTextUtilities.addFilter(chooser, msg, "PropertiesFiles", "properties");
            RTextUtilities.addFilter(chooser, msg, "Protobuf", "proto");
            RTextUtilities.addFilter(chooser, msg, "Python", "py");
            RTextUtilities.addFilter(chooser, msg, "Ruby", "rb");
            RTextUtilities.addFilter(chooser, msg, "SAS", "sas");
            RTextUtilities.addFilter(chooser, msg, "Scala", "scala");
            RTextUtilities.addFilter(chooser, msg, "SQL", "sql");
            RTextUtilities.addFilter(chooser, msg, "PlainText", "txt");
            RTextUtilities.addFilter(chooser, msg, "Tcl", "tcl");
            RTextUtilities.addFilter(chooser, msg, "TypeScript", "ts");
            RTextUtilities.addFilter(chooser, msg, "UnixShell", "sh", "bsh", "csh", "ksh");
            RTextUtilities.addFilter(chooser, msg, "VisualBasic", "vb");
            RTextUtilities.addFilter(chooser, msg, "WindowsBatch", "bat", "cmd");
            RTextUtilities.addFilter(chooser, msg, "XML", "xml", "xsl", "xsd", "xslt", "wsdl", "jnlp", "macro", "manifest");
            RTextUtilities.addFilter(chooser, msg, "Yaml", "yml", "yaml");
            File file = new File(rtext.getInstallLocation(), FILE_FILTERS_FILE);
            try {
                Utilities.addFileFilters((File)file, (RTextFileChooser)chooser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(msg.getString("AllSupported"), ExtensionFileFilter.CaseCheck.SYSTEM_CASE_CHECK, false, new String[]{"as", "asc", "s", "asm", "bbc", "c", "cpp", "cxx", "h", "clj", "cs", "css", "csv", "d", "dart", "pas", "Dockerfile", "dockerfile", "dtd", "f", "for", "fort", "f77", "f90", "go", "groovy", "grv", "hbs", "hosts", "htm", "html", "ini", "java", "js", "json", "jsp", "kt", "kts", "tex", "ltx", "latex", "cl", "clisp", "el", "l", "lisp", "lsp", "ml", "lua", "Makefile", "makefile", "md", "mxml", "nsi", "perl", "pl", "pm", "php", "properties", "py", "rb", "sas", "scala", "sql", "tcl", "txt", "sh", "bsh", "csh", "ksh", "vb", "bat", "cmd", "xml", "xsl", "xsd", "xslt", "wsdl", "svg", "tmx", "tsx", "pom", "manifest", "yml", "yaml"}));
            chooser.setFileFilter(null);
            chooser.setCurrentDirectory(rtext.getWorkingDirectory());
            File favoritesFile = RTextUtilities.getFileChooserFavoritesFile();
            if (favoritesFile.isFile()) {
                try {
                    chooser.loadFavorites(favoritesFile);
                }
                catch (IOException ioe) {
                    rtext.displayException(ioe);
                }
            }
        }
        finally {
            rtext.setCursor(Cursor.getPredefinedCursor(0));
        }
        return chooser;
    }

    private static String createRegexForFileFilter(String filter) {
        StringBuilder sb = new StringBuilder("^");
        block6: for (int i = 0; i < filter.length(); ++i) {
            char ch = filter.charAt(i);
            switch (ch) {
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.append('$').toString();
    }

    static boolean enableTemplates(RText rtext, boolean enabled) {
        boolean old = RSyntaxTextArea.getTemplatesEnabled();
        if (old != enabled) {
            RSyntaxTextArea.setTemplatesEnabled((boolean)enabled);
            if (enabled) {
                File f = new File(RTextUtilities.getPreferencesDirectory(), "templates");
                if (!f.isDirectory() && !f.mkdirs()) {
                    return false;
                }
                return RSyntaxTextArea.setTemplateDirectory((String)f.getAbsolutePath());
            }
        }
        return true;
    }

    public static boolean getDropShadowsEnabledInEditor() {
        return dropShadowsEnabledInEditor;
    }

    private static File getFileChooserFavoritesFile() {
        return new File(RTextUtilities.getPreferencesDirectory(), "fileChooser.favorites");
    }

    static String getAppThemeToSave(RText rtext) {
        String appoTheme = currentAppTheme;
        if (appoTheme == null) {
            appoTheme = rtext.getTheme().getName();
        }
        return appoTheme;
    }

    private static File getMacroDirectory() {
        File f = new File(RTextUtilities.getPreferencesDirectory(), "macros");
        if (!f.isDirectory() && !f.mkdirs()) {
            return null;
        }
        return f;
    }

    static String getMacroName(File macroFile) {
        String name = null;
        if (macroFile != null && (name = macroFile.getName()).endsWith(MACRO_EXTENSION)) {
            name = name.substring(0, name.length() - MACRO_EXTENSION.length());
        }
        return name;
    }

    public static File getPreferencesDirectory() {
        return new File(System.getProperty("user.home"), ".rtext");
    }

    public static Pattern getPatternForFileFilter(String fileFilter, boolean showErrorDialog) {
        String pattern = RTextUtilities.createRegexForFileFilter(fileFilter);
        int flags = OS.get().isCaseSensitive() ? 0 : 66;
        try {
            return Pattern.compile(pattern, flags);
        }
        catch (PatternSyntaxException pse) {
            if (showErrorDialog) {
                String text = pse.getMessage();
                if (text == null) {
                    text = pse.toString();
                }
                JOptionPane.showMessageDialog(null, "Error in the regular expression '" + pattern + "' formed from parameter '" + fileFilter + "':\n" + text + "\nPlease use only valid filename characters or wildcards (* or ?).\nIf you have, please report this error at: https://github.com/bobbylight/RText", "Error", 0);
            }
            return null;
        }
    }

    static File[] getSavedMacroFiles() {
        File[] allFiles;
        File macroDir = RTextUtilities.getMacroDirectory();
        if (macroDir != null && macroDir.isDirectory() && (allFiles = macroDir.listFiles()) != null && allFiles.length > 0) {
            int count = allFiles.length;
            DynamicIntArray dia = new DynamicIntArray();
            for (int i = 0; i < count; ++i) {
                if (!allFiles[i].getName().endsWith(MACRO_EXTENSION)) continue;
                dia.add(i);
            }
            count = dia.getSize();
            File[] macroFiles = new File[count];
            for (int i = 0; i < count; ++i) {
                macroFiles[i] = allFiles[dia.get(i)];
            }
            return macroFiles;
        }
        return new File[0];
    }

    public static boolean isDarkLookAndFeel() {
        String laf = UIManager.getLookAndFeel().getClass().getName();
        return laf != null && (laf.contains("Darcula") || laf.contains("FlatDark"));
    }

    public static String join(String[] array) {
        return RTextUtilities.join(array, ", ");
    }

    public static String join(String[] array, String connector) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(connector).append(array[i]);
        }
        return sb.toString();
    }

    public static void openAllFilesIn(RText rtext, File directory) {
        File[] files;
        if (directory != null && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    RTextUtilities.openAllFilesIn(rtext, file);
                    continue;
                }
                rtext.openFile(file);
            }
        }
    }

    static void saveFileChooserFavorites(RText rtext) {
        RTextFileChooser chooser = rtext.getFileChooser();
        try {
            chooser.saveFavorites(RTextUtilities.getFileChooserFavoritesFile());
        }
        catch (IOException ioe) {
            rtext.displayException(ioe);
        }
    }

    public static void setDropShadowsEnabledInEditor(boolean enabled) {
        if (enabled != dropShadowsEnabledInEditor) {
            dropShadowsEnabledInEditor = enabled;
            if (dropShadowsEnabledInEditor) {
                TranslucencyUtil util = TranslucencyUtil.get();
                if (util != null && util.isTranslucencySupported(true)) {
                    PopupWindowDecorator.set((PopupWindowDecorator)new PopupWindowDecorator(){

                        public void decorate(JWindow window) {
                            Container cp = window.getContentPane();
                            if (cp instanceof JComponent) {
                                TranslucencyUtil util = TranslucencyUtil.get();
                                util.setOpaque((Window)window, false);
                                ((JComponent)cp).setBorder(BorderFactory.createCompoundBorder((Border)ShadowPopupBorder.getInstance(), ((JComponent)cp).getBorder()));
                            }
                        }
                    });
                }
            } else {
                PopupWindowDecorator.set(null);
            }
        }
    }

    public static void setThemeForAllOpenAppInstances(RText rtext, AppTheme theme) {
        String current = UIManager.getLookAndFeel().getClass().getName();
        String lnfClassName = theme.getLookAndFeel();
        currentAppTheme = theme.getName();
        if (lnfClassName != null && !current.equals(lnfClassName)) {
            try {
                if (WebLookAndFeelUtils.isWebLookAndFeel((String)lnfClassName)) {
                    ShadowPopupFactory.uninstall();
                    WebLookAndFeelUtils.installWebLookAndFeelProperties();
                } else {
                    ShadowPopupFactory.install();
                }
                LookAndFeel lnf = null;
                if (!UIManager.getSystemLookAndFeelClassName().equals(lnfClassName)) {
                    Class<?> c = RTextUtilities.class.getClassLoader().loadClass(lnfClassName);
                    lnf = (LookAndFeel)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                boolean curDarcula = DarculaUtil.isDarculaInstalled();
                boolean nextDarcula = DarculaUtil.isDarculaLookAndFeel(lnf);
                if (curDarcula || nextDarcula) {
                    String message = rtext.getString("Info.LookAndFeel.LoadOnNextRestart", new Object[0]);
                    String title = rtext.getString("InfoDialogHeader", new Object[0]);
                    JOptionPane.showMessageDialog((Component)((Object)rtext), message, title, 1);
                    return;
                }
                if (lnf != null) {
                    UIManager.setLookAndFeel(lnf);
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                UIUtil.installOsSpecificLafTweaks();
            }
            catch (Exception e) {
                rtext.displayException(e);
            }
        }
        StoreKeeper.updateAppThemes(theme);
    }

    static IconGroup toRstaIconGroup(final org.fife.ui.app.icons.IconGroup iconGroup) {
        return new IconGroup(iconGroup.getName(), ""){

            public Icon getIconImpl(String iconFullPath) {
                iconFullPath = iconFullPath.substring(0, iconFullPath.lastIndexOf(46));
                return iconGroup.getIcon(iconFullPath);
            }
        };
    }
}

