/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.rtext.RText;
import org.fife.rtext.RecentFileListCellRenderer;
import org.fife.ui.EscapableDialog;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class RecentFileDialog
extends EscapableDialog {
    private RText rtext;
    private List<FileLocation> files;
    private JList<FileLocation> list;
    private DefaultListModel<FileLocation> model;
    private JTextField filterField;
    private JButton okButton;
    private static final int MAX_WIDTH = 800;

    public RecentFileDialog(RText parent) {
        super((Window)((Object)parent), parent.getString("Dialog.RecentFiles.Title", new Object[0]), true);
        this.rtext = parent;
        this.files = this.rtext.getRecentFiles();
        this.createUI();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)this.rtext));
        this.setDefaultCloseOperation(2);
    }

    private void createUI() {
        Listener listener = new Listener();
        ResizableFrameContentPane cp = new ResizableFrameContentPane((LayoutManager)new BorderLayout());
        cp.setBorder(UIUtil.getEmpty5Border());
        this.setContentPane((Container)cp);
        this.filterField = new JTextField();
        this.filterField.getDocument().addDocumentListener(listener);
        this.filterField.addKeyListener(listener);
        cp.add((Component)this.filterField, "North");
        this.okButton = new JButton(this.rtext.getString("OKButtonLabel", new Object[0]));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(listener);
        JButton cancelButton = new JButton(this.rtext.getString("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(listener);
        Container buttons = UIUtil.createButtonFooter((JButton)this.okButton, (JButton)cancelButton);
        cp.add((Component)buttons, "South");
        this.model = new DefaultListModel();
        this.list = new JList<FileLocation>(this.model);
        this.setFilter(null);
        this.list.addMouseListener(listener);
        this.list.setCellRenderer(new RecentFileListCellRenderer());
        this.list.setSelectionModel((ListSelectionModel)new RListSelectionModel());
        RScrollPane sp = new RScrollPane(this.list);
        cp.add((Component)sp);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size != null) {
            size.width = Math.min(800, size.width);
        }
        return size;
    }

    private static boolean matches(FileLocation loc, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        String fileName = loc.getFileName();
        return pattern.matcher(fileName).find();
    }

    private void openSelectedFile() {
        FileLocation loc = this.list.getSelectedValue();
        if (loc != null) {
            if (loc.isLocalAndExists()) {
                this.rtext.openFile(new File(loc.getFileFullPath()));
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.list);
            }
            this.escapePressed();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(this.list);
        }
    }

    private void selectNextVisibleRow() {
        if (this.model.size() > 0) {
            int index = this.list.getSelectedIndex();
            index = (index + 1) % this.model.size();
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        }
    }

    private void selectPreviousVisibleRow() {
        if (this.model.size() > 0) {
            int index = this.list.getSelectedIndex();
            if (--index < 0) {
                index = this.model.size() - 1;
            }
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        }
    }

    private void setFilter(String filter) {
        boolean modelNotEmpty;
        this.model.clear();
        Pattern pattern = filter == null || filter.isEmpty() ? null : RSyntaxUtilities.wildcardToPattern((String)("^" + filter), (boolean)false, (boolean)false);
        for (FileLocation loc : this.files) {
            if (!RecentFileDialog.matches(loc, pattern)) continue;
            this.model.addElement(loc);
        }
        boolean bl = modelNotEmpty = this.model.size() > 0;
        if (modelNotEmpty) {
            this.list.setSelectedIndex(0);
            this.list.ensureIndexIsVisible(0);
        }
        this.okButton.setEnabled(modelNotEmpty);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.model.size() > 0) {
                this.list.setSelectedIndex(0);
            }
            super.setVisible(true);
            this.filterField.requestFocusInWindow();
        } else {
            super.setVisible(false);
        }
    }

    private final class Listener
    extends MouseAdapter
    implements ActionListener,
    DocumentListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if ("OK".equals(command)) {
                RecentFileDialog.this.openSelectedFile();
            } else if ("Cancel".equals(command)) {
                RecentFileDialog.this.escapePressed();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleDocumentEvent();
        }

        private void handleDocumentEvent() {
            RecentFileDialog.this.setFilter(RecentFileDialog.this.filterField.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleDocumentEvent();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 40: {
                    RecentFileDialog.this.selectNextVisibleRow();
                    break;
                }
                case 38: {
                    RecentFileDialog.this.selectPreviousVisibleRow();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                RecentFileDialog.this.openSelectedFile();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleDocumentEvent();
        }
    }
}

