/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.FileLocation;

class RecentFileListCellRenderer
extends DefaultListCellRenderer {
    private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();

    RecentFileListCellRenderer() {
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        FileLocation loc = (FileLocation)value;
        RecentFileListCellRenderer.setText(this, loc, selected);
        if (loc.isLocalAndExists()) {
            File file = new File(loc.getFileFullPath());
            this.setIcon(FILE_SYSTEM_VIEW.getSystemIcon(file));
        } else {
            this.setIcon(UIManager.getIcon("FileView.fileIcon"));
        }
        return this;
    }

    static void setText(DefaultListCellRenderer renderer, FileLocation loc, boolean selected) {
        String fileName = loc.getFileName();
        String fullPath = loc.getFileFullPath();
        String text = "<html>" + fileName + "<br>";
        if (!selected) {
            Color fg = renderer.getForeground();
            String color = UIUtil.isLightForeground((Color)fg) ? "#c0c0c0" : "#808080";
            text = text + "<font color=\"" + color + "\">";
        }
        text = text + fullPath;
        if (!selected) {
            text = text + "</font>";
        }
        renderer.setText(text);
    }
}

