/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.RComboBoxModel;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.EscapableDialog;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

public class RemoteFileChooser
extends EscapableDialog
implements ActionListener,
DocumentListener,
FocusListener {
    public static final int OPEN_MODE = 0;
    public static final int SAVE_MODE = 1;
    private RText owner;
    private JPanel formPanel;
    private JLabel protoLabel;
    private JComboBox<String> protocolCombo;
    private JLabel hostLabel;
    private JComboBox<String> hostCombo;
    private JLabel fileNameLabel;
    private JComboBox<String> fileCombo;
    private JLabel userLabel;
    private JComboBox<String> userCombo;
    private JLabel passLabel;
    private JPasswordField passField;
    private JLabel encodingLabel;
    private JComboBox<String> encodingCombo;
    private JLabel portLabel;
    private JComboBox<String> portCombo;
    private JButton okButton;
    private JToggleButton advancedButton;
    private String savedUser;
    private char[] savedPass;
    private String openTitle;
    private String saveTitle;
    private int mode;
    private static final String MSG = "org.fife.rtext.RemoteFileChooser";
    private static final String DEFAULT_FTP_PORT = "21";
    private static final String DEFAULT_HTTP_PORT = "80";

    public RemoteFileChooser(RText owner) {
        super((Window)((Object)owner));
        this.owner = owner;
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        this.openTitle = msg.getString("OpenTitle");
        this.saveTitle = msg.getString("SaveTitle");
        ResizableFrameContentPane cp = new ResizableFrameContentPane((LayoutManager)new BorderLayout());
        cp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane((Container)cp);
        this.formPanel = new JPanel(new SpringLayout());
        this.protocolCombo = new JComboBox<String>(new String[]{"FTP", "HTTP"});
        UIUtil.fixComboOrientation(this.protocolCombo);
        this.protocolCombo.addActionListener(this);
        this.protoLabel = RemoteFileChooser.createLabel(this.protocolCombo, msg, "Protocol");
        this.hostCombo = this.createCombo();
        this.hostLabel = RemoteFileChooser.createLabel(this.hostCombo, msg, "HostName");
        this.fileCombo = this.createCombo();
        this.fileNameLabel = RemoteFileChooser.createLabel(this.fileCombo, msg, "FileName");
        this.userCombo = this.createCombo();
        this.userLabel = RemoteFileChooser.createLabel(this.userCombo, msg, "UserID");
        this.passField = new JPasswordField(25);
        this.passField.addFocusListener(this);
        this.passLabel = RemoteFileChooser.createLabel(this.passField, msg, "Password");
        this.encodingCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.encodingCombo);
        SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
        for (String key : availableCharsets.keySet()) {
            this.encodingCombo.addItem(key);
        }
        String defaultEncoding = Charset.forName(RTextFileChooser.getDefaultEncoding()).name();
        this.encodingCombo.setSelectedItem(defaultEncoding);
        this.encodingLabel = RemoteFileChooser.createLabel(this.encodingCombo, msg, "Encoding");
        this.portCombo = this.createCombo();
        this.portLabel = RemoteFileChooser.createLabel(this.portCombo, msg, "Port");
        cp.add((Component)this.formPanel, "North");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        this.okButton = UIUtil.newButton((ResourceBundle)msg, (String)"OK", (String)"OKMnemonic");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        JButton cancelButton = UIUtil.newButton((ResourceBundle)msg, (String)"Cancel", (String)"CancelMnemonic");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.advancedButton = new JToggleButton(msg.getString("Advanced"));
        this.advancedButton.setMnemonic((int)msg.getString("AdvancedMnemonic").charAt(0));
        this.advancedButton.setActionCommand("Advanced");
        this.advancedButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(this.advancedButton);
        this.populateFormPanel();
        this.portCombo.setSelectedItem(DEFAULT_FTP_PORT);
        Container temp = UIUtil.createButtonFooter((Container)buttonPanel);
        cp.add((Component)temp, "South");
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(this.okButton);
        this.setModal(true);
        this.applyComponentOrientation(orientation);
        this.mode = -1;
        this.setMode(0);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)owner));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.protocolCombo == e.getSource()) {
            boolean enabled = this.isFTPSelected();
            this.userLabel.setEnabled(enabled);
            this.userCombo.setEnabled(enabled);
            this.passLabel.setEnabled(enabled);
            this.passField.setEnabled(enabled);
            if (!enabled) {
                this.savedUser = (String)this.userCombo.getSelectedItem();
                this.userCombo.setSelectedItem(null);
                this.savedPass = this.passField.getPassword();
                this.passField.setText(null);
                this.portCombo.setSelectedItem(DEFAULT_HTTP_PORT);
            } else {
                this.userCombo.setSelectedItem(this.savedUser);
                this.passField.setText(new String(this.savedPass));
                Arrays.fill(this.savedPass, '\u0000');
                this.portCombo.setSelectedItem(DEFAULT_FTP_PORT);
            }
            this.updateOKButton();
        } else if ("OK".equals(command)) {
            this.okPressed();
        } else if ("Cancel".equals(command)) {
            this.cancelPressed();
        } else if ("Advanced".equals(command)) {
            this.populateFormPanel();
        }
    }

    protected void cancelPressed() {
        this.setVisible(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentUpdate();
    }

    private JComboBox<String> createCombo() {
        JComboBox<String> combo = new JComboBox<String>((ComboBoxModel<String>)new RComboBoxModel());
        UIUtil.fixComboOrientation(combo);
        combo.setEditable(true);
        RemoteFileChooser.getDocument(combo).addDocumentListener(this);
        RemoteFileChooser.getTextComponent(combo).addFocusListener(this);
        return combo;
    }

    private static JLabel createLabel(JComponent labelFor, ResourceBundle msg, String keyRoot) {
        JLabel label = new JLabel(msg.getString(keyRoot));
        label.setDisplayedMnemonic(msg.getString(keyRoot + "Mnemonic").charAt(0));
        label.setLabelFor(labelFor);
        return label;
    }

    private static URL createURL(String protocol, String user, char[] pass, String host, String port, String file) throws MalformedURLException {
        String urlStr = protocol + "://";
        if ("ftp".equalsIgnoreCase(protocol)) {
            if (((String)file).charAt(0) == '/') {
                file = "%2F" + (String)file;
            }
            urlStr = urlStr + user + ":" + new String(pass) + "@";
        }
        urlStr = urlStr + host;
        if (port != null) {
            urlStr = urlStr + ":" + port;
        }
        urlStr = urlStr + "/" + (String)file;
        return new URL(urlStr);
    }

    protected void escapePressed() {
        this.cancelPressed();
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextComponent) {
            ((JTextComponent)source).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private static Document getDocument(JComboBox<?> combo) {
        return RemoteFileChooser.getTextComponent(combo).getDocument();
    }

    private String getSelectedPort() {
        String text;
        String port = null;
        if (this.portCombo.isVisible() && (text = ((String)this.portCombo.getSelectedItem()).trim()).length() > 0) {
            port = text;
        }
        return port;
    }

    private static JTextComponent getTextComponent(JComboBox<?> combo) {
        return (JTextComponent)combo.getEditor().getEditorComponent();
    }

    private void handleDocumentUpdate() {
        this.updateOKButton();
    }

    private static boolean hasContent(JTextComponent field) {
        return field.getDocument().getLength() > 0;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentUpdate();
    }

    private boolean isFTPSelected() {
        return this.protocolCombo.getSelectedIndex() == 0;
    }

    public void okPressed() {
        String encoding;
        URL url;
        String protocol = (String)this.protocolCombo.getSelectedItem();
        String host = RemoteFileChooser.getTextComponent(this.hostCombo).getText();
        this.hostCombo.addItem(host);
        String file = RemoteFileChooser.getTextComponent(this.fileCombo).getText();
        this.fileCombo.addItem(file);
        String user = RemoteFileChooser.getTextComponent(this.userCombo).getText();
        this.userCombo.addItem(user);
        char[] pass = this.passField.getPassword();
        String port = this.getSelectedPort();
        if (port != null) {
            this.portCombo.addItem(port);
        }
        try {
            url = RemoteFileChooser.createURL(protocol, user, pass, host, port, file);
        }
        catch (MalformedURLException mue) {
            this.owner.displayException(mue);
            return;
        }
        AbstractMainView mainView = this.owner.getMainView();
        String string = encoding = this.encodingCombo.isVisible() ? (String)this.encodingCombo.getSelectedItem() : null;
        if (this.mode == 0) {
            if (mainView.openFile(FileLocation.create((URL)url), encoding, false)) {
                this.setVisible(false);
            }
        } else if (mainView.saveCurrentFileAs(FileLocation.create((URL)url))) {
            this.setVisible(false);
        }
    }

    private void populateFormPanel() {
        this.formPanel.removeAll();
        boolean advanced = this.advancedButton.isSelected();
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        if (o.isLeftToRight()) {
            this.formPanel.add(this.protoLabel);
            this.formPanel.add(this.protocolCombo);
            this.formPanel.add(this.hostLabel);
            this.formPanel.add(this.hostCombo);
            this.formPanel.add(this.fileNameLabel);
            this.formPanel.add(this.fileCombo);
            this.formPanel.add(this.userLabel);
            this.formPanel.add(this.userCombo);
            this.formPanel.add(this.passLabel);
            this.formPanel.add(this.passField);
            if (advanced) {
                this.formPanel.add(this.encodingLabel);
                this.formPanel.add(this.encodingCombo);
                this.formPanel.add(this.portLabel);
                this.formPanel.add(this.portCombo);
            }
        } else {
            this.formPanel.add(this.protocolCombo);
            this.formPanel.add(this.protoLabel);
            this.formPanel.add(this.hostCombo);
            this.formPanel.add(this.hostLabel);
            this.formPanel.add(this.fileCombo);
            this.formPanel.add(this.fileNameLabel);
            this.formPanel.add(this.userCombo);
            this.formPanel.add(this.userLabel);
            this.formPanel.add(this.passField);
            this.formPanel.add(this.passLabel);
            if (advanced) {
                this.formPanel.add(this.encodingCombo);
                this.formPanel.add(this.encodingLabel);
                this.formPanel.add(this.portCombo);
                this.formPanel.add(this.portLabel);
            }
        }
        UIUtil.makeSpringCompactGrid((Container)this.formPanel, (int)(advanced ? 7 : 5), (int)2, (int)0, (int)0, (int)5, (int)5);
        this.formPanel.revalidate();
        this.applyComponentOrientation(o);
        this.pack();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentUpdate();
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        if (mode == 1) {
            this.setTitle(this.saveTitle);
        } else if (mode == 0) {
            this.setTitle(this.openTitle);
        } else {
            throw new IllegalArgumentException("Invalid mode value");
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.userCombo.setSelectedItem(null);
            this.passField.setText(null);
            SwingUtilities.invokeLater(() -> this.hostCombo.requestFocusInWindow());
        }
        super.setVisible(visible);
    }

    private void updateOKButton() {
        boolean filledIn;
        boolean bl = filledIn = RemoteFileChooser.hasContent(RemoteFileChooser.getTextComponent(this.hostCombo)) && RemoteFileChooser.hasContent(RemoteFileChooser.getTextComponent(this.fileCombo));
        if (this.isFTPSelected()) {
            filledIn &= RemoteFileChooser.hasContent(RemoteFileChooser.getTextComponent(this.userCombo));
        }
        this.okButton.setEnabled(filledIn);
    }

    public void updateUI() {
        boolean advanced = this.advancedButton.isSelected();
        if (!advanced) {
            this.encodingLabel.updateUI();
            this.encodingCombo.updateUI();
            this.portLabel.updateUI();
            this.portCombo.updateUI();
        }
    }
}

