/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rsta.ui.search.AbstractFindReplaceDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.FindToolBar;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.ReplaceToolBar;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.ChildWindowListener;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.fife.util.MacOSUtil;

public class SearchManager {
    private RText rtext;
    private SearchingMode searchingMode;
    private FindDialog findDialog;
    private ReplaceDialog replaceDialog;
    private FindToolBar findToolBar;
    private ReplaceToolBar replaceToolBar;

    public SearchManager(RText rtext) {
        this.rtext = rtext;
        this.setSearchingMode(SearchingMode.TOOLBARS);
        rtext.addPropertyChangeListener("iconStyle", e -> this.updateContentAssistIcons());
    }

    public void changeSearchListener(AbstractMainView fromView) {
        AbstractMainView mainView = this.rtext.getMainView();
        if (this.findDialog != null) {
            this.findDialog.removeSearchListener((SearchListener)fromView);
            this.findDialog.addSearchListener((SearchListener)mainView);
            this.replaceDialog.removeSearchListener((SearchListener)fromView);
            this.replaceDialog.addSearchListener((SearchListener)mainView);
        }
        if (this.findToolBar != null) {
            this.findToolBar.removeSearchListener((SearchListener)fromView);
            this.replaceToolBar.addSearchListener((SearchListener)mainView);
        }
    }

    private void configureSearchDialog(AbstractFindReplaceDialog dialog) {
        Image image = this.getLookAndFeelContentAssistImage();
        dialog.setContentAssistImage(image);
        AbstractMainView mainView = this.rtext.getMainView();
        dialog.setSearchContext((SearchContext)mainView.searchContext);
        this.rtext.registerChildWindowListeners((Window)dialog);
        MacOSUtil.setTransparentTitleBar((RootPaneContainer)dialog, (boolean)true);
    }

    private void ensureSearchDialogsCreated() {
        if (this.replaceDialog == null) {
            AbstractMainView mainView = this.rtext.getMainView();
            this.findDialog = new FindDialog((Frame)((Object)this.rtext), (SearchListener)mainView);
            this.configureSearchDialog((AbstractFindReplaceDialog)this.findDialog);
            this.replaceDialog = new ReplaceDialog((Frame)((Object)this.rtext), (SearchListener)mainView);
            this.configureSearchDialog((AbstractFindReplaceDialog)this.replaceDialog);
        }
    }

    private void ensureToolbarsCreated() {
        if (this.findToolBar == null) {
            AbstractMainView mainView = this.rtext.getMainView();
            CollapsibleSectionPanel csp = this.rtext.getCollapsibleSectionPanel();
            this.findToolBar = new FindToolBar((SearchListener)mainView);
            this.findToolBar.setSearchContext((SearchContext)mainView.searchContext);
            csp.addBottomComponent((JComponent)this.findToolBar);
            this.replaceToolBar = new ReplaceToolBar((SearchListener)mainView);
            this.replaceToolBar.setSearchContext((SearchContext)mainView.searchContext);
            csp.addBottomComponent((JComponent)this.replaceToolBar);
            Image image = this.getLookAndFeelContentAssistImage();
            this.findToolBar.setContentAssistImage(image);
            this.replaceToolBar.setContentAssistImage(image);
        }
    }

    public void findNext(SearchContext context) {
        String searchString;
        AbstractMainView mainView = this.rtext.getMainView();
        if (context == null) {
            context = mainView.searchContext;
        }
        if ((searchString = mainView.searchContext.getSearchFor()) == null || searchString.isEmpty()) {
            switch (this.searchingMode) {
                case DIALOGS: {
                    this.ensureSearchDialogsCreated();
                    this.findDialog.setVisible(true);
                    break;
                }
                case TOOLBARS: {
                    this.ensureToolbarsCreated();
                    this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.findToolBar);
                }
            }
            return;
        }
        RTextEditorPane textArea = mainView.getCurrentTextArea();
        try {
            this.handleSearchResult(context, SearchEngine.find((JTextArea)((Object)textArea), (SearchContext)context));
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog((Component)((Object)this.rtext), "Invalid regular expression:\n" + pse + "\nPlease check your regular expression search string.", "Error", 0);
        }
    }

    public Image getLookAndFeelContentAssistImage() {
        return this.rtext.getIconGroup().getImage("lightbulb");
    }

    public SearchingMode getSearchingMode() {
        return this.searchingMode;
    }

    private void handleSearchResult(SearchContext context, SearchResult result) {
        RTextEditorPane textArea = this.rtext.getMainView().getCurrentTextArea();
        if (!result.wasFound()) {
            String searchString = context.getSearchFor();
            searchString = HtmlUtil.escapeForHtml((String)searchString, null, (boolean)false);
            String temp = this.rtext.getString("CannotFindString", new Object[]{searchString});
            JOptionPane.showMessageDialog(null, temp, this.rtext.getString("InfoDialogHeader", new Object[0]), 1);
        } else if (result.isWrapped()) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)textArea));
        }
        if (this.isNoSearchUIVisible()) {
            textArea.requestFocusInWindow();
        }
    }

    private void hideFindDialogIfVisible() {
        if (this.findDialog != null && this.findDialog.isVisible()) {
            this.findDialog.setVisible(false);
        }
    }

    private void hideReplaceDialogIfVisible() {
        if (this.replaceDialog != null && this.replaceDialog.isVisible()) {
            this.replaceDialog.setVisible(false);
        }
    }

    private boolean isNoSearchUIVisible() {
        return !(this.findDialog != null && this.findDialog.isVisible() || this.replaceDialog != null && this.replaceDialog.isVisible() || this.rtext.getCollapsibleSectionPanel().getDisplayedBottomComponent() != null);
    }

    public void refreshDialogTranslucencies(ChildWindowListener listener) {
        if (this.findDialog != null && this.findDialog.isShowing()) {
            listener.refreshTranslucency((Window)this.findDialog);
        }
        if (this.replaceDialog != null && this.replaceDialog.isShowing()) {
            listener.refreshTranslucency((Window)this.replaceDialog);
        }
    }

    public void replaceNext(SearchContext context) {
        String searchString;
        AbstractMainView mainView = this.rtext.getMainView();
        if (context == null) {
            context = mainView.searchContext;
        }
        if ((searchString = context.getSearchFor()) == null || searchString.isEmpty()) {
            switch (this.searchingMode) {
                case DIALOGS: {
                    this.ensureSearchDialogsCreated();
                    this.replaceDialog.setVisible(true);
                    break;
                }
                case TOOLBARS: {
                    this.ensureToolbarsCreated();
                    this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.replaceToolBar);
                }
            }
            return;
        }
        RTextEditorPane textArea = mainView.getCurrentTextArea();
        try {
            this.handleSearchResult(context, SearchEngine.replace((RTextArea)textArea, (SearchContext)context));
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog((Component)((Object)this.rtext), "Invalid regular expression:\n" + pse + "\nPlease check your regular expression search string.", "Error", 0);
        }
        catch (IndexOutOfBoundsException ioobe) {
            JOptionPane.showMessageDialog((Component)((Object)this.rtext), "Invalid group reference in replacement string:\n" + ioobe.getMessage(), "Error", 0);
        }
    }

    public void setSearchingMode(SearchingMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode cannot be null");
        }
        CollapsibleSectionPanel csp = this.rtext.getCollapsibleSectionPanel();
        if (csp != null) {
            switch (mode) {
                case DIALOGS: {
                    csp.hideBottomComponent();
                    break;
                }
                case TOOLBARS: {
                    this.hideFindDialogIfVisible();
                    this.hideReplaceDialogIfVisible();
                }
            }
        }
        this.searchingMode = mode;
    }

    public void showFindUI() {
        if (this.searchingMode == SearchingMode.DIALOGS) {
            this.rtext.getCollapsibleSectionPanel().hideBottomComponent();
            this.ensureSearchDialogsCreated();
            if (this.replaceDialog.isVisible()) {
                this.replaceDialog.setVisible(false);
            }
            if (!this.findDialog.isVisible()) {
                RTextEditorPane editor = this.rtext.getMainView().getCurrentTextArea();
                String selectedText = editor.getSelectedText();
                if (selectedText != null) {
                    this.findDialog.setSearchString(selectedText);
                }
                this.findDialog.setVisible(true);
            } else {
                this.findDialog.requestFocus();
            }
        } else {
            this.hideFindDialogIfVisible();
            this.hideReplaceDialogIfVisible();
            this.ensureToolbarsCreated();
            this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.findToolBar);
        }
    }

    public void showReplaceUI() {
        if (this.searchingMode == SearchingMode.DIALOGS) {
            this.rtext.getCollapsibleSectionPanel().hideBottomComponent();
            this.ensureSearchDialogsCreated();
            if (this.findDialog.isVisible()) {
                this.findDialog.setVisible(false);
            }
            if (!this.replaceDialog.isVisible()) {
                RTextEditorPane editor = this.rtext.getMainView().getCurrentTextArea();
                String selectedText = editor.getSelectedText();
                if (selectedText != null) {
                    this.replaceDialog.setSearchString(selectedText);
                }
                this.replaceDialog.setVisible(true);
            } else {
                this.replaceDialog.requestFocus();
            }
        } else {
            this.hideFindDialogIfVisible();
            this.hideReplaceDialogIfVisible();
            this.ensureToolbarsCreated();
            this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.replaceToolBar);
        }
    }

    private void updateContentAssistIcons() {
        Image image;
        if (this.findDialog != null) {
            image = this.getLookAndFeelContentAssistImage();
            this.findDialog.setContentAssistImage(image);
            this.replaceDialog.setContentAssistImage(image);
        }
        if (this.findToolBar != null) {
            image = this.getLookAndFeelContentAssistImage();
            this.findToolBar.setContentAssistImage(image);
            this.replaceToolBar.setContentAssistImage(image);
        }
    }

    public void updateUI() {
        if (this.findDialog != null) {
            SwingUtilities.updateComponentTreeUI((Component)this.findDialog);
            this.findDialog.updateUI();
            this.findDialog.pack();
            SwingUtilities.updateComponentTreeUI((Component)this.replaceDialog);
            this.replaceDialog.updateUI();
            this.replaceDialog.pack();
        }
    }

    public static enum SearchingMode {
        DIALOGS,
        TOOLBARS;

    }
}

