/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.AbstractParserNoticeWindow;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.UIUtil;
import org.fife.ui.dockablewindows.DockableWindowScrollPane;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.spell.SpellingParser;

class SpellingErrorWindow
extends AbstractParserNoticeWindow
implements PropertyChangeListener {
    private SpellingTableModel model;

    SpellingErrorWindow(RText rtext) {
        super(rtext);
        AbstractMainView mainView = rtext.getMainView();
        mainView.addPropertyChangeListener("MainView.textAreaAdded", this);
        mainView.addPropertyChangeListener("MainView.textAreaRemoved", this);
        this.model = new SpellingTableModel(rtext.getString("SpellingErrorList.Word", new Object[0]));
        JTable table = this.createTable(this.model);
        UIUtil.removeTabbedPaneFocusTraversalKeyBindings((JComponent)table);
        DockableWindowScrollPane sp = new DockableWindowScrollPane((Component)table);
        UIUtil.removeTabbedPaneFocusTraversalKeyBindings((JComponent)sp);
        this.setLayout(new BorderLayout());
        this.add((Component)sp);
        this.setPosition(2);
        this.setActive(true);
        this.setDockableWindowName(rtext.getString("SpellingErrorList.Spelling", new Object[0]));
        this.setIcon(this.getIconForAppTheme());
        rtext.addPropertyChangeListener("iconStyle", this);
        for (int i = 0; i < mainView.getNumDocuments(); ++i) {
            RTextEditorPane textArea = mainView.getRTextEditorPaneAt(i);
            List notices = textArea.getParserNotices();
            this.model.update(textArea, notices);
            textArea.addPropertyChangeListener("RSTA.parserNotices", this);
        }
    }

    private Icon getIconForAppTheme() {
        return this.getRText().getIconGroup().getIcon("spellcheck");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("RSTA.parserNotices".equals(prop)) {
            RTextEditorPane source = (RTextEditorPane)((Object)e.getSource());
            List notices = source.getParserNotices();
            this.model.update(source, notices);
        }
        if ("MainView.textAreaAdded".equals(prop)) {
            textArea = (RTextEditorPane)((Object)e.getNewValue());
            textArea.addPropertyChangeListener("RSTA.parserNotices", this);
        } else if ("MainView.textAreaRemoved".equals(prop)) {
            textArea = (RTextEditorPane)((Object)e.getNewValue());
            textArea.removePropertyChangeListener("RSTA.parserNotices", this);
        } else if ("iconStyle".equals(prop)) {
            this.setIcon(this.getIconForAppTheme());
        }
    }

    private class SpellingTableModel
    extends AbstractParserNoticeWindow.ParserNoticeTableModel {
        SpellingTableModel(String lastColHeader) {
            super(lastColHeader);
        }

        @Override
        protected void addNoticesImpl(RTextEditorPane textArea, List<ParserNotice> notices) {
            AbstractMainView view = SpellingErrorWindow.this.getRText().getMainView();
            SpellingParser parser = view.getSpellingSupport().getSpellingParser();
            for (ParserNotice notice : notices) {
                if (notice.getParser() != parser) continue;
                Object[] data = new Object[]{SpellingErrorWindow.this.getIcon(), textArea, notice.getLine() + 1, notice.getMessage()};
                this.addRow(data);
            }
        }
    }
}

