/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fife.ui.rsyntaxtextarea.FileTypeUtil;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

public class SyntaxFilters
implements SyntaxConstants {
    private Map<String, List<String>> filters = new HashMap<String, List<String>>();
    private Map<String, List<String>> addedFilters;

    public SyntaxFilters() {
        this(null);
    }

    public SyntaxFilters(String filterStr) {
        this.restoreDefaultFileFilters();
        if (filterStr != null) {
            int oldCommaPos = 0;
            int commaPos = filterStr.indexOf(44);
            try {
                while (commaPos != -1) {
                    int colon;
                    Object temp = filterStr.substring(oldCommaPos, commaPos);
                    int slash = ((String)temp).indexOf(92);
                    if (slash > -1) {
                        temp = ((String)temp).substring(0, slash) + "/" + ((String)temp).substring(slash + 1);
                    }
                    if ((colon = ((String)temp).indexOf(58)) <= -1) {
                        System.err.println("Invalid saved filter string.  Using default syntax filters");
                        this.restoreDefaultFileFilters();
                        return;
                    }
                    String style = ((String)temp).substring(0, colon);
                    this.setFiltersForSyntaxStyle(style, ((String)temp).substring(colon + 1));
                    oldCommaPos = commaPos + 1;
                    commaPos = filterStr.indexOf(44, oldCommaPos);
                }
                int colon = filterStr.indexOf(58, oldCommaPos);
                if (colon > -1) {
                    String style = filterStr.substring(oldCommaPos, colon);
                    this.setFiltersForSyntaxStyle(style, filterStr.substring(colon + 1));
                } else {
                    System.err.println("Invalid saved filter string.  Using default syntax filters");
                    this.restoreDefaultFileFilters();
                }
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Error with syntax style, using defaults: " + iae.getMessage());
                this.restoreDefaultFileFilters();
            }
        }
    }

    public void addFileFilter(String style, String filter) {
        this.getFiltersForStyle(style).add(filter);
    }

    private List<String> getFiltersForStyle(String style) {
        List l = this.filters.get(style);
        if (l == null) {
            if (this.addedFilters == null) {
                this.addedFilters = new HashMap<String, List<String>>();
            }
            l = this.addedFilters.computeIfAbsent(style, s -> new ArrayList());
        }
        return l;
    }

    public String getFilterString(String style) {
        StringBuilder filterString = new StringBuilder();
        List<String> filters = this.getFiltersForStyle(style);
        for (String filter : filters) {
            filterString.append(filter).append(' ');
        }
        return filterString.toString();
    }

    public String getSyntaxStyleForFile(String fileName, boolean ignoreBackupExtensions) {
        if (fileName == null) {
            return "text/plain";
        }
        HashMap<String, List<String>> allFilters = new HashMap<String, List<String>>(this.filters);
        if (this.addedFilters != null) {
            allFilters.putAll(this.addedFilters);
        }
        return FileTypeUtil.get().guessContentType(new File(fileName), allFilters, ignoreBackupExtensions);
    }

    public static boolean isValidFileFilterString(String fileFilterString) {
        int length = fileFilterString.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = fileFilterString.charAt(i);
            switch (c) {
                case ' ': 
                case '$': 
                case '*': 
                case '-': 
                case '.': 
                case '?': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public void restoreDefaultFileFilters() {
        this.filters = FileTypeUtil.get().getDefaultContentTypeToFilterMap();
    }

    public void setFiltersForSyntaxStyle(String style, String filterString) {
        List<String> filters = this.getFiltersForStyle(style);
        filters.clear();
        int oldSpacePos = 0;
        int spacePos = filterString.indexOf(32);
        while (spacePos != -1) {
            if (spacePos > oldSpacePos + 1) {
                filters.add(filterString.substring(oldSpacePos, spacePos));
            }
            oldSpacePos = spacePos + 1;
            spacePos = filterString.indexOf(32, oldSpacePos);
        }
        if (oldSpacePos < filterString.length() - 1) {
            filters.add(filterString.substring(oldSpacePos));
        }
    }

    public void setPreservingPluginAdded(SyntaxFilters filters) {
        this.filters = new HashMap<String, List<String>>(filters.filters);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        for (String style : this.filters.keySet()) {
            retVal.append(style).append(":").append(this.getFilterString(style)).append(",");
        }
        retVal = new StringBuilder(retVal.substring(0, retVal.length() - 1));
        return retVal.toString();
    }
}

