/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;

class TextAreaAwareIcon
implements Icon,
PropertyChangeListener {
    private Icon icon;
    private boolean paintModifiedMarker;

    TextAreaAwareIcon(TextEditorPane editorPane, Icon icon) {
        editorPane.addPropertyChangeListener((PropertyChangeListener)this);
        this.icon = icon;
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.icon.paintIcon(c, g, x, y);
        if (this.paintModifiedMarker) {
            g.setColor(Color.RED);
            g.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("TextEditorPane.dirty".equals(propertyName)) {
            this.paintModifiedMarker = (Boolean)e.getNewValue();
        }
    }
}

