/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.ComponentOrientation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.Action;
import org.fife.rtext.RText;
import org.fife.rtext.RTextActionInfo;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.actions.CheckForUpdatesAction;
import org.fife.rtext.actions.CloseAction;
import org.fife.rtext.actions.CloseAllAction;
import org.fife.rtext.actions.DecreaseFontSizeAction;
import org.fife.rtext.actions.FilePropertiesAction;
import org.fife.rtext.actions.FindAction;
import org.fife.rtext.actions.FindInFilesAction;
import org.fife.rtext.actions.FindNextAction;
import org.fife.rtext.actions.GoToAction;
import org.fife.rtext.actions.HomePageAction;
import org.fife.rtext.actions.IncreaseFontSizeAction;
import org.fife.rtext.actions.LineNumberAction;
import org.fife.rtext.actions.MoveFocusDownAction;
import org.fife.rtext.actions.MoveFocusLeftAction;
import org.fife.rtext.actions.MoveFocusRightAction;
import org.fife.rtext.actions.MoveFocusUpAction;
import org.fife.rtext.actions.NewAction;
import org.fife.rtext.actions.NextDocumentAction;
import org.fife.rtext.actions.OpenAction;
import org.fife.rtext.actions.OpenInNewWindowAction;
import org.fife.rtext.actions.OpenRecentAction;
import org.fife.rtext.actions.OpenRemoteAction;
import org.fife.rtext.actions.PrintAction;
import org.fife.rtext.actions.PrintPreviewAction;
import org.fife.rtext.actions.ReplaceAction;
import org.fife.rtext.actions.ReplaceAllAction;
import org.fife.rtext.actions.ReplaceInFilesAction;
import org.fife.rtext.actions.ReplaceNextAction;
import org.fife.rtext.actions.SaveAction;
import org.fife.rtext.actions.SaveAllAction;
import org.fife.rtext.actions.SaveAsAction;
import org.fife.rtext.actions.SaveAsRemoteAction;
import org.fife.rtext.actions.SaveAsWebPageAction;
import org.fife.rtext.actions.TextAreaOrientationAction;
import org.fife.rtext.actions.ViewSplitAction;
import org.fife.ui.ImageTranscodingUtil;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public final class ActionFactory
implements RTextActionInfo {
    private ActionFactory() {
    }

    public static void addActions(RText rtext, RTextPrefs prefs) {
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.rtext.actions.Actions");
        ClassLoader cl = ActionFactory.class.getClassLoader();
        String lightResource = "org/fife/rtext/graphics/app_icons/seagull-light.svg";
        String darkResource = "org/fife/rtext/graphics/app_icons/seagull-dark.svg";
        try {
            rtext.setIconImages(Arrays.asList(ImageTranscodingUtil.rasterize((String)"appIcon16", (InputStream)cl.getResourceAsStream(darkResource), (int)16, (int)16), ImageTranscodingUtil.rasterize((String)"appIcon32", (InputStream)cl.getResourceAsStream(lightResource), (int)32, (int)32), ImageTranscodingUtil.rasterize((String)"appIcon48", (InputStream)cl.getResourceAsStream(lightResource), (int)48, (int)48), ImageTranscodingUtil.rasterize((String)"appIcon64", (InputStream)cl.getResourceAsStream(lightResource), (int)64, (int)64)));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        AppAction a = new NewAction(rtext, msg, null);
        rtext.addAction("newAction", (Action)a);
        a = new OpenAction(rtext, msg, null);
        rtext.addAction("openAction", (Action)a);
        a = new OpenInNewWindowAction(rtext, msg, null);
        rtext.addAction("openNewWinAction", (Action)a);
        a = new OpenRecentAction(rtext, msg, null);
        rtext.addAction("openRecentAction", (Action)a);
        a = new OpenRemoteAction(rtext, msg, null);
        rtext.addAction("openRemoteAction", (Action)a);
        a = new SaveAction(rtext, msg, null);
        rtext.addAction("saveAction", (Action)a);
        a = new SaveAsAction(rtext, msg, null);
        rtext.addAction("saveAsAction", (Action)a);
        a = new SaveAsRemoteAction(rtext, msg, null);
        rtext.addAction("saveAsRemoteAction", (Action)a);
        a = new SaveAsWebPageAction(rtext, msg, null);
        rtext.addAction("saveWebPageAction", (Action)a);
        a = new SaveAllAction(rtext, msg, null);
        rtext.addAction("saveAllAction", (Action)a);
        a = new GUIApplication.ExitAction((GUIApplication)rtext, msg, "ExitAction");
        rtext.addAction("exitAction", (Action)a);
        String temp = msg.getString("CopyAsStyledTextAction");
        rtext.addAction("copyAsStyledText", (Action)new RSyntaxTextAreaEditorKit.CopyCutAsStyledTextAction(temp, null, msg.getString("CopyAsStyledTextAction.ShortDesc"), Integer.valueOf(msg.getString("CopyAsStyledTextAction.Mnemonic").charAt(0)), null));
        temp = msg.getString("TimeAction");
        rtext.addAction("timeDateAction", (Action)new RTextAreaEditorKit.TimeDateAction(temp, null, msg.getString("TimeAction.ShortDesc"), Integer.valueOf(msg.getString("TimeAction.Mnemonic").charAt(0)), null));
        a = new GUIApplication.ToggleToolBarAction((GUIApplication)rtext, msg, "ToolBarAction");
        rtext.addAction("toolBarAction", (Action)a);
        a = new GUIApplication.ToggleStatusBarAction((GUIApplication)rtext, msg, "StatusBarAction");
        rtext.addAction("statusBarAction", (Action)a);
        a = new LineNumberAction(rtext, msg, null);
        rtext.addAction("lineNumberAction", (Action)a);
        a = new FilePropertiesAction(rtext, msg);
        rtext.addAction("filePropertiesAction", (Action)a);
        a = new GUIApplication.HelpAction((GUIApplication)rtext, msg, "HelpAction");
        rtext.addAction("helpAction", (Action)a);
        a = new GUIApplication.AboutAction((GUIApplication)rtext, msg, "AboutAction");
        rtext.addAction("aboutAction", (Action)a);
        a = new AbstractGUIApplication.OptionsAction((AbstractGUIApplication)rtext, msg, "OptionsAction");
        rtext.addAction("optionsAction", (Action)a);
        a = new HomePageAction(rtext, msg, null);
        rtext.addAction("homePageAction", (Action)a);
        a = new CheckForUpdatesAction(rtext, msg, null);
        rtext.addAction("checkForUpdatesAction", (Action)a);
        a = new CloseAction(rtext, msg, null);
        rtext.addAction("closeAction", (Action)a);
        a = new CloseAllAction(rtext, msg, null);
        rtext.addAction("closeAllAction", (Action)a);
        a = new FindAction(rtext, msg, null);
        rtext.addAction("findAction", (Action)a);
        a = new FindNextAction(rtext, msg, null);
        rtext.addAction("findNextAction", (Action)a);
        a = new ReplaceAction(rtext, msg, null);
        rtext.addAction("replaceAction", (Action)a);
        a = new ReplaceNextAction(rtext, msg, null);
        rtext.addAction("replaceNextAction", (Action)a);
        a = new ReplaceAllAction(rtext, msg, null);
        rtext.addAction("replaceAllAction", (Action)a);
        a = new FindInFilesAction(rtext, msg, null);
        rtext.addAction("findInFilesAction", (Action)a);
        a = new ReplaceInFilesAction(rtext, msg, null);
        rtext.addAction("replaceInFilesAction", (Action)a);
        a = new PrintAction(rtext, msg, null);
        rtext.addAction("printAction", (Action)a);
        a = new PrintPreviewAction(rtext, msg, null);
        rtext.addAction("printPreviewAction", (Action)a);
        a = new GoToAction(rtext, msg, null);
        rtext.addAction("gotoAction", (Action)a);
        a = new TextAreaOrientationAction(rtext, msg, "LeftToRightAction", null, ComponentOrientation.LEFT_TO_RIGHT);
        rtext.addAction("leftToRightAction", (Action)a);
        a = new TextAreaOrientationAction(rtext, msg, "RightToLeftAction", null, ComponentOrientation.RIGHT_TO_LEFT);
        rtext.addAction("rightToLeftAction", (Action)a);
        a = new MoveFocusLeftAction(rtext, msg);
        rtext.addAction("moveFocusLeftAction", (Action)a);
        a = new MoveFocusRightAction(rtext, msg);
        rtext.addAction("moveFocusRightAction", (Action)a);
        a = new MoveFocusUpAction(rtext, msg);
        rtext.addAction("moveFocusUpAction", (Action)a);
        a = new MoveFocusDownAction(rtext, msg);
        rtext.addAction("moveFocusDownAction", (Action)a);
        a = new ViewSplitAction(rtext, msg, null, "SplitHorizontallyAction", "viewSplitHorizontallyAction");
        rtext.addAction("viewSplitHorizontallyAction", (Action)a);
        a = new ViewSplitAction(rtext, msg, null, "SplitNoneAction", "viewSplitNoneAction");
        rtext.addAction("viewSplitNoneAction", (Action)a);
        a = new ViewSplitAction(rtext, msg, null, "SplitVerticallyAction", "viewSplitVerticallyAction");
        rtext.addAction("viewSplitVerticallyAction", (Action)a);
        a = new NextDocumentAction(rtext, msg, true);
        rtext.addAction("nextDocumentAction", (Action)a);
        a = new NextDocumentAction(rtext, msg, false);
        rtext.addAction("prevDocumentAction", (Action)a);
        a = new IncreaseFontSizeAction(rtext, msg);
        rtext.addAction("incFontSizesAction", (Action)a);
        a = new DecreaseFontSizeAction(rtext, msg);
        rtext.addAction("decFontSizesAction", (Action)a);
    }
}

