/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.fife.rtext.RText;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;

class CheckForUpdatesAction
extends AppAction<RText> {
    private static final String CHECK_URL = "https://raw.githubusercontent.com/bobbylight/RText/gh-pages/latest.properties";
    private static final String DOWNLOAD_URL = "https://github.com/bobbylight/RText";

    CheckForUpdatesAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "CheckForUpdates");
        this.setIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        RText rtext = (RText)this.getApplication();
        Properties props = new Properties();
        try {
            URL url = new URL(CHECK_URL);
            InputStream in = (InputStream)url.getContent();
            try (BufferedInputStream bin = new BufferedInputStream(in);){
                props.load(bin);
            }
            String fileVersion = props.getProperty("File.Version");
            if (!"1".equals(fileVersion)) {
                throw new IOException("Unsupported file version: " + fileVersion);
            }
        }
        catch (IOException ioe) {
            rtext.displayException(ioe);
            return;
        }
        String current = rtext.getVersionString();
        String latest = props.getProperty("Latest.RText.Version");
        String releaseDate = props.getProperty("Latest.Release.Date");
        if (current.startsWith(latest)) {
            String msg = rtext.getString("UpdateStatus.UpToDate", new Object[0]);
            String title = rtext.getString("InfoDialogHeader", new Object[0]);
            JOptionPane.showMessageDialog(null, msg, title, 1);
        } else {
            String title;
            String msg = rtext.getString("UpdateStatus.NeedToUpdate", new Object[]{latest, releaseDate});
            int rc = JOptionPane.showConfirmDialog((Component)((Object)rtext), msg, title = rtext.getString("InfoDialogHeader", new Object[0]), 0);
            if (rc == 0) {
                msg = rtext.getString("UpdateStatus.ShutdownReminder", new Object[0]);
                JOptionPane.showMessageDialog((Component)((Object)rtext), msg, title, 2);
                if (!UIUtil.browse((String)DOWNLOAD_URL)) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)rtext));
                }
            }
        }
    }
}

