/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import org.fife.rtext.RText;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;

class MoveFocusLeftAction
extends AppAction<RText> {
    MoveFocusLeftAction(RText app, ResourceBundle msg) {
        super((GUIApplication)app, msg, "MoveFocusLeftAction");
    }

    public void actionPerformed(ActionEvent e) {
        int toFocus;
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return;
        }
        RText rtext = (RText)this.getApplication();
        int focusedGroup = rtext.getFocusedDockableWindowGroup();
        switch (focusedGroup) {
            default: {
                if (rtext.hasDockableWindowGroup(1)) {
                    toFocus = 1;
                    break;
                }
                if (rtext.hasDockableWindowGroup(3)) {
                    toFocus = 3;
                    break;
                }
                return;
            }
            case 1: {
                if (rtext.hasDockableWindowGroup(3)) {
                    toFocus = 3;
                    break;
                }
                toFocus = -1;
                break;
            }
            case 3: {
                toFocus = -1;
            }
        }
        if (toFocus == -1) {
            rtext.getMainView().getCurrentTextArea().requestFocusInWindow();
        } else {
            rtext.focusDockableWindowGroup(toFocus);
        }
    }
}

