/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.actions.AbstractSearchAction;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;

class ReplaceAllAction
extends AppAction<RText>
implements AbstractSearchAction {
    ReplaceAllAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "ReplaceAllAction");
        this.setIcon(icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed((SearchContext)null);
    }

    @Override
    public void actionPerformed(SearchContext context) {
        RText rtext = (RText)this.getApplication();
        AbstractMainView mainView = rtext.getMainView();
        RTextEditorPane textArea = mainView.getCurrentTextArea();
        if (context == null) {
            context = mainView.searchContext;
        }
        String searchString = context.getSearchFor();
        try {
            SearchResult result = SearchEngine.replaceAll((RTextArea)textArea, (SearchContext)context);
            int count = result.getCount();
            if (count != -1) {
                if (count > 0) {
                    String temp = rtext.getString("ReplacedNOccString", new Object[]{Integer.toString(count), searchString});
                    JOptionPane.showMessageDialog((Component)((Object)rtext), temp, rtext.getString("InfoDialogHeader", new Object[0]), 1);
                } else {
                    searchString = HtmlUtil.escapeForHtml((String)searchString, null, (boolean)false);
                    String temp = rtext.getString("CannotFindString", new Object[]{searchString});
                    JOptionPane.showMessageDialog(null, temp, rtext.getString("InfoDialogHeader", new Object[0]), 1);
                }
            }
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog((Component)((Object)rtext), "Invalid regular expression:\n" + pse + "\nPlease check your regular expression search string.", "Error", 0);
        }
        catch (IndexOutOfBoundsException ioobe) {
            JOptionPane.showMessageDialog((Component)((Object)rtext), "Invalid group reference in replacement string:\n" + ioobe.getMessage(), "Error", 0);
        }
    }
}

