/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.filters.HTMLFileFilter;

class SaveAsWebPageAction
extends AppAction<RText> {
    SaveAsWebPageAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "SaveAsWebPageAction");
        this.setIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        RText owner = (RText)this.getApplication();
        RTextFileChooser chooser = new RTextFileChooser();
        chooser.setCustomTitle(owner.getString("SaveAsWebPage", new Object[0]));
        chooser.addChoosableFileFilter((FileFilter)new HTMLFileFilter());
        chooser.setEncoding("UTF-8");
        RTextEditorPane editor = owner.getMainView().getCurrentTextArea();
        Object htmlFileName = editor.getFileFullPath();
        int extensionStart = ((String)htmlFileName).lastIndexOf(46);
        htmlFileName = extensionStart != -1 ? ((String)htmlFileName).substring(0, extensionStart) + ".html" : (String)htmlFileName + ".html";
        chooser.setSelectedFile(new File((String)htmlFileName));
        chooser.setComponentOrientation(owner.getComponentOrientation());
        if (chooser.showSaveDialog((Window)((Object)owner)) == 0) {
            String temp;
            File chosenFile = chooser.getSelectedFile();
            Object chosenFilePath = chosenFile.getAbsolutePath();
            if (chosenFile.exists() && 1 == JOptionPane.showConfirmDialog((Component)((Object)owner), temp = owner.getString("FileAlreadyExists", new Object[]{chosenFile.getAbsolutePath()}), owner.getString("ConfDialogTitle", new Object[0]), 0)) {
                return;
            }
            if (!((String)chosenFilePath).matches("[^.]*\\.html?")) {
                chosenFilePath = (String)chosenFilePath + ".html";
            }
            try {
                this.saveAs((String)chosenFilePath);
            }
            catch (IOException ioe) {
                String desc = owner.getString("ErrorWritingFile", new Object[]{chosenFilePath, ioe.getMessage()});
                JOptionPane.showMessageDialog((Component)((Object)owner), desc, owner.getString("ErrorDialogTitle", new Object[0]), 0);
                owner.setMessages(null, "ERROR:  Could not save file!");
                ioe.printStackTrace();
            }
        }
    }

    private void saveAs(String path) throws IOException {
        String[] styles = new String[39];
        StringBuilder temp = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8)));
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        out.println("<head>");
        out.println("<!-- Generated by RText -->");
        out.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />");
        out.println("<title>" + path + "</title>");
        RText rtext = (RText)this.getApplication();
        RTextEditorPane textArea = rtext.getMainView().getCurrentTextArea();
        int lineCount = textArea.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            for (Token token = textArea.getTokenListForLine(i); token != null && token.isPaintable(); token = token.getNextToken()) {
                if (styles[token.getType()] == null) {
                    temp.setLength(0);
                    temp.append(".s").append(token.getType()).append(" {\n");
                    Font font = textArea.getFontForTokenType(token.getType());
                    if (font.isBold()) {
                        temp.append("font-weight: bold;\n");
                    }
                    if (font.isItalic()) {
                        temp.append("font-style: italic;\n");
                    }
                    Color c = textArea.getForegroundForToken(token);
                    temp.append("color: ").append(UIUtil.getHTMLFormatForColor((Color)c)).append(";\n");
                    temp.append("}");
                    styles[token.getType()] = temp.toString();
                }
                sb.append("<span class=\"s").append(token.getType()).append("\">");
                sb.append(HtmlUtil.escapeForHtml((String)token.getLexeme(), (String)"\n", (boolean)true));
                sb.append("</span>");
            }
            sb.append('\n');
        }
        out.println("<style type=\"text/css\">");
        for (String style : styles) {
            if (style == null) continue;
            out.println(style);
        }
        out.println("</style>");
        out.println("</head>");
        out.println("<body>\n<pre>");
        out.println(sb);
        out.println("</pre>\n</body>\n</html>");
        out.close();
    }
}

