/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.SyntaxFilters;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.modifiabletable.AbstractRowHandler;
import org.fife.ui.modifiabletable.ModifiableTable;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.modifiabletable.RowHandler;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

class FileFilterOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ModifiableTableListener {
    private final ModifiableTable filterTable;
    private final FilterTableModel model;
    private final JCheckBox guessTypeCB;
    private final JCheckBox ignoreExtsCB;
    private final RText rtext;

    FileFilterOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptFFName"));
        this.rtext = rtext;
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setLayout(new BorderLayout());
        this.setBorder(UIUtil.getEmpty5Border());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptFFLabel")));
        this.add(contentPane);
        SelectableLabel desc = new SelectableLabel(msg.getString("OptFFDesc"));
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        temp.add((Component)desc, "Before");
        contentPane.add((Component)temp, "North");
        this.model = new FilterTableModel(msg.getString("OptFFCol1"), msg.getString("OptFFCol2"));
        this.filterTable = new ModifiableTable((DefaultTableModel)this.model, "South", 4);
        this.filterTable.setRowHandler((RowHandler)new FileFilterRowHandler());
        this.filterTable.addModifiableTableListener((ModifiableTableListener)this);
        JTable table = this.filterTable.getTable();
        table.setPreferredScrollableViewportSize(new Dimension(300, 300));
        contentPane.add((Component)this.filterTable);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.guessTypeCB = new JCheckBox(msg.getString("GuessContentType"));
        this.guessTypeCB.setActionCommand("GuessContentType");
        this.guessTypeCB.addActionListener(this);
        this.ignoreExtsCB = new JCheckBox(msg.getString("IgnoreTheseExtensions"));
        this.ignoreExtsCB.setActionCommand("IgnoreTheseExtensions");
        this.ignoreExtsCB.addActionListener(this);
        Box box = Box.createVerticalBox();
        this.addLeftAligned(box, this.guessTypeCB, 3);
        this.addLeftAligned(box, this.ignoreExtsCB, 5);
        bottomPanel.add((Component)box, "North");
        JButton rdButton = new JButton(msg.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this);
        temp = new JPanel(new BorderLayout());
        temp.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        temp.add((Component)rdButton, "Before");
        bottomPanel.add((Component)temp, "South");
        this.add(bottomPanel, "South");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("RestoreDefaults".equals(command)) {
            SyntaxFilters defaultFilters = new SyntaxFilters();
            boolean changed = this.setSyntaxFilters(defaultFilters);
            if (changed || !this.guessTypeCB.isSelected() || !this.ignoreExtsCB.isSelected()) {
                this.guessTypeCB.setSelected(true);
                this.ignoreExtsCB.setSelected(true);
                this.setDirty(true);
            }
        } else if ("GuessContentType".equals(command)) {
            this.setDirty(true);
        } else if ("IgnoreTheseExtensions".equals(command)) {
            this.setDirty(true);
        }
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setSyntaxFilters(this.getSyntaxFilters());
        mainView.setGuessFileContentType(this.guessTypeCB.isSelected());
        mainView.setIgnoreBackupExtensions(this.ignoreExtsCB.isSelected());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String filters = (String)this.model.getValueAt(i, 1);
            if (SyntaxFilters.isValidFileFilterString(filters)) continue;
            String temp = this.rtext.getString("InvalidFFString", new Object[]{filters});
            return new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this, (JComponent)this.filterTable, temp);
        }
        return null;
    }

    private SyntaxFilters getSyntaxFilters() {
        SyntaxFilters filters = new SyntaxFilters();
        for (int i = 0; i < this.model.styles.length; ++i) {
            filters.setFiltersForSyntaxStyle(this.model.styles[i], (String)this.model.getValueAt(i, 1));
        }
        return filters;
    }

    public JComponent getTopJComponent() {
        return this.filterTable;
    }

    public void modifiableTableChanged(ModifiableTableChangeEvent e) {
        this.setDirty(true);
    }

    private boolean setSyntaxFilters(SyntaxFilters syntaxFilters) {
        boolean changed = false;
        for (int i = 0; i < this.model.styles.length; ++i) {
            String old;
            String style = this.model.styles[i];
            String filterString = syntaxFilters.getFilterString(style);
            if (filterString.equals(old = (String)this.model.getValueAt(i, 1))) continue;
            this.model.setValueAt(filterString, i, 1);
            changed = true;
        }
        return changed;
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setSyntaxFilters(mainView.getSyntaxFilters());
        this.guessTypeCB.setSelected(mainView.getGuessFileContentType());
        this.ignoreExtsCB.setSelected(mainView.getIgnoreBackupExtensions());
    }

    static class FilterTableModel
    extends DefaultTableModel
    implements SyntaxConstants {
        String[] styles = new String[50];

        FilterTableModel(String fileTypeHeader, String filterHeader) {
            super(new Object[]{fileTypeHeader, filterHeader}, 0);
            this.addRow(new Object[]{"ActionScript", null});
            this.styles[0] = "text/actionscript";
            this.addRow(new Object[]{"Assembler (6502)", null});
            this.styles[1] = "text/asm6502";
            this.addRow(new Object[]{"Assembler (x86)", null});
            this.styles[2] = "text/asm";
            this.addRow(new Object[]{"BBCode", null});
            this.styles[3] = "text/bbcode";
            this.addRow(new Object[]{"C", null});
            this.styles[4] = "text/c";
            this.addRow(new Object[]{"C++", null});
            this.styles[5] = "text/cpp";
            this.addRow(new Object[]{"C#", null});
            this.styles[6] = "text/cs";
            this.addRow(new Object[]{"Clojure", null});
            this.styles[7] = "text/clojure";
            this.addRow(new Object[]{"CSS", null});
            this.styles[8] = "text/css";
            this.addRow(new Object[]{"CSV", null});
            this.styles[9] = "text/csv";
            this.addRow(new Object[]{"D", null});
            this.styles[10] = "text/d";
            this.addRow(new Object[]{"Delphi", null});
            this.styles[11] = "text/delphi";
            this.addRow(new Object[]{"Dockerfile", null});
            this.styles[12] = "text/dockerfile";
            this.addRow(new Object[]{"DTD", null});
            this.styles[13] = "text/dtd";
            this.addRow(new Object[]{"Flex", null});
            this.styles[14] = "text/mxml";
            this.addRow(new Object[]{"Fortran", null});
            this.styles[15] = "text/fortran";
            this.addRow(new Object[]{"Go", null});
            this.styles[16] = "text/golang";
            this.addRow(new Object[]{"Groovy", null});
            this.styles[17] = "text/groovy";
            this.addRow(new Object[]{"Handlebars", null});
            this.styles[18] = "text/handlebars";
            this.addRow(new Object[]{"Hosts", null});
            this.styles[19] = "text/hosts";
            this.addRow(new Object[]{"htaccess", null});
            this.styles[20] = "text/htaccess";
            this.addRow(new Object[]{"HTML", null});
            this.styles[21] = "text/html";
            this.addRow(new Object[]{"INI", null});
            this.styles[22] = "text/ini";
            this.addRow(new Object[]{"Java", null});
            this.styles[23] = "text/java";
            this.addRow(new Object[]{"JavaScript", null});
            this.styles[24] = "text/javascript";
            this.addRow(new Object[]{"JSP", null});
            this.styles[25] = "text/jsp";
            this.addRow(new Object[]{"JSON", null});
            this.styles[26] = "text/json";
            this.addRow(new Object[]{"JSON with comments", null});
            this.styles[27] = "text/jshintrc";
            this.addRow(new Object[]{"LaTeX", null});
            this.styles[28] = "text/latex";
            this.addRow(new Object[]{"Less", null});
            this.styles[29] = "text/less";
            this.addRow(new Object[]{"Lisp", null});
            this.styles[30] = "text/lisp";
            this.addRow(new Object[]{"Lua", null});
            this.styles[31] = "text/lua";
            this.addRow(new Object[]{"Make", null});
            this.styles[32] = "text/makefile";
            this.addRow(new Object[]{"NSIS", null});
            this.styles[33] = "text/nsis";
            this.addRow(new Object[]{"Perl", null});
            this.styles[34] = "text/perl";
            this.addRow(new Object[]{"PHP", null});
            this.styles[35] = "text/php";
            this.addRow(new Object[]{"Properties files", null});
            this.styles[36] = "text/properties";
            this.addRow(new Object[]{"Protobuf definitions", null});
            this.styles[37] = "text/proto";
            this.addRow(new Object[]{"Python", null});
            this.styles[38] = "text/python";
            this.addRow(new Object[]{"Ruby", null});
            this.styles[39] = "text/ruby";
            this.addRow(new Object[]{"SAS", null});
            this.styles[40] = "text/sas";
            this.addRow(new Object[]{"Scala", null});
            this.styles[41] = "text/scala";
            this.addRow(new Object[]{"SQL", null});
            this.styles[42] = "text/sql";
            this.addRow(new Object[]{"Tcl", null});
            this.styles[43] = "text/tcl";
            this.addRow(new Object[]{"TypeScript", null});
            this.styles[44] = "text/typescript";
            this.addRow(new Object[]{"UNIX shell scripts", null});
            this.styles[45] = "text/unix";
            this.addRow(new Object[]{"Visual Basic", null});
            this.styles[46] = "text/vb";
            this.addRow(new Object[]{"Windows Batch", null});
            this.styles[47] = "text/bat";
            this.addRow(new Object[]{"XML", null});
            this.styles[48] = "text/xml";
            this.addRow(new Object[]{"YAML", null});
            this.styles[49] = "text/yaml";
        }
    }

    private final class FileFilterRowHandler
    extends AbstractRowHandler {
        private FileFilterRowHandler() {
        }

        public Object[] getNewRowInfo(Object[] oldData) {
            String prompt;
            String input;
            String oldValue = (String)oldData[1];
            String filterType = (String)oldData[0];
            while ((input = JOptionPane.showInputDialog((Component)((Object)FileFilterOptionPanel.this), prompt = FileFilterOptionPanel.this.rtext.getString("FileFilterPrompt", new Object[]{filterType}), oldValue)) != null && !SyntaxFilters.isValidFileFilterString(input)) {
                String temp = FileFilterOptionPanel.this.rtext.getString("InvalidFFString", new Object[]{input});
                JOptionPane.showMessageDialog((Component)((Object)FileFilterOptionPanel.this), temp, FileFilterOptionPanel.this.rtext.getString("ErrorDialogTitle", new Object[0]), 0);
            }
            if (input != null) {
                return new Object[]{oldData[0], input};
            }
            return null;
        }

        public boolean canRemoveRow(int row) {
            return false;
        }
    }
}

