/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OS;
import org.fife.ui.OptionsDialog;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.RDirectoryChooser;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

class GeneralOptionPanel
extends OptionsDialogPanel
implements ActionListener,
DocumentListener {
    private final JTextField dirField;
    private final JButton dirBrowseButton;
    private final LabelValueComboBox<String, String> terminatorCombo;
    private final JComboBox<String> encCombo;
    private final JCheckBox utf8BomCB;
    private final JCheckBox sizeCheckCB;
    private final JFormattedTextField sizeField;
    private final JCheckBox dropShadowsInEditorCB;
    private String fileSizeError;
    private static final String TERM_CR = "\r";
    private static final String TERM_LF = "\n";
    private static final String TERM_CRLF = "\r\n";
    private static final String TERM_SYSTEM = System.getProperty("line.separator");

    GeneralOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptGenName"));
        this.fileSizeError = msg.getString("OptGenFileSizeError");
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptNewFileTitle")));
        JPanel newFilePanel = new JPanel(new SpringLayout());
        temp.add(newFilePanel);
        JLabel dirLabel = new JLabel(msg.getString("OptNewFileWD"));
        this.dirField = new JTextField(40);
        this.dirField.getDocument().addDocumentListener(this);
        dirLabel.setLabelFor(this.dirField);
        this.dirBrowseButton = new JButton(msg.getString("Browse"));
        this.dirBrowseButton.setActionCommand("Browse");
        this.dirBrowseButton.addActionListener(this);
        if (orientation.isLeftToRight()) {
            newFilePanel.add(dirLabel);
            newFilePanel.add(this.dirField);
            newFilePanel.add(this.dirBrowseButton);
        } else {
            newFilePanel.add(this.dirBrowseButton);
            newFilePanel.add(this.dirField);
            newFilePanel.add(dirLabel);
        }
        JLabel newlineLabel = new JLabel(msg.getString("LineTerminator"));
        this.terminatorCombo = new LabelValueComboBox();
        UIUtil.fixComboOrientation(this.terminatorCombo);
        this.terminatorCombo.addLabelValuePair((Object)msg.getString("SysDef"), (Object)TERM_SYSTEM);
        this.terminatorCombo.addLabelValuePair((Object)msg.getString("CR"), (Object)TERM_CR);
        this.terminatorCombo.addLabelValuePair((Object)msg.getString("LF"), (Object)TERM_LF);
        this.terminatorCombo.addLabelValuePair((Object)msg.getString("CRLF"), (Object)TERM_CRLF);
        this.terminatorCombo.setSelectedValue((Object)TERM_SYSTEM);
        this.terminatorCombo.setActionCommand("LineTerminator");
        this.terminatorCombo.addActionListener((ActionListener)this);
        if (orientation.isLeftToRight()) {
            newFilePanel.add(newlineLabel);
            newFilePanel.add((Component)this.terminatorCombo);
            newFilePanel.add(Box.createRigidArea(new Dimension(1, 1)));
        } else {
            newFilePanel.add(Box.createRigidArea(new Dimension(1, 1)));
            newFilePanel.add((Component)this.terminatorCombo);
            newFilePanel.add(newlineLabel);
        }
        JLabel encLabel = new JLabel(msg.getString("OptNewFileEncoding"));
        this.encCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.encCombo);
        SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
        for (String key : availableCharsets.keySet()) {
            this.encCombo.addItem(key);
        }
        this.encCombo.setActionCommand("Encoding");
        this.encCombo.addActionListener(this);
        if (orientation.isLeftToRight()) {
            newFilePanel.add(encLabel);
            newFilePanel.add(this.encCombo);
            newFilePanel.add(Box.createRigidArea(new Dimension(1, 1)));
        } else {
            newFilePanel.add(Box.createRigidArea(new Dimension(1, 1)));
            newFilePanel.add(this.encCombo);
            newFilePanel.add(encLabel);
        }
        UIUtil.makeSpringCompactGrid((Container)newFilePanel, (int)3, (int)3, (int)5, (int)5, (int)5, (int)5);
        this.addLeftAligned(temp, newFilePanel);
        topPanel.add(temp);
        topPanel.add(Box.createVerticalStrut(5));
        Box otherPanel = Box.createVerticalBox();
        otherPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptOtherTitle")));
        temp = new JPanel();
        temp.setLayout(new BoxLayout(temp, 2));
        this.utf8BomCB = new JCheckBox(msg.getString("OptBOMInUtf8Files"));
        this.utf8BomCB.setActionCommand("Utf8BomCB");
        this.utf8BomCB.addActionListener(this);
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add((Component)this.utf8BomCB, "Before");
        otherPanel.add(temp2);
        this.sizeCheckCB = new JCheckBox(msg.getString("OptWarnIfFileLargerThan"));
        this.sizeCheckCB.setActionCommand("SizeCheckCB");
        this.sizeCheckCB.addActionListener(this);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(1);
        this.sizeField = new JFormattedTextField(format);
        this.sizeField.getDocument().addDocumentListener(this);
        this.sizeField.setColumns(8);
        this.sizeField.setEditable(false);
        temp2 = new JPanel(new BorderLayout());
        temp.add(this.sizeCheckCB);
        temp.add(Box.createHorizontalStrut(5));
        temp.add(this.sizeField);
        temp.add(Box.createHorizontalGlue());
        temp2.add((Component)temp, "Before");
        otherPanel.add(temp2);
        topPanel.add(otherPanel);
        Box expPanel = Box.createVerticalBox();
        expPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptExperimentalTitle")));
        SelectableLabel label = new SelectableLabel(msg.getString("ExperimentalDisclaimer"));
        expPanel.add((Component)label);
        expPanel.add(Box.createVerticalStrut(10));
        this.dropShadowsInEditorCB = new JCheckBox(msg.getString("DropShadowsInEditor"));
        this.dropShadowsInEditorCB.addActionListener(this);
        this.addLeftAligned(expPanel, this.dropShadowsInEditorCB);
        expPanel.add(Box.createVerticalGlue());
        topPanel.add(expPanel);
        topPanel.add(Box.createVerticalStrut(5));
        JButton rdButton = new JButton(msg.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this);
        this.addLeftAligned(topPanel, rdButton);
        this.add(topPanel, "North");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Browse".equals(command)) {
            File dir;
            OptionsDialog od = this.getOptionsDialog();
            RDirectoryChooser dc = new RDirectoryChooser((Dialog)od);
            String dirName = this.dirField.getText().trim();
            if (dirName.length() > 0) {
                File dir2 = new File(dirName);
                dc.setChosenDirectory(dir2);
            }
            dc.setVisible(true);
            String chosenDir = dc.getChosenDirectory();
            if (chosenDir != null && (dir = new File(chosenDir)).isDirectory() && !chosenDir.equals(this.dirField.getText())) {
                this.dirField.setText(chosenDir);
                this.setDirty(true);
            }
        } else if ("LineTerminator".equals(command)) {
            this.setDirty(true);
        } else if ("Encoding".equals(command)) {
            this.setDirty(true);
        } else if ("Utf8BomCB".equals(command)) {
            this.setDirty(true);
        } else if ("SizeCheckCB".equals(command)) {
            boolean sizeCheck = this.sizeCheckCB.isSelected();
            this.sizeField.setEditable(sizeCheck);
            this.setDirty(true);
        } else if (this.dropShadowsInEditorCB == e.getSource()) {
            this.setDirty(true);
        } else if ("RestoreDefaults".equals(command)) {
            boolean defaultDropShadowsInEditor;
            String defaultEncName = RTextFileChooser.getDefaultEncoding();
            String defaultEnc = Charset.forName(defaultEncName).name();
            boolean defaultUtf8BomSelected = false;
            float defaultSizeFieldValue = 25.0f;
            boolean bl = defaultDropShadowsInEditor = OS.get() == OS.WINDOWS;
            if (this.dirField.getDocument().getLength() > 0 || this.terminatorCombo.getSelectedIndex() != 0 || !this.encCombo.getSelectedItem().equals(defaultEnc) || this.utf8BomCB.isSelected() != defaultUtf8BomSelected || !this.sizeCheckCB.isSelected() || 25.0f != ((Number)this.sizeField.getValue()).floatValue() || this.dropShadowsInEditorCB.isSelected() != defaultDropShadowsInEditor) {
                this.dirField.setText(null);
                this.terminatorCombo.setSelectedIndex(0);
                this.encCombo.setSelectedItem(defaultEnc);
                this.setDefaultEncoding(defaultEncName);
                this.utf8BomCB.setSelected(defaultUtf8BomSelected);
                this.setDoFileSizeCheck(true);
                this.sizeField.setValue(Float.valueOf(25.0f));
                this.dropShadowsInEditorCB.setSelected(defaultDropShadowsInEditor);
                this.setDirty(true);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        rtext.setWorkingDirectory(this.getWorkingDirectory());
        mainView.setLineTerminator(this.getLineTerminator());
        mainView.setDefaultEncoding(this.getDefaultEncoding());
        mainView.setWriteBOMInUtf8Files(this.getWriteUtf8BOM());
        mainView.setDoFileSizeCheck(this.getDoFileSizeCheck());
        mainView.setMaxFileSize(this.getMaxFileSize());
        RTextUtilities.setDropShadowsEnabledInEditor(this.dropShadowsInEditorCB.isSelected());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        float maxFileSize = this.getMaxFileSize();
        if (maxFileSize < 0.0f) {
            return new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this, (JComponent)this.sizeField, this.fileSizeError);
        }
        return null;
    }

    public String getDefaultEncoding() {
        return (String)this.encCombo.getSelectedItem();
    }

    public boolean getDoFileSizeCheck() {
        return this.sizeCheckCB.isSelected();
    }

    public String getLineTerminator() {
        return (String)this.terminatorCombo.getSelectedValue();
    }

    public float getMaxFileSize() {
        Number num = (Number)this.sizeField.getValue();
        return num == null ? -1.0f : num.floatValue();
    }

    public JComponent getTopJComponent() {
        return this.dirBrowseButton;
    }

    public boolean getWriteUtf8BOM() {
        return this.utf8BomCB.isSelected();
    }

    public String getWorkingDirectory() {
        return this.dirField.getText();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setDirty(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setDirty(true);
    }

    private void setDefaultEncoding(String encoding) {
        Charset cs2;
        String item;
        int i;
        if (encoding == null) {
            encoding = RTextFileChooser.getDefaultEncoding();
        }
        Charset cs1 = Charset.forName(encoding);
        int count = this.encCombo.getItemCount();
        for (i = 0; i < count; ++i) {
            item = this.encCombo.getItemAt(i);
            cs2 = Charset.forName(item);
            if (!cs1.equals(cs2)) continue;
            this.encCombo.setSelectedIndex(i);
            return;
        }
        cs1 = Charset.forName(RTextFileChooser.getDefaultEncoding());
        for (i = 0; i < count; ++i) {
            item = this.encCombo.getItemAt(i);
            cs2 = Charset.forName(item);
            if (!cs1.equals(cs2)) continue;
            this.encCombo.setSelectedIndex(i);
            return;
        }
    }

    private void setDoFileSizeCheck(boolean doCheck) {
        this.sizeCheckCB.setSelected(doCheck);
        this.sizeField.setEditable(doCheck);
    }

    private void setLineTerminator(String terminator) {
        this.terminatorCombo.setSelectedValue((Object)terminator);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setWorkingDirectory(rtext.getWorkingDirectory());
        this.setLineTerminator(mainView.getLineTerminator());
        this.setDefaultEncoding(mainView.getDefaultEncoding());
        this.setWriteUtf8BOM(mainView.getWriteBOMInUtf8Files());
        this.setDoFileSizeCheck(mainView.getDoFileSizeCheck());
        this.sizeField.setValue(Float.valueOf(mainView.getMaxFileSize()));
        this.dropShadowsInEditorCB.setSelected(RTextUtilities.getDropShadowsEnabledInEditor());
    }

    private void setWriteUtf8BOM(boolean write) {
        this.utf8BomCB.setSelected(write);
    }

    private void setWorkingDirectory(String directory) {
        this.dirField.setText(directory);
    }
}

