/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.fife.rtext.RText;
import org.fife.rtext.optionsdialog.FileFilterOptionPanel;
import org.fife.rtext.optionsdialog.GeneralOptionPanel;
import org.fife.rtext.optionsdialog.LanguageOptionPanel;
import org.fife.rtext.optionsdialog.PrintingOptionPanel;
import org.fife.rtext.optionsdialog.SearchOptionPanel;
import org.fife.rtext.optionsdialog.UIOptionPanel;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.Plugin;
import org.fife.ui.app.PluginOptionsDialogPanel;
import org.fife.ui.app.icons.IconGroup;
import org.fife.ui.app.options.ShortcutOptionPanel;
import org.fife.ui.rsyntaxtextarea.CaretAndSelectionOptionPanel;
import org.fife.ui.rsyntaxtextarea.FontAndTabsOptionPanel;
import org.fife.ui.rsyntaxtextarea.GutterOptionPanel;
import org.fife.ui.rsyntaxtextarea.HighlightsOptionPanel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.RTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.SpellingOptionPanel;
import org.fife.ui.rsyntaxtextarea.TemplateOptionPanel;
import org.fife.ui.rtextfilechooser.FileChooserFavoritesOptionPanel;
import org.fife.ui.rtextfilechooser.RTextFileChooserOptionPanel;

public class OptionsDialog
extends org.fife.ui.OptionsDialog {
    private RText rtext;
    private OptionsDialogPanel generalPanel;
    private OptionsDialogPanel uiPanel;
    private OptionsDialogPanel languagePanel;
    private OptionsDialogPanel rtaPanel;
    private OptionsDialogPanel searchPanel;
    private OptionsDialogPanel fileChooserPanel;
    private OptionsDialogPanel filtersPanel;
    private OptionsDialogPanel shortcutPanel;

    public OptionsDialog(RText rtext) {
        super((Frame)((Object)rtext));
        Plugin[] plugins;
        this.rtext = rtext;
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.rtext.OptionsDialog");
        ArrayList<OptionsDialogPanel> panels = new ArrayList<OptionsDialogPanel>();
        this.generalPanel = new GeneralOptionPanel(rtext, msg);
        panels.add(this.generalPanel);
        this.uiPanel = new UIOptionPanel(rtext, msg);
        panels.add(this.uiPanel);
        this.languagePanel = new LanguageOptionPanel((GUIApplication)rtext, msg);
        this.uiPanel.addChildPanel(this.languagePanel);
        this.rtaPanel = new RTextAreaOptionPanel();
        panels.add(this.rtaPanel);
        this.rtaPanel.addChildPanel((OptionsDialogPanel)new FontAndTabsOptionPanel());
        RSyntaxTextAreaOptionPanel rstaPanel = new RSyntaxTextAreaOptionPanel();
        this.rtaPanel.addChildPanel((OptionsDialogPanel)rstaPanel);
        rstaPanel.addChildPanel(new CaretAndSelectionOptionPanel());
        rstaPanel.addChildPanel(new HighlightsOptionPanel());
        rstaPanel.addChildPanel(new GutterOptionPanel());
        this.rtaPanel.addChildPanel((OptionsDialogPanel)new SpellingOptionPanel());
        this.rtaPanel.addChildPanel((OptionsDialogPanel)new TemplateOptionPanel());
        this.searchPanel = new SearchOptionPanel((GUIApplication)rtext, msg);
        panels.add(this.searchPanel);
        this.fileChooserPanel = new RTextFileChooserOptionPanel();
        panels.add(this.fileChooserPanel);
        this.fileChooserPanel.addChildPanel((OptionsDialogPanel)new FileChooserFavoritesOptionPanel());
        PrintingOptionPanel printPanel = new PrintingOptionPanel(rtext, msg);
        panels.add(printPanel);
        this.filtersPanel = new FileFilterOptionPanel(rtext, msg);
        panels.add(this.filtersPanel);
        this.shortcutPanel = new ShortcutOptionPanel((AbstractGUIApplication)rtext);
        panels.add(this.shortcutPanel);
        for (Plugin plugin : plugins = rtext.getPlugins()) {
            PluginOptionsDialogPanel panel = plugin.getOptionsDialogPanel();
            if (panel == null) continue;
            panel.setIcon(plugin.getPluginIcon());
            String parentID = plugin.getOptionsDialogPanelParentPanelID();
            if (parentID != null) {
                OptionsDialogPanel parent = OptionsDialog.getPanelById(panels, parentID);
                if (parent != null) {
                    parent.addChildPanel((OptionsDialogPanel)panel);
                    continue;
                }
                panels.add((OptionsDialogPanel)panel);
                continue;
            }
            panels.add((OptionsDialogPanel)panel);
        }
        rtext.addPropertyChangeListener("iconStyle", e -> this.updateIcons());
        this.updateIcons();
        OptionsDialogPanel[] array = new OptionsDialogPanel[panels.size()];
        array = panels.toArray(array);
        this.setOptionsPanels(array);
    }

    private static OptionsDialogPanel getPanelById(List<OptionsDialogPanel> panels, String id) {
        for (OptionsDialogPanel panel : panels) {
            OptionsDialogPanel result = OptionsDialog.getPanelByIdImpl(panel, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static OptionsDialogPanel getPanelByIdImpl(OptionsDialogPanel panel, String id) {
        if (id.equals(panel.getId())) {
            return panel;
        }
        for (int i = 0; i < panel.getChildPanelCount(); ++i) {
            OptionsDialogPanel child = panel.getChildPanel(i);
            OptionsDialogPanel result = OptionsDialog.getPanelByIdImpl(child, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void updateIcons() {
        IconGroup iconGroup = this.rtext.getIconGroup();
        this.generalPanel.setIcon(iconGroup.getIcon("options_general"));
        this.uiPanel.setIcon(iconGroup.getIcon("options_ui"));
        this.languagePanel.setIcon(iconGroup.getIcon("options_language"));
        this.rtaPanel.setIcon(iconGroup.getIcon("options_textarea"));
        this.searchPanel.setIcon(iconGroup.getIcon("options_search"));
        this.fileChooserPanel.setIcon(iconGroup.getIcon("options_file_chooser"));
        this.filtersPanel.setIcon(iconGroup.getIcon("options_file_filters"));
        this.shortcutPanel.setIcon(iconGroup.getIcon("options_shortcuts"));
    }
}

