/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.FontSelector;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.UIUtil;

class PrintingOptionPanel
extends OptionsDialogPanel
implements PropertyChangeListener {
    private final FontSelector fontSelector;

    PrintingOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptPrName"));
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setLayout(new BorderLayout());
        this.setBorder(UIUtil.getEmpty5Border());
        Box topPanel = Box.createVerticalBox();
        JPanel printFontPanel = new JPanel(new BorderLayout());
        printFontPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptPrFTitle")));
        this.fontSelector = new FontSelector();
        this.fontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        printFontPanel.add((Component)this.fontSelector);
        topPanel.add(printFontPanel);
        topPanel.add(Box.createVerticalStrut(5));
        Box printHeaderFooterPanel = Box.createVerticalBox();
        printHeaderFooterPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptPrHFL")));
        JCheckBox headerCheckBox = new JCheckBox(msg.getString("OptPrPH"));
        JCheckBox footerCheckBox = new JCheckBox(msg.getString("OptPrPF"));
        headerCheckBox.setEnabled(false);
        footerCheckBox.setEnabled(false);
        this.addLeftAligned(printHeaderFooterPanel, headerCheckBox, 3);
        this.addLeftAligned(printHeaderFooterPanel, footerCheckBox);
        topPanel.add(printHeaderFooterPanel);
        this.add(topPanel, "North");
        this.applyComponentOrientation(orientation);
        this.setIcon((Icon)rtext.getAction("printAction").getValue("SmallIcon"));
        rtext.addPropertyChangeListener("iconStyle", e -> this.setIcon((Icon)rtext.getAction("printAction").getValue("SmallIcon")));
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setPrintFont(this.getPrintFont());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("font")) {
            this.setDirty(true);
        }
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    private Font getPrintFont() {
        return this.fontSelector.getDisplayedFont();
    }

    public JComponent getTopJComponent() {
        return this.fontSelector;
    }

    private void setPrintFont(Font printFont) {
        if (printFont == null) {
            printFont = new Font("Monospaced", 0, 9);
        }
        this.fontSelector.setDisplayedFont(printFont, false);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setPrintFont(mainView.getPrintFont());
    }
}

