/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.SearchManager;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.app.GUIApplication;
import org.fife.util.TranslucencyUtil;

class SearchOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ChangeListener {
    private final JRadioButton dialogRB;
    private final JRadioButton toolbarRB;
    private final JCheckBox translucentSearchDialogsCB;
    private final JLabel ruleLabel;
    private final LabelValueComboBox<String, String> ruleCombo;
    private final JLabel opacityLabel;
    private final JSlider slider;
    private final JLabel opacityDisplay;
    private final DecimalFormat format = new DecimalFormat("0%");
    private static final String PROPERTY = "property";

    SearchOptionPanel(GUIApplication app, ResourceBundle msg) {
        super(msg.getString("OptSearchOptionsName"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = Box.createVerticalBox();
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        Box generalPanel = Box.createVerticalBox();
        generalPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptGenTitle")));
        ButtonGroup bg = new ButtonGroup();
        this.dialogRB = UIUtil.newRadio((ResourceBundle)msg, (String)"Search.UIType.Dialog", (ButtonGroup)bg, (ActionListener)this);
        this.addLeftAligned(generalPanel, this.dialogRB, 3);
        this.toolbarRB = UIUtil.newRadio((ResourceBundle)msg, (String)"Search.UIType.Toolbar", (ButtonGroup)bg, (ActionListener)this);
        this.addLeftAligned(generalPanel, this.toolbarRB);
        topPanel.add(generalPanel);
        topPanel.add(Box.createVerticalStrut(5));
        Box expPanel = Box.createVerticalBox();
        expPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptExperimentalTitle")));
        SelectableLabel label = new SelectableLabel(msg.getString("ExperimentalDisclaimer"));
        this.addLeftAligned(expPanel, (Component)label, 3);
        this.translucentSearchDialogsCB = new JCheckBox(msg.getString("TranslucentSearchBoxes"));
        this.translucentSearchDialogsCB.setActionCommand("TranslucentSearchDialogsCB");
        this.translucentSearchDialogsCB.addActionListener(this);
        this.addLeftAligned(expPanel, this.translucentSearchDialogsCB, 3);
        this.ruleLabel = new JLabel(msg.getString("TranslucencyRule"));
        this.ruleCombo = new LabelValueComboBox();
        this.ruleCombo.addLabelValuePair((Object)msg.getString("Translucency.Never"), (Object)"0");
        this.ruleCombo.addLabelValuePair((Object)msg.getString("Translucency.WhenNotFocused"), (Object)"1");
        this.ruleCombo.addLabelValuePair((Object)msg.getString("Translucency.WhenOverlappingApp"), (Object)"2");
        this.ruleCombo.addLabelValuePair((Object)msg.getString("Translucency.Always"), (Object)"3");
        this.ruleCombo.setActionCommand("TranslucencyRuleChanged");
        this.ruleCombo.addActionListener((ActionListener)this);
        this.opacityLabel = new JLabel(msg.getString("Opacity"));
        this.slider = new JSlider(0, 100);
        this.slider.setMajorTickSpacing(20);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(false);
        this.slider.addChangeListener(this);
        this.opacityDisplay = new JLabel("100%"){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = Math.max(50, size.width);
                return size;
            }
        };
        this.opacityDisplay.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Component filler = Box.createRigidArea(new Dimension(1, 1));
        JPanel temp = new JPanel(new SpringLayout());
        if (o.isLeftToRight()) {
            temp.add(this.ruleLabel);
            temp.add((Component)this.ruleCombo);
            temp.add(filler);
            temp.add(this.opacityLabel);
            temp.add(this.slider);
            temp.add(this.opacityDisplay);
        } else {
            temp.add(filler);
            temp.add((Component)this.ruleCombo);
            temp.add(this.ruleLabel);
            temp.add(this.opacityDisplay);
            temp.add(this.slider);
            temp.add(this.opacityLabel);
        }
        UIUtil.makeSpringCompactGrid((Container)temp, (int)2, (int)3, (int)0, (int)0, (int)5, (int)5);
        this.addLeftAligned(expPanel, temp, 0, 20);
        expPanel.add(Box.createVerticalStrut(5));
        topPanel.add(expPanel);
        JButton defaultsButton = new JButton(msg.getString("RestoreDefaults"));
        defaultsButton.setActionCommand("RestoreDefaults");
        defaultsButton.addActionListener(this);
        this.addLeftAligned(topPanel, defaultsButton);
        if (TranslucencyUtil.get().isTranslucencySupported(false)) {
            this.setTranslucentSearchDialogsSelected(false);
        }
        this.add(topPanel, "North");
        this.applyComponentOrientation(o);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String command = e.getActionCommand();
        if (this.dialogRB == source) {
            this.setUseSearchToolbars(false);
            this.setDirty(true);
        } else if (this.toolbarRB == source) {
            this.setUseSearchToolbars(true);
            this.setDirty(true);
        } else if (this.translucentSearchDialogsCB == source) {
            boolean selected = this.translucentSearchDialogsCB.isSelected();
            this.setTranslucentSearchDialogsSelected(selected);
            this.setDirty(true);
        } else if (this.ruleCombo == source) {
            this.setDirty(true);
        } else if ("RestoreDefaults".equals(command)) {
            int defaultOpacity = 60;
            if (this.dialogRB.isSelected() || this.translucentSearchDialogsCB.isSelected() || this.ruleCombo.getSelectedIndex() != 2 || this.slider.getValue() != 60) {
                this.setUseSearchToolbars(true);
                this.setTranslucentSearchDialogsSelected(false);
                this.ruleCombo.setSelectedIndex(2);
                this.slider.setValue(60);
                this.setDirty(true);
            }
        }
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        SearchManager.SearchingMode mode = this.dialogRB.isSelected() ? SearchManager.SearchingMode.DIALOGS : SearchManager.SearchingMode.TOOLBARS;
        rtext.getMainView().getSearchManager().setSearchingMode(mode);
        rtext.setSearchWindowOpacityEnabled(this.translucentSearchDialogsCB.isSelected());
        int rule = Integer.parseInt((String)this.ruleCombo.getSelectedValue());
        rtext.setSearchWindowOpacityRule(rule);
        float opacity = (float)this.slider.getValue() / 100.0f;
        rtext.setSearchWindowOpacity(opacity);
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public JComponent getTopJComponent() {
        return this.dialogRB;
    }

    private void setTranslucentSearchDialogsSelected(boolean selected) {
        this.translucentSearchDialogsCB.setSelected(selected);
        if (!TranslucencyUtil.get().isTranslucencySupported(false)) {
            this.translucentSearchDialogsCB.setEnabled(false);
            selected = false;
        }
        this.ruleLabel.setEnabled(selected);
        this.ruleCombo.setEnabled(selected);
        this.opacityLabel.setEnabled(selected);
        this.opacityDisplay.setEnabled(selected);
        this.slider.setEnabled(selected);
    }

    private void setUseSearchToolbars(boolean use) {
        if (use) {
            this.toolbarRB.setSelected(true);
            this.translucentSearchDialogsCB.setEnabled(false);
            this.ruleLabel.setEnabled(false);
            this.ruleCombo.setEnabled(false);
            this.opacityLabel.setEnabled(false);
            this.opacityDisplay.setEnabled(false);
            this.slider.setEnabled(false);
        } else {
            this.dialogRB.setSelected(true);
            this.translucentSearchDialogsCB.setEnabled(true);
            this.setTranslucentSearchDialogsSelected(this.translucentSearchDialogsCB.isSelected());
        }
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setTranslucentSearchDialogsSelected(rtext.isSearchWindowOpacityEnabled());
        this.ruleCombo.setSelectedIndex(rtext.getSearchWindowOpacityRule());
        int percent = (int)(rtext.getSearchWindowOpacity() * 100.0f);
        this.slider.setValue(percent);
        this.opacityDisplay.setText(this.format.format(rtext.getSearchWindowOpacity()));
        SearchManager.SearchingMode sm = mainView.getSearchManager().getSearchingMode();
        this.setUseSearchToolbars(sm == SearchManager.SearchingMode.TOOLBARS);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        float value = (float)this.slider.getValue() / 100.0f;
        this.opacityDisplay.setText(this.format.format(value));
        this.setDirty(true);
    }
}

