/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OptionsDialog;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.app.AppTheme;

public class UIOptionPanel
extends OptionsDialogPanel
implements ActionListener,
PropertyChangeListener {
    public static final String OPTION_PANEL_ID = "UIOptionPanel";
    private final RText rtext;
    private LabelValueComboBox<String, AppTheme> themeCombo;
    private JButton applyButton;
    private JPanel springPanel;
    private JComboBox<String> viewCombo;
    private JComboBox<String> docSelCombo;
    private JCheckBox showHostNameCheckBox;

    UIOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptUIName"));
        this.setId(OPTION_PANEL_ID);
        this.rtext = rtext;
        Listener listener = new Listener();
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box cp = Box.createVerticalBox();
        cp.add(this.createThemePanel(msg, listener));
        cp.add(Box.createVerticalStrut(10));
        cp.add(this.createLayoutPanel(msg));
        cp.add(this.createOtherPanel(msg));
        this.add(cp, "North");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand;
        switch (actionCommand = e.getActionCommand()) {
            case "ViewComboBox": 
            case "ShowHostNameCB": 
            case "AppThemeComboBox": {
                this.setDirty(true);
            }
        }
    }

    private void applySelectedTheme() {
        AppTheme theme = (AppTheme)this.themeCombo.getSelectedValue();
        RText rtext = (RText)((Object)this.getOptionsDialog().getOwner());
        RTextUtilities.setThemeForAllOpenAppInstances(rtext, theme);
        rtext.getMainView().setOverrideEditorStyles(false);
        OptionsDialog dialog = this.getOptionsDialog();
        dialog.getPanelById("RTextAreaOptionPanel").setValues((Frame)((Object)rtext));
        dialog.getPanelById("RTextAreaOptionPanel").setValues((Frame)((Object)rtext));
        this.getOptionsDialog().broadcast("appTheme:" + theme);
    }

    private LabelValueComboBox<String, AppTheme> createAppThemeComboBox() {
        LabelValueComboBox combo = new LabelValueComboBox();
        UIUtil.fixComboOrientation((JComboBox)combo);
        for (AppTheme theme : this.rtext.getAppThemes()) {
            combo.addLabelValuePair((Object)theme.getName(), (Object)theme);
        }
        return combo;
    }

    private JPanel createLayoutPanel(ResourceBundle msg) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.viewCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.viewCombo);
        this.viewCombo.setActionCommand("ViewComboBox");
        this.viewCombo.addActionListener(this);
        this.viewCombo.addItem(msg.getString("OptUITV"));
        this.viewCombo.addItem(msg.getString("OptUISPV"));
        this.viewCombo.addItem(msg.getString("OptUIMDIV"));
        this.docSelCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.docSelCombo);
        this.docSelCombo.setActionCommand("DocSelCombo");
        this.docSelCombo.addActionListener(this);
        this.docSelCombo.addItem(msg.getString("OptUITop"));
        this.docSelCombo.addItem(msg.getString("OptUILeft"));
        this.docSelCombo.addItem(msg.getString("OptUIBottom"));
        this.docSelCombo.addItem(msg.getString("OptUIRight"));
        this.springPanel = new JPanel(new SpringLayout());
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptUILT")));
        UIUtil.addLabelValuePairs((Container)this.springPanel, (ComponentOrientation)orientation, (Component[])new Component[]{new JLabel(msg.getString("OptUIViewT")), this.viewCombo, new JLabel(msg.getString("OptUIDSPT")), this.docSelCombo});
        temp.add((Component)this.springPanel, "Before");
        UIUtil.makeSpringCompactGrid((Container)this.springPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        return temp;
    }

    private Container createOtherPanel(ResourceBundle msg) {
        Box temp = Box.createVerticalBox();
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptOtherTitle")));
        JPanel showHostNamePanel = new JPanel(new BorderLayout());
        this.showHostNameCheckBox = new JCheckBox(msg.getString("OptUIShowHostName"));
        this.showHostNameCheckBox.setActionCommand("ShowHostNameCB");
        this.showHostNameCheckBox.addActionListener(this);
        showHostNamePanel.add((Component)this.showHostNameCheckBox, "Before");
        temp.add(showHostNamePanel);
        temp.add(Box.createVerticalGlue());
        return temp;
    }

    private Container createThemePanel(ResourceBundle msg, Listener listener) {
        Box temp = Box.createVerticalBox();
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptThemeLabel")));
        SelectableLabel label = new SelectableLabel();
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        label.setText(msg.getString("OptThemeDesc"));
        temp.add((Component)label, "North");
        this.themeCombo = this.createAppThemeComboBox();
        this.themeCombo.setActionCommand("AppThemeComboBox");
        this.themeCombo.addActionListener((ActionListener)this);
        UIUtil.fixComboOrientation(this.themeCombo);
        Box temp2 = this.createHorizontalBox();
        temp2.add((Component)this.themeCombo);
        temp2.add(Box.createHorizontalStrut(5));
        this.applyButton = UIUtil.newButton((ResourceBundle)msg, (String)"OptThemeApply", (ActionListener)listener);
        temp2.add(this.applyButton);
        temp2.add(Box.createHorizontalGlue());
        temp2.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        temp.add(temp2);
        return temp;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setDocumentSelectionPlacement(this.getDocumentSelectionPlacement());
        this.applySelectedTheme();
        rtext.setMainViewStyle(this.getMainViewStyle());
        rtext.setShowHostName(this.showHostNameCheckBox.isSelected());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    private int getDocumentSelectionPlacement() {
        return this.docSelCombo.getSelectedIndex() + 1;
    }

    private int getMainViewStyle() {
        return this.viewCombo.getSelectedIndex();
    }

    private AppTheme getTheme() {
        return (AppTheme)this.themeCombo.getSelectedValue();
    }

    public JComponent getTopJComponent() {
        return this.themeCombo;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if (propName.equals("RColorButton.colorChanged")) {
            this.setDirty(true);
        }
    }

    private void setDocumentSelectionPlacement(int documentSelectionPlacement) {
        if (documentSelectionPlacement != 2 && documentSelectionPlacement != 4 && documentSelectionPlacement != 1 && documentSelectionPlacement != 3) {
            documentSelectionPlacement = 1;
        }
        this.docSelCombo.setSelectedIndex(documentSelectionPlacement - 1);
    }

    private void setTheme(AppTheme theme) {
        for (int i = 0; i < this.themeCombo.getItemCount(); ++i) {
            AppTheme comboTheme = (AppTheme)this.themeCombo.getValueAt(i);
            if (!comboTheme.getName().equals(theme.getName())) continue;
            this.themeCombo.setSelectedIndex(i);
            return;
        }
        this.themeCombo.setSelectedIndex(0);
    }

    private void setMainViewStyle(int viewStyle) {
        if (viewStyle != 0 && viewStyle != 1 && viewStyle != 2) {
            viewStyle = 0;
        }
        this.viewCombo.setSelectedIndex(viewStyle);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setDocumentSelectionPlacement(mainView.getDocumentSelectionPlacement());
        this.setTheme(rtext.getTheme());
        this.setMainViewStyle(rtext.getMainViewStyle());
        this.showHostNameCheckBox.setSelected(rtext.getShowHostName());
    }

    public void updateUI() {
        super.updateUI();
        if (this.springPanel != null) {
            UIUtil.makeSpringCompactGrid((Container)this.springPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        }
    }

    private final class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (UIOptionPanel.this.applyButton == source) {
                UIOptionPanel.this.applySelectedTheme();
            }
        }
    }
}

