/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContext;
import org.fife.ui.rsyntaxtextarea.EditorOptionsPreviewContextListener;

abstract class AbstractTextAreaOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ItemListener,
EditorOptionsPreviewContextListener {
    protected JCheckBox overrideCheckBox;
    protected boolean processingEditorOptionsPreviewContextChanges;
    protected static final int COMPONENT_VERTICAL_SPACING = 3;
    protected static final int SECTION_VERTICAL_SPACING = 5;
    protected static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.TextAreaOptionPanel");
    private static final ResourceBundle DIALOG_MSG = ResourceBundle.getBundle("org.fife.rtext.OptionsDialog");

    AbstractTextAreaOptionPanel() {
        EditorOptionsPreviewContext.get().addListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("RestoreDefaults".equals(command)) {
            this.handleRestoreDefaults();
        }
    }

    protected JComponent createOverridePanel() {
        this.overrideCheckBox = UIUtil.newCheckBox((ResourceBundle)MSG, (String)"OverrideTheme");
        this.overrideCheckBox.addItemListener(this);
        this.overrideCheckBox.putClientProperty("always.ignore", Boolean.TRUE);
        this.overrideCheckBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        Box temp = Box.createHorizontalBox();
        temp.add(this.overrideCheckBox);
        temp.add(Box.createHorizontalGlue());
        return temp;
    }

    protected JComponent createRestoreDefaultsPanel() {
        Box rdPanel = this.createHorizontalBox();
        JButton rdButton = new JButton(MSG.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this);
        rdButton.putClientProperty("always.ignore", Boolean.TRUE);
        rdPanel.add(rdButton);
        rdPanel.add(Box.createHorizontalGlue());
        return rdPanel;
    }

    @Override
    public final void editorOptionsPreviewContextChanged(EditorOptionsPreviewContext context) {
        this.processingEditorOptionsPreviewContextChanges = true;
        try {
            this.editorOptionsPreviewContextChangedImpl(context);
        }
        finally {
            this.processingEditorOptionsPreviewContextChanges = false;
        }
    }

    protected void editorOptionsPreviewContextChangedImpl(EditorOptionsPreviewContext context) {
        boolean overrideEditorTheme = context.getOverrideEditorTheme();
        if (this.overrideCheckBox != null && this.overrideCheckBox.isSelected() != overrideEditorTheme) {
            this.overrideCheckBox.setSelected(overrideEditorTheme);
        }
    }

    protected String getString(String key) {
        if (MSG.containsKey(key)) {
            return MSG.getString(key);
        }
        return DIALOG_MSG.getString(key);
    }

    public JComponent getTopJComponent() {
        return this.overrideCheckBox;
    }

    protected abstract void handleRestoreDefaults();

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (this.overrideCheckBox == source) {
            boolean overrideTheme = e.getStateChange() == 1;
            this.setOverrideTheme(overrideTheme);
        }
    }

    protected void setComponentsEnabled(boolean enabled, Component ... ignore) {
        UIUtil.setComponentsEnabled((Container)((Object)this), (boolean)enabled, (Component[])ignore);
    }

    public void setDirty(boolean dirty) {
        if (dirty && !this.getOptionsDialog().isInitializing() && !this.processingEditorOptionsPreviewContextChanges) {
            this.syncEditorOptionsPreviewContext();
        }
        super.setDirty(dirty);
    }

    private void setOverrideTheme(boolean overrideTheme) {
        this.setComponentsEnabled(overrideTheme, new Component[0]);
        this.setDirty(true);
    }

    protected abstract void syncEditorOptionsPreviewContext();
}

